/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.uri;

import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.codec.EncoderBase;
import net.pwall.pipeline.uri.URIEncoder;
import net.pwall.util.IntOutput;

public class SchemaURIEncoder<R>
extends EncoderBase<R> {
    private final boolean encodeSpaceAsPlus;

    public SchemaURIEncoder(IntAcceptor<? extends R> downstream, boolean encodeSpaceAsPlus) {
        super(downstream);
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public SchemaURIEncoder(IntAcceptor<? extends R> downstream) {
        this(downstream, false);
    }

    @Override
    public void acceptInt(int value) {
        if (value == 32 && this.encodeSpaceAsPlus) {
            this.emit(43);
        } else if (!URIEncoder.isUnreservedURI(value) && value != 36) {
            this.emit(37);
            IntOutput.output2Hex((int)value, this::emit);
        } else {
            this.emit(value);
        }
    }
}

