/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.uri;

import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.codec.ErrorStrategy;
import net.pwall.pipeline.codec.ErrorStrategyBase;

public class URIDecoder<R>
extends ErrorStrategyBase<R> {
    private State state = State.NORMAL;
    private int character;

    public URIDecoder(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
    }

    public URIDecoder(IntAcceptor<? extends R> downstream) {
        this(downstream, ErrorStrategy.DEFAULT);
    }

    @Override
    public void acceptInt(int value) {
        switch (this.state) {
            case NORMAL: {
                if (value == 37) {
                    this.state = State.FIRST;
                    break;
                }
                if (value == 43) {
                    this.emit(32);
                    break;
                }
                this.emit(value);
                break;
            }
            case FIRST: {
                this.character = this.fromHex(value) << 4;
                this.state = State.SECOND;
                break;
            }
            case SECOND: {
                this.emit(this.character | this.fromHex(value));
                this.state = State.NORMAL;
            }
        }
    }

    private int fromHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 90) {
            return ch - 65 + 10;
        }
        if (ch >= 97 && ch <= 122) {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("Illegal hex character - " + (char)ch);
    }

    static enum State {
        NORMAL,
        FIRST,
        SECOND;

    }
}

