/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.xxml;

import net.pwall.pipeline.AbstractIntPipeline;
import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.xxml.MappingEntry;

public class DecoderBase<R>
extends AbstractIntPipeline<R> {
    private final MappingEntry[] table;
    private final StringBuilder sb;
    private int number;
    private State state;

    public DecoderBase(MappingEntry[] table, IntAcceptor<? extends R> downstream) {
        super(downstream);
        this.table = table;
        this.sb = new StringBuilder(4);
        this.state = State.NORMAL;
    }

    @Override
    public void acceptInt(int value) {
        switch (this.state) {
            case NORMAL: {
                if (value == 38) {
                    this.state = State.AMPERSAND;
                    break;
                }
                this.emit(value);
                break;
            }
            case AMPERSAND: {
                if (value >= 65 && value <= 90 || value >= 97 && value <= 122) {
                    this.sb.setLength(0);
                    this.sb.append((char)value);
                    this.state = State.CHARS;
                    break;
                }
                if (value == 35) {
                    this.number = 0;
                    this.state = State.HASH;
                    break;
                }
                throw new IllegalArgumentException("Illegal escape sequence");
            }
            case CHARS: {
                if ((value >= 65 && value <= 90 || value >= 97 && value <= 122) && this.sb.length() < 12) {
                    this.sb.append((char)value);
                    break;
                }
                if (value == 59) {
                    this.state = State.NORMAL;
                    String entity = this.sb.toString();
                    int lo = 0;
                    int hi = this.table.length;
                    while (lo < hi) {
                        int mid = lo + hi >>> 1;
                        MappingEntry entry = this.table[mid];
                        String entryString = entry.getString();
                        if (entity.equals(entryString)) {
                            this.emit(entry.getCodePoint());
                            return;
                        }
                        if (entity.compareTo(entryString) < 0) {
                            hi = mid;
                            continue;
                        }
                        lo = mid + 1;
                    }
                    throw new IllegalArgumentException("Illegal escape sequence");
                }
                throw new IllegalArgumentException("Illegal escape sequence");
            }
            case HASH: {
                if (value >= 48 && value <= 57) {
                    this.number = value - 48;
                    this.state = State.DIGITS;
                    break;
                }
                if (value == 120) {
                    this.number = 0;
                    this.state = State.HEX;
                    break;
                }
                throw new IllegalArgumentException("Illegal escape sequence");
            }
            case DIGITS: {
                if (value >= 48 && value <= 57 && this.number < 9999999) {
                    this.number = this.number * 10 + value - 48;
                    break;
                }
                if (value == 59) {
                    this.emit(this.number);
                    this.state = State.NORMAL;
                    break;
                }
                throw new IllegalArgumentException("Illegal escape sequence");
            }
            case HEX: {
                if (value >= 48 && value <= 57 && this.number < 0xFFFFFF) {
                    this.number = this.number << 4 | value - 48;
                    break;
                }
                if (value >= 65 && value <= 70) {
                    this.number = this.number << 4 | value - 65 + 10;
                    break;
                }
                if (value >= 97 && value <= 102) {
                    this.number = this.number << 4 | value - 97 + 10;
                    break;
                }
                if (value == 59) {
                    this.emit(this.number);
                    this.state = State.NORMAL;
                    break;
                }
                throw new IllegalArgumentException("Illegal escape sequence");
            }
        }
    }

    static enum State {
        NORMAL,
        AMPERSAND,
        CHARS,
        HASH,
        DIGITS,
        HEX;

    }
}

