/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.yaml;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.pwall.log.Logger;
import net.pwall.log.LoggerUtilKt;
import net.pwall.util.ListMap;
import net.pwall.util.ParseText;
import net.pwall.util.Strings;
import net.pwall.yaml.YAMLBoolean;
import net.pwall.yaml.YAMLDecimal;
import net.pwall.yaml.YAMLDocument;
import net.pwall.yaml.YAMLException;
import net.pwall.yaml.YAMLInt;
import net.pwall.yaml.YAMLLong;
import net.pwall.yaml.YAMLMapping;
import net.pwall.yaml.YAMLNode;
import net.pwall.yaml.YAMLScalar;
import net.pwall.yaml.YAMLSequence;
import net.pwall.yaml.YAMLSimple;
import net.pwall.yaml.YAMLString;
import net.pwall.yaml.parser.Line;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0012%&'()*+,-./0123456B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u0017*\u00020\n2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\bJ\u0014\u0010\u001f\u001a\u00020 *\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\bJ\u0014\u0010!\u001a\u00020\"*\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\bJ\u0014\u0010#\u001a\u00020$*\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lnet/pwall/yaml/YAMLSimple;", "", "()V", "log", "Lnet/pwall/log/Logger;", "fatal", "", "message", "", "line", "Lnet/pwall/yaml/parser/Line;", "process", "Lnet/pwall/yaml/YAMLDocument;", "file", "Ljava/io/File;", "inputStream", "Ljava/io/InputStream;", "reader", "Ljava/io/Reader;", "processYAMLDirective", "Lkotlin/Pair;", "", "warn", "", "processBackslash", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "processDoubleQuotedScalar", "Lnet/pwall/yaml/YAMLSimple$DoubleQuotedScalar;", "initial", "processFlowNode", "Lnet/pwall/yaml/YAMLSimple$FlowNode;", "processPlainScalar", "Lnet/pwall/yaml/YAMLSimple$PlainScalar;", "processSingleQuotedScalar", "Lnet/pwall/yaml/YAMLSimple$SingleQuotedScalar;", "Block", "BlockScalar", "Child", "ChildBlock", "DoubleQuotedScalar", "ErrorBlock", "FlowMapping", "FlowNode", "FlowScalar", "FlowSequence", "FoldedBlockScalar", "InitialBlock", "LiteralBlockScalar", "MappingBlock", "PlainScalar", "SequenceBlock", "SingleQuotedScalar", "State", "yaml-simple"})
public final class YAMLSimple {
    @NotNull
    public static final YAMLSimple INSTANCE = new YAMLSimple();
    @NotNull
    private static final Logger log = LoggerUtilKt.getLogger();

    private YAMLSimple() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final YAMLDocument process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            YAMLDocument yAMLDocument = INSTANCE.process(it);
            return yAMLDocument;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final YAMLDocument process(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        return this.process(new InputStreamReader(inputStream2, charset));
    }

    @NotNull
    public final YAMLDocument process(@NotNull Reader reader) {
        YAMLDocument yAMLDocument;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Ref.ObjectRef state = new Ref.ObjectRef();
        state.element = State.INITIAL;
        Ref.ObjectRef version = new Ref.ObjectRef();
        InitialBlock outerBlock = new InitialBlock(0);
        Ref.IntRef lineNumber = new Ref.IntRef();
        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(lineNumber, (Ref.ObjectRef<State>)state, (Ref.ObjectRef<Pair<Integer, Integer>>)version, outerBlock){
            final /* synthetic */ Ref.IntRef $lineNumber;
            final /* synthetic */ Ref.ObjectRef<State> $state;
            final /* synthetic */ Ref.ObjectRef<Pair<Integer, Integer>> $version;
            final /* synthetic */ InitialBlock $outerBlock;
            {
                this.$lineNumber = $lineNumber;
                this.$state = $state;
                this.$version = $version;
                this.$outerBlock = $outerBlock;
                super(1);
            }

            public final void invoke(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ++this.$lineNumber.element;
                Line line = new Line(this.$lineNumber.element, text);
                switch (process.WhenMappings.$EnumSwitchMapping$0[((State)((Object)this.$state.element)).ordinal()]) {
                    case 1: {
                        if (StringsKt.startsWith$default((String)text, (String)"%YAML", (boolean)false, (int)2, null)) {
                            this.$version.element = YAMLSimple.access$processYAMLDirective(YAMLSimple.INSTANCE, line);
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((CharSequence)text, (char)'%', (boolean)false, (int)2, null)) {
                            YAMLSimple.access$warn(YAMLSimple.INSTANCE, "Unrecognised directive ignored - " + text);
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$state.element = State.MAIN;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (line.atEnd()) break;
                        this.$state.element = State.MAIN;
                        this.$outerBlock.processLine(line);
                        break;
                    }
                    case 2: {
                        if (StringsKt.startsWith$default((String)text, (String)"%YAML", (boolean)false, (int)2, null)) {
                            YAMLSimple.access$fatal(YAMLSimple.INSTANCE, "Duplicate or misplaced %YAML directive", line);
                            throw new KotlinNothingValueException();
                        }
                        if (StringsKt.startsWith$default((CharSequence)text, (char)'%', (boolean)false, (int)2, null)) {
                            YAMLSimple.access$warn(YAMLSimple.INSTANCE, "Unrecognised directive ignored - " + text);
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$state.element = State.MAIN;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (line.atEnd()) break;
                        YAMLSimple.access$fatal(YAMLSimple.INSTANCE, "Illegal data following directive(s)", line);
                        throw new KotlinNothingValueException();
                    }
                    case 3: {
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            YAMLSimple.access$fatal(YAMLSimple.INSTANCE, "Multiple documents not allowed", line);
                            throw new KotlinNothingValueException();
                        }
                        if (line.isExhausted() || line.matchHash()) {
                            this.$outerBlock.processBlankLine(line);
                            break;
                        }
                        this.$outerBlock.processLine(line);
                        break;
                    }
                    case 4: {
                        if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0)) break;
                        YAMLSimple.access$fatal(YAMLSimple.INSTANCE, "Non-blank lines after end of document", line);
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }));
        YAMLNode rootNode = outerBlock.conclude(new Line(lineNumber.element, ""));
        log.debug(() -> YAMLSimple.process$lambda$1(rootNode));
        Pair pair = (Pair)version.element;
        if (pair != null) {
            Pair it = pair;
            boolean bl = false;
            yAMLDocument = new YAMLDocument(rootNode, ((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        } else {
            yAMLDocument = new YAMLDocument(rootNode);
        }
        return yAMLDocument;
    }

    private final Pair<Integer, Integer> processYAMLDirective(Line line) {
        line.skip(5);
        if (!line.matchSpaces() || !line.matchDec()) {
            this.fatal("Illegal %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        int majorVersion = line.getResultInt();
        if (!line.match('.') || !line.matchDec()) {
            this.fatal("Illegal version number on %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        int minorVersion = line.getResultInt();
        if (majorVersion != 1) {
            this.fatal("%YAML version must be 1.x", line);
            throw new KotlinNothingValueException();
        }
        line.skipSpaces();
        if (!line.atEnd()) {
            this.fatal("Illegal data on %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        if (!(1 <= minorVersion ? minorVersion < 3 : false)) {
            this.warn("Unexpected YAML version - " + majorVersion + '.' + minorVersion);
        }
        return TuplesKt.to((Object)majorVersion, (Object)minorVersion);
    }

    private final void warn(String message) {
        log.warn(() -> YAMLSimple.warn$lambda$3(message));
    }

    private final Void fatal(String message, Line line) {
        YAMLException exception = new YAMLException(message, line, null, 4, null);
        log.error(() -> YAMLSimple.fatal$lambda$4(exception));
        throw exception;
    }

    @NotNull
    public final PlainScalar processPlainScalar(@NotNull Line $this$processPlainScalar, @NotNull String initial) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$processPlainScalar), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        StringBuilder sb = new StringBuilder(initial);
        while (!$this$processPlainScalar.isExhausted()) {
            if ($this$processPlainScalar.matchColon()) {
                $this$processPlainScalar.revert();
                $this$processPlainScalar.skipBackSpaces();
                break;
            }
            if ($this$processPlainScalar.matchHash()) {
                $this$processPlainScalar.skipBackSpaces();
                break;
            }
            sb.append($this$processPlainScalar.getChar());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return new PlainScalar(((Object)StringsKt.trim((CharSequence)string)).toString());
    }

    public static /* synthetic */ PlainScalar processPlainScalar$default(YAMLSimple yAMLSimple, Line line, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return yAMLSimple.processPlainScalar(line, string);
    }

    @NotNull
    public final FlowNode processFlowNode(@NotNull Line $this$processFlowNode, @NotNull String initial) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$processFlowNode), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        StringBuilder sb = new StringBuilder(initial);
        while (!$this$processFlowNode.isExhausted()) {
            if ($this$processFlowNode.matchAnyOf("[]{},")) {
                FlowNode flowNode;
                $this$processFlowNode.revert();
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                FlowNode it = flowNode = new FlowNode(((Object)StringsKt.trim((CharSequence)string)).toString());
                boolean bl = false;
                it.setTerminated(true);
                return flowNode;
            }
            if ($this$processFlowNode.matchColon()) {
                $this$processFlowNode.revert();
                $this$processFlowNode.skipBackSpaces();
                break;
            }
            if ($this$processFlowNode.matchHash()) {
                $this$processFlowNode.skipBackSpaces();
                break;
            }
            sb.append($this$processFlowNode.getChar());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return new FlowNode(((Object)StringsKt.trim((CharSequence)string)).toString());
    }

    public static /* synthetic */ FlowNode processFlowNode$default(YAMLSimple yAMLSimple, Line line, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return yAMLSimple.processFlowNode(line, string);
    }

    @NotNull
    public final SingleQuotedScalar processSingleQuotedScalar(@NotNull Line $this$processSingleQuotedScalar, @NotNull String initial) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$processSingleQuotedScalar), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        StringBuilder sb = new StringBuilder(initial);
        while (!$this$processSingleQuotedScalar.isExhausted()) {
            if ($this$processSingleQuotedScalar.match('\'')) {
                if ($this$processSingleQuotedScalar.match('\'')) {
                    sb.append('\'');
                    continue;
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                return new SingleQuotedScalar(string, true);
            }
            sb.append($this$processSingleQuotedScalar.getChar());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return new SingleQuotedScalar(string, false);
    }

    public static /* synthetic */ SingleQuotedScalar processSingleQuotedScalar$default(YAMLSimple yAMLSimple, Line line, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return yAMLSimple.processSingleQuotedScalar(line, string);
    }

    @NotNull
    public final DoubleQuotedScalar processDoubleQuotedScalar(@NotNull Line $this$processDoubleQuotedScalar, @NotNull String initial) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$processDoubleQuotedScalar), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        StringBuilder sb = new StringBuilder(initial);
        while (!$this$processDoubleQuotedScalar.isExhausted()) {
            if ($this$processDoubleQuotedScalar.match('\"')) {
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                return new DoubleQuotedScalar(string, true, false, 4, null);
            }
            if ($this$processDoubleQuotedScalar.match('\\')) {
                if ($this$processDoubleQuotedScalar.isExhausted()) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                    return new DoubleQuotedScalar(string, false, true);
                }
                this.processBackslash($this$processDoubleQuotedScalar, sb);
                continue;
            }
            sb.append($this$processDoubleQuotedScalar.getChar());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return new DoubleQuotedScalar(string, false, false, 4, null);
    }

    public static /* synthetic */ DoubleQuotedScalar processDoubleQuotedScalar$default(YAMLSimple yAMLSimple, Line line, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return yAMLSimple.processDoubleQuotedScalar(line, string);
    }

    private final void processBackslash(Line $this$processBackslash, StringBuilder sb) {
        if ($this$processBackslash.match('0')) {
            sb.append('\u0000');
        } else if ($this$processBackslash.match('a')) {
            sb.append('\u0007');
        } else if ($this$processBackslash.match('b')) {
            sb.append('\b');
        } else if ($this$processBackslash.match('t')) {
            sb.append('\t');
        } else if ($this$processBackslash.match('\t')) {
            sb.append('\t');
        } else if ($this$processBackslash.match('n')) {
            sb.append('\n');
        } else if ($this$processBackslash.match('v')) {
            sb.append('\u000b');
        } else if ($this$processBackslash.match('f')) {
            sb.append('\f');
        } else if ($this$processBackslash.match('r')) {
            sb.append('\r');
        } else if ($this$processBackslash.match('e')) {
            sb.append('\u001b');
        } else if ($this$processBackslash.match(' ')) {
            sb.append(' ');
        } else if ($this$processBackslash.match('\"')) {
            sb.append('\"');
        } else if ($this$processBackslash.match('/')) {
            sb.append('/');
        } else if ($this$processBackslash.match('\\')) {
            sb.append('\\');
        } else if ($this$processBackslash.match('N')) {
            sb.append('\u0085');
        } else if ($this$processBackslash.match('_')) {
            sb.append('\u00a0');
        } else if ($this$processBackslash.match('L')) {
            sb.append('\u2028');
        } else if ($this$processBackslash.match('P')) {
            sb.append('\u2029');
        } else if ($this$processBackslash.match('x')) {
            if (!$this$processBackslash.matchHexFixed(2)) {
                this.fatal("Illegal hex value in double quoted scalar", $this$processBackslash);
                throw new KotlinNothingValueException();
            }
            sb.append((char)$this$processBackslash.getResultHexInt());
        } else if ($this$processBackslash.match('u')) {
            if (!$this$processBackslash.matchHexFixed(4)) {
                this.fatal("Illegal unicode value in double quoted scalar", $this$processBackslash);
                throw new KotlinNothingValueException();
            }
            sb.append((char)$this$processBackslash.getResultHexInt());
        } else if ($this$processBackslash.match('U')) {
            if (!$this$processBackslash.matchHexFixed(8)) {
                this.fatal("Illegal unicode value in double quoted scalar", $this$processBackslash);
                throw new KotlinNothingValueException();
            }
            try {
                Strings.appendUTF16((Appendable)sb, (int)$this$processBackslash.getResultHexInt());
            }
            catch (IllegalArgumentException e) {
                this.fatal("Illegal 32-bit unicode value in double quoted scalar", $this$processBackslash);
                throw new KotlinNothingValueException();
            }
        } else {
            this.fatal("Illegal escape sequence in double quoted scalar", $this$processBackslash);
            throw new KotlinNothingValueException();
        }
    }

    private static final Object process$lambda$1(YAMLNode $rootNode) {
        String type = $rootNode == null ? "null" : Reflection.getOrCreateKotlinClass($rootNode.getClass()).getSimpleName();
        return "Parse complete; result is " + type;
    }

    private static final Object warn$lambda$3(String $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        return "YAML Warning: " + $message;
    }

    private static final Object fatal$lambda$4(YAMLException $exception) {
        Intrinsics.checkNotNullParameter((Object)((Object)$exception), (String)"$exception");
        return $exception.getMessage();
    }

    public static final /* synthetic */ Pair access$processYAMLDirective(YAMLSimple $this, Line line) {
        return $this.processYAMLDirective(line);
    }

    public static final /* synthetic */ void access$warn(YAMLSimple $this, String message) {
        $this.warn(message);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/pwall/yaml/YAMLSimple$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "DIRECTIVE", "MAIN", "ENDED", "yaml-simple"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIAL = new State();
        public static final /* enum */ State DIRECTIVE = new State();
        public static final /* enum */ State MAIN = new State();
        public static final /* enum */ State ENDED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.INITIAL, State.DIRECTIVE, State.MAIN, State.ENDED};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lnet/pwall/yaml/YAMLSimple$Block;", "", "indent", "", "(I)V", "getIndent", "()I", "conclude", "Lnet/pwall/yaml/YAMLNode;", "line", "Lnet/pwall/yaml/parser/Line;", "processBlankLine", "", "processLine", "yaml-simple"})
    public static abstract class Block {
        private final int indent;

        public Block(int indent) {
            this.indent = indent;
        }

        public final int getIndent() {
            return this.indent;
        }

        public abstract void processLine(@NotNull Line var1);

        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
        }

        @Nullable
        public abstract YAMLNode conclude(@NotNull Line var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnet/pwall/yaml/YAMLSimple$ErrorBlock;", "Lnet/pwall/yaml/YAMLSimple$Block;", "()V", "conclude", "", "line", "Lnet/pwall/yaml/parser/Line;", "processLine", "yaml-simple"})
    public static final class ErrorBlock
    extends Block {
        @NotNull
        public static final ErrorBlock INSTANCE = new ErrorBlock();

        private ErrorBlock() {
            super(0);
        }

        @NotNull
        public Void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            INSTANCE.fatal("Should not happen", line);
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            INSTANCE.fatal("Should not happen", line);
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/pwall/yaml/YAMLSimple$InitialBlock;", "Lnet/pwall/yaml/YAMLSimple$Block;", "indent", "", "(I)V", "child", "node", "Lnet/pwall/yaml/YAMLNode;", "state", "Lnet/pwall/yaml/YAMLSimple$InitialBlock$State;", "conclude", "line", "Lnet/pwall/yaml/parser/Line;", "processBlankLine", "", "processFirstLine", "processLine", "State", "yaml-simple"})
    public static final class InitialBlock
    extends Block {
        @NotNull
        private State state = State.INITIAL;
        @Nullable
        private YAMLNode node;
        @NotNull
        private Block child = ErrorBlock.INSTANCE;

        public InitialBlock(int indent) {
            super(indent);
        }

        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processFirstLine(line);
                    break;
                }
                case 2: {
                    this.child.processLine(line);
                    break;
                }
                case 3: {
                    INSTANCE.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        private final void processFirstLine(Line line) {
            FlowSequence it;
            Child child;
            Child child2;
            int initialIndex = line.getIndex();
            if (line.atEnd()) {
                return;
            }
            if (line.matchDash()) {
                this.child = new SequenceBlock(initialIndex);
                if (!line.atEnd()) {
                    this.child.processLine(line);
                }
                this.state = State.CHILD;
                return;
            }
            if (line.match('\"')) {
                child2 = YAMLSimple.processDoubleQuotedScalar$default(INSTANCE, line, null, 1, null);
            } else if (line.match('\'')) {
                child2 = YAMLSimple.processSingleQuotedScalar$default(INSTANCE, line, null, 1, null);
            } else if (line.match('[')) {
                it = child = new FlowSequence(false);
                boolean bl = false;
                it.continuation(line);
                child2 = child;
            } else if (line.match('{')) {
                it = child = new FlowMapping(false);
                boolean bl = false;
                ((FlowMapping)((Object)it)).continuation(line);
                child2 = child;
            } else {
                if (line.match('?')) {
                    line.skipSpaces();
                    this.child = new MappingBlock(initialIndex);
                    if (!line.atEnd()) {
                        this.child.processLine(line);
                    }
                    this.state = State.CHILD;
                    return;
                }
                if (line.match(':')) {
                    INSTANCE.fatal("Mapping value without key", line);
                    throw new KotlinNothingValueException();
                }
                child2 = YAMLSimple.processPlainScalar$default(INSTANCE, line, null, 1, null);
            }
            Child scalar = child2;
            line.skipSpaces();
            if (line.matchColon()) {
                if (line.atEnd()) {
                    this.child = new MappingBlock(initialIndex, ((Object)scalar.getText()).toString());
                    this.state = State.CHILD;
                } else {
                    this.child = new MappingBlock(initialIndex, ((Object)scalar.getText()).toString(), line);
                    this.state = State.CHILD;
                }
            } else if (scalar.getTerminated()) {
                this.node = scalar.getYAMLNode();
                this.state = State.CLOSED;
            } else {
                this.child = new ChildBlock(initialIndex, scalar);
                this.state = State.CHILD;
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.processBlankLine(line);
                }
            }
        }

        @Override
        @Nullable
        public YAMLNode conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.node = this.child.conclude(line);
                }
            }
            this.state = State.CLOSED;
            return this.node;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/pwall/yaml/YAMLSimple$InitialBlock$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CHILD", "CLOSED", "yaml-simple"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CHILD, State.CLOSED};
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.INITIAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CHILD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CLOSED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0018B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/pwall/yaml/YAMLSimple$MappingBlock;", "Lnet/pwall/yaml/YAMLSimple$Block;", "indent", "", "key", "", "(ILjava/lang/String;)V", "line", "Lnet/pwall/yaml/parser/Line;", "(ILjava/lang/String;Lnet/pwall/yaml/parser/Line;)V", "(I)V", "child", "properties", "Lnet/pwall/util/ListMap;", "Lnet/pwall/yaml/YAMLNode;", "state", "Lnet/pwall/yaml/YAMLSimple$MappingBlock$State;", "conclude", "Lnet/pwall/yaml/YAMLMapping;", "processBlankLine", "", "processColon", "processLine", "processQM", "State", "yaml-simple"})
    public static final class MappingBlock
    extends Block {
        @NotNull
        private State state;
        @NotNull
        private Block child;
        @NotNull
        private final ListMap<String, YAMLNode> properties;
        @NotNull
        private String key;

        public MappingBlock(int indent) {
            super(indent);
            this.state = State.QM_CHILD;
            this.child = new InitialBlock(indent + 1);
            this.properties = new ListMap();
            this.key = "";
        }

        public MappingBlock(int indent, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this(indent);
            this.key = key;
            this.child = new InitialBlock(indent + 1);
            this.state = State.CHILD;
        }

        public MappingBlock(int indent, @NotNull String key, @NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            this(indent);
            this.key = key;
            this.child = new ChildBlock(indent + 1);
            this.child.processLine(line);
            this.state = State.CHILD;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            int effectiveIndent = line.getIndex();
            if (line.matchDash()) {
                effectiveIndent = line.getIndex();
                line.revert();
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processQM(line);
                    break;
                }
                case 2: {
                    String string;
                    String string2;
                    if (line.getIndex() >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    MappingBlock mappingBlock = this;
                    YAMLNode yAMLNode = this.child.conclude(line);
                    if (yAMLNode != null) {
                        void it;
                        YAMLNode yAMLNode2 = yAMLNode;
                        MappingBlock mappingBlock2 = mappingBlock;
                        boolean bl = false;
                        string2 = it instanceof YAMLString ? ((YAMLString)it).getValue() : it.toString();
                        mappingBlock = mappingBlock2;
                    } else {
                        string2 = string = null;
                    }
                    if (string2 == null) {
                        string = mappingBlock.key = "null";
                    }
                    if (this.properties.containsKey((Object)this.key)) {
                        INSTANCE.fatal("Duplicate key in mapping - " + this.key, line);
                        throw new KotlinNothingValueException();
                    }
                    this.state = State.COLON;
                    this.processColon(line);
                    break;
                }
                case 3: {
                    this.processColon(line);
                    break;
                }
                case 4: {
                    if (effectiveIndent >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    ((Map)this.properties).put(this.key, this.child.conclude(line));
                    this.state = State.KEY;
                    this.processQM(line);
                    break;
                }
                case 5: {
                    INSTANCE.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: 
                case 4: {
                    this.child.processBlankLine(line);
                }
            }
        }

        private final void processQM(Line line) {
            if (line.match('?')) {
                line.skipSpaces();
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getIndent() + 1);
                } else {
                    this.child = new InitialBlock(line.getIndex());
                    this.child.processLine(line);
                }
                this.state = State.QM_CHILD;
            } else {
                if (line.atEnd()) {
                    return;
                }
                FlowScalar scalar = line.match('\"') ? (FlowScalar)YAMLSimple.processDoubleQuotedScalar$default(INSTANCE, line, null, 1, null) : (line.match('\'') ? (FlowScalar)YAMLSimple.processSingleQuotedScalar$default(INSTANCE, line, null, 1, null) : (FlowScalar)YAMLSimple.processPlainScalar$default(INSTANCE, line, null, 1, null));
                line.skipSpaces();
                if (line.matchColon()) {
                    this.key = scalar.getText();
                    if (this.properties.containsKey((Object)this.key)) {
                        INSTANCE.fatal("Duplicate key in mapping - " + this.key, line);
                        throw new KotlinNothingValueException();
                    }
                    line.skipSpaces();
                    if (line.isExhausted() || line.matchHash()) {
                        this.child = new InitialBlock(this.getIndent() + 1);
                        this.state = State.CHILD;
                    } else {
                        this.child = new ChildBlock(this.getIndent() + 1);
                        this.child.processLine(line);
                        this.state = State.CHILD;
                    }
                } else {
                    INSTANCE.fatal("Illegal key in mapping", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        private final void processColon(Line line) {
            if (line.match(':')) {
                line.skipSpaces();
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getIndent() + 1);
                } else {
                    this.child = new InitialBlock(line.getIndex());
                    this.child.processLine(line);
                }
            } else {
                INSTANCE.fatal("Unexpected content in block mapping", line);
                throw new KotlinNothingValueException();
            }
            this.state = State.CHILD;
        }

        @NotNull
        public YAMLMapping conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    INSTANCE.fatal("Block mapping value missing", line);
                    throw new KotlinNothingValueException();
                }
                case 4: {
                    ((Map)this.properties).put(this.key, this.child.conclude(line));
                }
            }
            this.state = State.CLOSED;
            return new YAMLMapping((Map)this.properties);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/pwall/yaml/YAMLSimple$MappingBlock$State;", "", "(Ljava/lang/String;I)V", "KEY", "CHILD", "QM_CHILD", "COLON", "CLOSED", "yaml-simple"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State KEY = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State QM_CHILD = new State();
            public static final /* enum */ State COLON = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.KEY, State.CHILD, State.QM_CHILD, State.COLON, State.CLOSED};
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.KEY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.QM_CHILD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.COLON.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CHILD.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CLOSED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/pwall/yaml/YAMLSimple$SequenceBlock;", "Lnet/pwall/yaml/YAMLSimple$Block;", "indent", "", "(I)V", "child", "items", "", "Lnet/pwall/yaml/YAMLNode;", "state", "Lnet/pwall/yaml/YAMLSimple$SequenceBlock$State;", "conclude", "Lnet/pwall/yaml/YAMLSequence;", "line", "Lnet/pwall/yaml/parser/Line;", "processBlankLine", "", "processDash", "processLine", "State", "yaml-simple"})
    public static final class SequenceBlock
    extends Block {
        @NotNull
        private State state = State.CHILD;
        @NotNull
        private final List<YAMLNode> items = new ArrayList();
        @NotNull
        private Block child;

        public SequenceBlock(int indent) {
            super(indent);
            this.child = new InitialBlock(indent + 2);
        }

        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processDash(line);
                    break;
                }
                case 2: {
                    if (line.getIndex() >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    YAMLNode childValue = this.child.conclude(line);
                    this.items.add(childValue);
                    this.state = State.DASH;
                    this.processDash(line);
                    break;
                }
                case 3: {
                    INSTANCE.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.processBlankLine(line);
                }
            }
        }

        private final void processDash(Line line) {
            if (line.matchDash()) {
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getIndent() + 2);
                } else {
                    this.child = new InitialBlock(line.getIndex());
                    this.child.processLine(line);
                }
            } else {
                INSTANCE.fatal("Unexpected content in block sequence", line);
                throw new KotlinNothingValueException();
            }
            this.state = State.CHILD;
        }

        @NotNull
        public YAMLSequence conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.items.add(this.child.conclude(line));
                }
            }
            this.state = State.CLOSED;
            return new YAMLSequence(this.items);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/pwall/yaml/YAMLSimple$SequenceBlock$State;", "", "(Ljava/lang/String;I)V", "DASH", "CHILD", "CLOSED", "yaml-simple"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State DASH = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.DASH, State.CHILD, State.CLOSED};
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.DASH.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CHILD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CLOSED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u000fH\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/pwall/yaml/YAMLSimple$ChildBlock;", "Lnet/pwall/yaml/YAMLSimple$Block;", "indent", "", "scalar", "Lnet/pwall/yaml/YAMLSimple$Child;", "(ILnet/pwall/yaml/YAMLSimple$Child;)V", "(I)V", "child", "node", "Lnet/pwall/yaml/YAMLNode;", "state", "Lnet/pwall/yaml/YAMLSimple$ChildBlock$State;", "conclude", "line", "Lnet/pwall/yaml/parser/Line;", "processBlankLine", "", "processLine", "determineChomping", "Lnet/pwall/yaml/YAMLSimple$BlockScalar$Chomping;", "State", "yaml-simple"})
    public static final class ChildBlock
    extends Block {
        @NotNull
        private State state;
        @NotNull
        private Child child;
        @Nullable
        private YAMLNode node;

        public ChildBlock(int indent) {
            super(indent);
            this.state = State.INITIAL;
            this.child = new PlainScalar("");
        }

        public ChildBlock(int indent, @NotNull Child scalar) {
            Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
            this(indent);
            this.child = scalar;
            this.state = State.CONTINUATION;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void processLine(@NotNull Line line) {
            Child child;
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            ChildBlock childBlock = this;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    if (line.isExhausted()) {
                        return;
                    }
                    if (line.match('#')) {
                        return;
                    }
                    if (line.match('\"')) {
                        child = YAMLSimple.processDoubleQuotedScalar$default(INSTANCE, line, null, 1, null);
                        break;
                    }
                    if (line.match('\'')) {
                        child = YAMLSimple.processSingleQuotedScalar$default(INSTANCE, line, null, 1, null);
                        break;
                    }
                    if (line.match('|')) {
                        BlockScalar.Chomping chomping = this.determineChomping(line);
                        line.skipSpaces();
                        if (!line.matchHash() && !line.isExhausted()) {
                            INSTANCE.fatal("Illegal literal block header", line);
                            throw new KotlinNothingValueException();
                        }
                        child = new LiteralBlockScalar(this.getIndent(), chomping);
                        break;
                    }
                    if (line.match('>')) {
                        BlockScalar.Chomping chomping = this.determineChomping(line);
                        line.skipSpaces();
                        if (!line.matchHash() && !line.isExhausted()) {
                            INSTANCE.fatal("Illegal folded block header", line);
                            throw new KotlinNothingValueException();
                        }
                        child = new FoldedBlockScalar(this.getIndent(), chomping);
                        break;
                    }
                    if (line.match('[')) {
                        void it;
                        FlowSequence flowSequence;
                        FlowSequence flowSequence2 = flowSequence = new FlowSequence(false);
                        ChildBlock childBlock2 = childBlock;
                        boolean bl = false;
                        it.continuation(line);
                        childBlock = childBlock2;
                        child = flowSequence;
                        break;
                    }
                    if (line.match('{')) {
                        FlowMapping flowMapping;
                        FlowMapping it = flowMapping = new FlowMapping(false);
                        ChildBlock childBlock3 = childBlock;
                        boolean bl = false;
                        it.continuation(line);
                        childBlock = childBlock3;
                        child = flowMapping;
                        break;
                    }
                    if (line.match('?')) {
                        INSTANCE.fatal("Can't handle standalone mapping keys", line);
                        throw new KotlinNothingValueException();
                    }
                    if (line.match(':')) {
                        INSTANCE.fatal("Can't handle standalone mapping values", line);
                        throw new KotlinNothingValueException();
                    }
                    child = YAMLSimple.processPlainScalar$default(INSTANCE, line, null, 1, null);
                    break;
                }
                case 2: {
                    child = this.child.continuation(line);
                    break;
                }
                case 3: {
                    INSTANCE.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            childBlock.child = child;
            line.skipSpaces();
            if (line.isExhausted() || line.matchHash()) {
                if (this.child.getTerminated()) {
                    this.node = this.child.getYAMLNode();
                    this.state = State.CLOSED;
                } else {
                    this.state = State.CONTINUATION;
                }
            } else {
                INSTANCE.fatal("Illegal data following scalar", line);
                throw new KotlinNothingValueException();
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.continuation(line);
                }
            }
        }

        @Override
        @Nullable
        public YAMLNode conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.child.getComplete()) {
                        this.node = this.child.getYAMLNode();
                        break;
                    }
                    INSTANCE.fatal("Incomplete scalar", line);
                    throw new KotlinNothingValueException();
                }
            }
            this.state = State.CLOSED;
            return this.node;
        }

        private final BlockScalar.Chomping determineChomping(Line $this$determineChomping) {
            return $this$determineChomping.match('-') ? BlockScalar.Chomping.STRIP : ($this$determineChomping.match('+') ? BlockScalar.Chomping.KEEP : BlockScalar.Chomping.CLIP);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/pwall/yaml/YAMLSimple$ChildBlock$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CONTINUATION", "CLOSED", "yaml-simple"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CONTINUATION, State.CLOSED};
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.INITIAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CONTINUATION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CLOSED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H&R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\u0004R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lnet/pwall/yaml/YAMLSimple$Child;", "", "terminated", "", "(Z)V", "complete", "getComplete", "()Z", "getTerminated", "setTerminated", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lnet/pwall/yaml/parser/Line;", "getYAMLNode", "Lnet/pwall/yaml/YAMLNode;", "yaml-simple"})
    public static abstract class Child {
        private boolean terminated;

        public Child(boolean terminated) {
            this.terminated = terminated;
        }

        public final boolean getTerminated() {
            return this.terminated;
        }

        public final void setTerminated(boolean bl) {
            this.terminated = bl;
        }

        public boolean getComplete() {
            return this.terminated;
        }

        @NotNull
        public abstract CharSequence getText();

        @Nullable
        public abstract YAMLNode getYAMLNode();

        @NotNull
        public abstract Child continuation(@NotNull Line var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lnet/pwall/yaml/YAMLSimple$FlowSequence;", "Lnet/pwall/yaml/YAMLSimple$Child;", "terminated", "", "(Z)V", "child", "items", "", "Lnet/pwall/yaml/YAMLNode;", "key", "", "state", "Lnet/pwall/yaml/YAMLSimple$FlowSequence$State;", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lnet/pwall/yaml/parser/Line;", "getYAMLNode", "Lnet/pwall/yaml/YAMLSequence;", "processLine", "", "State", "yaml-simple"})
    public static final class FlowSequence
    extends Child {
        @NotNull
        private State state = State.ITEM;
        @NotNull
        private Child child = new FlowNode("");
        @Nullable
        private String key;
        @NotNull
        private final List<YAMLNode> items = new ArrayList();

        public FlowSequence(boolean terminated) {
            super(terminated);
        }

        @Override
        @NotNull
        public CharSequence getText() {
            String string = this.getYAMLNode().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getYAMLNode().toString()");
            return string;
        }

        private final void processLine(Line line) {
            while (!line.atEnd()) {
                if (this.state != State.COMMA) {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                        case 1: {
                            Child it;
                            FlowSequence flowSequence;
                            Child child;
                            Child child2;
                            FlowSequence flowSequence2 = this;
                            if (line.match('\"')) {
                                child2 = YAMLSimple.processDoubleQuotedScalar$default(INSTANCE, line, null, 1, null);
                            } else if (line.match('\'')) {
                                child2 = YAMLSimple.processSingleQuotedScalar$default(INSTANCE, line, null, 1, null);
                            } else if (line.match('[')) {
                                child = new FlowSequence(false);
                                FlowSequence flowSequence3 = child;
                                flowSequence = flowSequence2;
                                boolean bl = false;
                                ((FlowSequence)it).continuation(line);
                                flowSequence2 = flowSequence;
                                child2 = child;
                            } else if (line.match('{')) {
                                it = child = new FlowMapping(false);
                                flowSequence = flowSequence2;
                                boolean bl = false;
                                ((FlowMapping)it).continuation(line);
                                flowSequence2 = flowSequence;
                                child2 = child;
                            } else {
                                child2 = YAMLSimple.processFlowNode$default(INSTANCE, line, null, 1, null);
                            }
                            flowSequence2.child = child2;
                            break;
                        }
                        case 2: {
                            this.child = this.child.continuation(line);
                        }
                    }
                    line.skipSpaces();
                    if (line.atEnd()) {
                        this.state = this.child.getTerminated() ? State.COMMA : State.CONTINUATION;
                        break;
                    }
                }
                if (line.match(']')) {
                    if (this.key == null) {
                        YAMLNode yAMLNode = this.child.getYAMLNode();
                        if (yAMLNode != null) {
                            YAMLNode it = yAMLNode;
                            boolean bl = false;
                            this.items.add(it);
                        }
                    } else {
                        this.items.add((YAMLNode)new YAMLMapping(MapsKt.mapOf((Pair)TuplesKt.to((Object)this.key, (Object)this.child.getYAMLNode()))));
                    }
                    this.setTerminated(true);
                    this.state = State.CLOSED;
                    break;
                }
                if (line.matchColon()) {
                    this.key = String.valueOf(this.child.getYAMLNode());
                    this.state = State.ITEM;
                    continue;
                }
                if (line.match(',')) {
                    if (this.key == null) {
                        this.items.add(this.child.getYAMLNode());
                    } else {
                        this.items.add((YAMLNode)new YAMLMapping(MapsKt.mapOf((Pair)TuplesKt.to((Object)this.key, (Object)this.child.getYAMLNode()))));
                    }
                    this.key = null;
                    this.state = State.ITEM;
                    continue;
                }
                INSTANCE.fatal("Unexpected character in flow sequence", line);
                throw new KotlinNothingValueException();
            }
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            if (this.state != State.CLOSED) {
                this.processLine(line);
            }
            return this;
        }

        @NotNull
        public YAMLSequence getYAMLNode() {
            return new YAMLSequence(this.items);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/pwall/yaml/YAMLSimple$FlowSequence$State;", "", "(Ljava/lang/String;I)V", "ITEM", "CONTINUATION", "COMMA", "CLOSED", "yaml-simple"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State ITEM = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State COMMA = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.ITEM, State.CONTINUATION, State.COMMA, State.CLOSED};
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.ITEM.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CONTINUATION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lnet/pwall/yaml/YAMLSimple$FlowMapping;", "Lnet/pwall/yaml/YAMLSimple$Child;", "terminated", "", "(Z)V", "child", "key", "", "properties", "Ljava/util/LinkedHashMap;", "Lnet/pwall/yaml/YAMLNode;", "Lkotlin/collections/LinkedHashMap;", "state", "Lnet/pwall/yaml/YAMLSimple$FlowMapping$State;", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lnet/pwall/yaml/parser/Line;", "getYAMLNode", "Lnet/pwall/yaml/YAMLMapping;", "processLine", "", "State", "yaml-simple"})
    public static final class FlowMapping
    extends Child {
        @NotNull
        private State state = State.ITEM;
        @NotNull
        private Child child = new FlowNode("");
        @Nullable
        private String key;
        @NotNull
        private final LinkedHashMap<String, YAMLNode> properties = new LinkedHashMap();

        public FlowMapping(boolean terminated) {
            super(terminated);
        }

        @Override
        @NotNull
        public CharSequence getText() {
            String string = this.getYAMLNode().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getYAMLNode().toString()");
            return string;
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            if (this.state != State.CLOSED) {
                this.processLine(line);
            }
            return this;
        }

        @NotNull
        public YAMLMapping getYAMLNode() {
            return new YAMLMapping((Map)this.properties);
        }

        private final void processLine(Line line) {
            while (!line.atEnd()) {
                if (this.state != State.COMMA) {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                        case 1: {
                            Child it;
                            FlowMapping flowMapping;
                            Child child;
                            Child child2;
                            FlowMapping flowMapping2 = this;
                            if (line.match('\"')) {
                                child2 = YAMLSimple.processDoubleQuotedScalar$default(INSTANCE, line, null, 1, null);
                            } else if (line.match('\'')) {
                                child2 = YAMLSimple.processSingleQuotedScalar$default(INSTANCE, line, null, 1, null);
                            } else if (line.match('[')) {
                                child = new FlowSequence(false);
                                FlowSequence flowSequence = child;
                                flowMapping = flowMapping2;
                                boolean bl = false;
                                ((FlowSequence)it).continuation(line);
                                flowMapping2 = flowMapping;
                                child2 = child;
                            } else if (line.match('{')) {
                                it = child = new FlowMapping(false);
                                flowMapping = flowMapping2;
                                boolean bl = false;
                                ((FlowMapping)it).continuation(line);
                                flowMapping2 = flowMapping;
                                child2 = child;
                            } else {
                                child2 = YAMLSimple.processFlowNode$default(INSTANCE, line, null, 1, null);
                            }
                            flowMapping2.child = child2;
                            break;
                        }
                        case 2: {
                            this.child = this.child.continuation(line);
                        }
                    }
                    line.skipSpaces();
                    if (line.atEnd()) {
                        this.state = this.child.getTerminated() ? State.COMMA : State.CONTINUATION;
                        break;
                    }
                }
                if (line.match('}')) {
                    if (this.key == null) {
                        if (this.child.getYAMLNode() != null) {
                            INSTANCE.fatal("Unexpected end of flow mapping", line);
                            throw new KotlinNothingValueException();
                        }
                    } else {
                        ((Map)this.properties).put(String.valueOf(this.key), this.child.getYAMLNode());
                    }
                    this.setTerminated(true);
                    this.state = State.CLOSED;
                    break;
                }
                if (line.matchColon() || this.child instanceof DoubleQuotedScalar && line.match(':')) {
                    this.key = String.valueOf(this.child.getYAMLNode());
                    this.state = State.ITEM;
                    continue;
                }
                if (line.match(',')) {
                    if (this.key == null) {
                        INSTANCE.fatal("Key missing in flow mapping", line);
                        throw new KotlinNothingValueException();
                    }
                    ((Map)this.properties).put(String.valueOf(this.key), this.child.getYAMLNode());
                    this.key = null;
                    this.state = State.ITEM;
                    continue;
                }
                INSTANCE.fatal("Unexpected character in flow mapping", line);
                throw new KotlinNothingValueException();
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/pwall/yaml/YAMLSimple$FlowMapping$State;", "", "(Ljava/lang/String;I)V", "ITEM", "CONTINUATION", "COMMA", "CLOSED", "yaml-simple"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State ITEM = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State COMMA = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.ITEM, State.CONTINUATION, State.COMMA, State.CLOSED};
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.ITEM.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CONTINUATION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lnet/pwall/yaml/YAMLSimple$FlowScalar;", "Lnet/pwall/yaml/YAMLSimple$Child;", "text", "", "terminated", "", "(Ljava/lang/String;Z)V", "getText", "()Ljava/lang/String;", "getYAMLNode", "Lnet/pwall/yaml/YAMLNode;", "yaml-simple"})
    public static abstract class FlowScalar
    extends Child {
        @NotNull
        private final String text;

        public FlowScalar(@NotNull String text, boolean terminated) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(terminated);
            this.text = text;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @Nullable
        public YAMLNode getYAMLNode() {
            return (YAMLNode)new YAMLString(this.getText());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0003H\u0002J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0003H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lnet/pwall/yaml/YAMLSimple$PlainScalar;", "Lnet/pwall/yaml/YAMLSimple$FlowScalar;", "text", "", "(Ljava/lang/String;)V", "complete", "", "getComplete", "()Z", "continuation", "Lnet/pwall/yaml/YAMLSimple$Child;", "line", "Lnet/pwall/yaml/parser/Line;", "getYAMLNode", "Lnet/pwall/yaml/YAMLNode;", "intOrLong", "Lnet/pwall/yaml/YAMLScalar;", "value", "", "matchesDecimal", "matchesInteger", "yaml-simple"})
    public static class PlainScalar
    extends FlowScalar {
        public PlainScalar(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, false);
        }

        @Override
        public boolean getComplete() {
            return true;
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return INSTANCE.processPlainScalar(line, this.getText() + ' ');
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public YAMLNode getYAMLNode() {
            block14: {
                block13: {
                    if (((CharSequence)this.getText()).length() == 0 || Intrinsics.areEqual((Object)this.getText(), (Object)"null") || Intrinsics.areEqual((Object)this.getText(), (Object)"Null") || Intrinsics.areEqual((Object)this.getText(), (Object)"NULL") || Intrinsics.areEqual((Object)this.getText(), (Object)"~")) {
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)this.getText(), (Object)"true") || Intrinsics.areEqual((Object)this.getText(), (Object)"True") || Intrinsics.areEqual((Object)this.getText(), (Object)"TRUE")) {
                        return (YAMLNode)YAMLBoolean.TRUE;
                    }
                    if (Intrinsics.areEqual((Object)this.getText(), (Object)"false") || Intrinsics.areEqual((Object)this.getText(), (Object)"False") || Intrinsics.areEqual((Object)this.getText(), (Object)"FALSE")) {
                        return (YAMLNode)YAMLBoolean.FALSE;
                    }
                    if (StringsKt.startsWith$default((String)this.getText(), (String)"0o", (boolean)false, (int)2, null) && this.getText().length() > 2) {
                        block12: {
                            $this$all$iv = StringsKt.drop((String)this.getText(), (int)2);
                            $i$f$all = false;
                            for (var3_3 = 0; var3_3 < $this$all$iv.length(); ++var3_3) {
                                it = element$iv = $this$all$iv.charAt(var3_3);
                                $i$a$-all-YAMLSimple$PlainScalar$getYAMLNode$1 = false;
                                if ('0' <= it ? it < '8' : false) continue;
                                v0 = false;
                                break block12;
                            }
                            v0 = true;
                        }
                        if (v0) {
                            return (YAMLNode)this.intOrLong(Long.parseLong(StringsKt.drop((String)this.getText(), (int)2), CharsKt.checkRadix((int)8)));
                        }
                    }
                    if (!StringsKt.startsWith$default((String)this.getText(), (String)"0x", (boolean)false, (int)2, null) || this.getText().length() <= 2) break block14;
                    $this$all$iv = StringsKt.drop((String)this.getText(), (int)2);
                    $i$f$all = false;
                    for (var3_3 = 0; var3_3 < $this$all$iv.length(); ++var3_3) {
                        it = element$iv = $this$all$iv.charAt(var3_3);
                        $i$a$-all-YAMLSimple$PlainScalar$getYAMLNode$2 = false;
                        if ('0' <= it ? it < ':' : false) ** GOTO lbl-1000
                        if ('A' <= it ? it < 'G' : false) ** GOTO lbl-1000
                        v1 = 'a' <= it ? it < 'g' : false;
                        if (v1) lbl-1000:
                        // 3 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        if (v2) continue;
                        v3 = false;
                        break block13;
                    }
                    v3 = true;
                }
                if (v3) {
                    return (YAMLNode)this.intOrLong(Long.parseLong(StringsKt.drop((String)this.getText(), (int)2), CharsKt.checkRadix((int)16)));
                }
            }
            if (this.matchesInteger(this.getText())) {
                return (YAMLNode)this.intOrLong(Long.parseLong(this.getText()));
            }
            if (this.matchesDecimal(this.getText())) {
                return (YAMLNode)new YAMLDecimal(this.getText());
            }
            return (YAMLNode)new YAMLString(this.getText());
        }

        private final YAMLScalar intOrLong(long value) {
            return (Integer.MIN_VALUE <= value ? value <= Integer.MAX_VALUE : false) ? (YAMLScalar)new YAMLInt((int)value) : (YAMLScalar)new YAMLLong(value);
        }

        private final boolean matchesInteger(String $this$matchesInteger) {
            ParseText it = new ParseText((CharSequence)$this$matchesInteger);
            boolean bl = false;
            if (!it.match('+')) {
                it.match('-');
            }
            return it.matchDec() && it.isExhausted();
        }

        private final boolean matchesDecimal(String $this$matchesDecimal) {
            ParseText pt = new ParseText((CharSequence)$this$matchesDecimal);
            if (!pt.match('+')) {
                pt.match('-');
            }
            if (pt.match('.')) {
                if (!pt.matchDec()) {
                    return false;
                }
            } else {
                if (!pt.matchDec()) {
                    return false;
                }
                if (pt.match('.')) {
                    pt.matchDec();
                }
            }
            if (pt.match('e') || pt.match('E')) {
                if (!pt.match('+')) {
                    pt.match('-');
                }
                if (!pt.matchDec()) {
                    return false;
                }
            }
            return pt.isExhausted();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lnet/pwall/yaml/YAMLSimple$FlowNode;", "Lnet/pwall/yaml/YAMLSimple$PlainScalar;", "text", "", "(Ljava/lang/String;)V", "continuation", "Lnet/pwall/yaml/YAMLSimple$Child;", "line", "Lnet/pwall/yaml/parser/Line;", "yaml-simple"})
    public static final class FlowNode
    extends PlainScalar {
        public FlowNode(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return INSTANCE.processFlowNode(line, this.getText() + ' ');
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/pwall/yaml/YAMLSimple$DoubleQuotedScalar;", "Lnet/pwall/yaml/YAMLSimple$FlowScalar;", "text", "", "terminated", "", "escapedNewline", "(Ljava/lang/String;ZZ)V", "continuation", "line", "Lnet/pwall/yaml/parser/Line;", "yaml-simple"})
    public static final class DoubleQuotedScalar
    extends FlowScalar {
        private final boolean escapedNewline;

        public DoubleQuotedScalar(@NotNull String text, boolean terminated, boolean escapedNewline) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, terminated);
            this.escapedNewline = escapedNewline;
        }

        public /* synthetic */ DoubleQuotedScalar(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(string, bl, bl2);
        }

        @Override
        @NotNull
        public DoubleQuotedScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            String space = this.escapedNewline || StringsKt.endsWith$default((CharSequence)this.getText(), (char)' ', (boolean)false, (int)2, null) ? "" : " ";
            return INSTANCE.processDoubleQuotedScalar(line, this.getText() + space);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lnet/pwall/yaml/YAMLSimple$SingleQuotedScalar;", "Lnet/pwall/yaml/YAMLSimple$FlowScalar;", "text", "", "terminated", "", "(Ljava/lang/String;Z)V", "continuation", "line", "Lnet/pwall/yaml/parser/Line;", "yaml-simple"})
    public static final class SingleQuotedScalar
    extends FlowScalar {
        public SingleQuotedScalar(@NotNull String text, boolean terminated) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, terminated);
        }

        @Override
        @NotNull
        public SingleQuotedScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            String space = StringsKt.endsWith$default((CharSequence)this.getText(), (char)' ', (boolean)false, (int)2, null) ? "" : " ";
            return INSTANCE.processSingleQuotedScalar(line, this.getText() + space);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u0013*\u00060\u000ej\u0002`\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lnet/pwall/yaml/YAMLSimple$BlockScalar;", "Lnet/pwall/yaml/YAMLSimple$Child;", "indent", "", "chomping", "Lnet/pwall/yaml/YAMLSimple$BlockScalar$Chomping;", "(ILnet/pwall/yaml/YAMLSimple$BlockScalar$Chomping;)V", "complete", "", "getComplete", "()Z", "state", "Lnet/pwall/yaml/YAMLSimple$BlockScalar$State;", "text", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getText", "()Ljava/lang/StringBuilder;", "appendText", "", "string", "", "continuation", "line", "Lnet/pwall/yaml/parser/Line;", "getYAMLNode", "Lnet/pwall/yaml/YAMLString;", "strip", "Chomping", "State", "yaml-simple"})
    public static abstract class BlockScalar
    extends Child {
        private int indent;
        @NotNull
        private final Chomping chomping;
        @NotNull
        private State state;
        @NotNull
        private final StringBuilder text;

        public BlockScalar(int indent, @NotNull Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(false);
            this.indent = indent;
            this.chomping = chomping;
            this.state = State.INITIAL;
            this.text = new StringBuilder();
        }

        @Override
        @NotNull
        public StringBuilder getText() {
            return this.text;
        }

        @Override
        public boolean getComplete() {
            return true;
        }

        public abstract void appendText(@NotNull String var1);

        @Override
        @NotNull
        public BlockScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    if (line.getIndex() > this.indent) {
                        this.indent = line.getIndex();
                    }
                    if (line.isExhausted()) break;
                    this.state = State.CONTINUATION;
                    line.skipToEnd();
                    String string = line.getResultString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.resultString");
                    this.appendText(string);
                    break;
                }
                case 2: {
                    if (line.isExhausted()) {
                        if (line.getIndex() > this.indent) {
                            line.setStart(this.indent);
                            String string = line.getResultString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.resultString");
                            this.appendText(string);
                            break;
                        }
                        this.appendText("");
                        break;
                    }
                    if (line.getIndex() < this.indent) {
                        if (line.matchHash()) break;
                        INSTANCE.fatal("Bad indentation in block scalar", line);
                        throw new KotlinNothingValueException();
                    }
                    if (line.getIndex() > this.indent) {
                        line.setIndex(this.indent);
                    }
                    line.skipToEnd();
                    String string = line.getResultString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.resultString");
                    this.appendText(string);
                }
            }
            return this;
        }

        @NotNull
        public YAMLString getYAMLNode() {
            StringBuilder sb = new StringBuilder(this.getText());
            switch (WhenMappings.$EnumSwitchMapping$1[this.chomping.ordinal()]) {
                case 1: {
                    this.strip(sb);
                    break;
                }
                case 2: {
                    this.strip(sb);
                    sb.append("\n");
                }
            }
            return new YAMLString(sb.toString());
        }

        private final void strip(StringBuilder $this$strip) {
            while (StringsKt.endsWith$default((CharSequence)$this$strip, (char)'\n', (boolean)false, (int)2, null)) {
                $this$strip.setLength($this$strip.length() - 1);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/pwall/yaml/YAMLSimple$BlockScalar$Chomping;", "", "(Ljava/lang/String;I)V", "STRIP", "KEEP", "CLIP", "yaml-simple"})
        public static final class Chomping
        extends Enum<Chomping> {
            public static final /* enum */ Chomping STRIP = new Chomping();
            public static final /* enum */ Chomping KEEP = new Chomping();
            public static final /* enum */ Chomping CLIP = new Chomping();
            private static final /* synthetic */ Chomping[] $VALUES;

            public static Chomping[] values() {
                return (Chomping[])$VALUES.clone();
            }

            public static Chomping valueOf(String value) {
                return Enum.valueOf(Chomping.class, value);
            }

            static {
                $VALUES = chompingArray = new Chomping[]{Chomping.STRIP, Chomping.KEEP, Chomping.CLIP};
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/pwall/yaml/YAMLSimple$BlockScalar$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CONTINUATION", "yaml-simple"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CONTINUATION = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CONTINUATION};
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.INITIAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.CONTINUATION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Chomping.values().length];
                try {
                    nArray[Chomping.STRIP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Chomping.CLIP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Chomping.KEEP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/pwall/yaml/YAMLSimple$LiteralBlockScalar;", "Lnet/pwall/yaml/YAMLSimple$BlockScalar;", "indent", "", "chomping", "Lnet/pwall/yaml/YAMLSimple$BlockScalar$Chomping;", "(ILnet/pwall/yaml/YAMLSimple$BlockScalar$Chomping;)V", "appendText", "", "string", "", "yaml-simple"})
    public static final class LiteralBlockScalar
    extends BlockScalar {
        public LiteralBlockScalar(int indent, @NotNull BlockScalar.Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(indent, chomping);
        }

        @Override
        public void appendText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.getText().append(string);
            this.getText().append('\n');
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/pwall/yaml/YAMLSimple$FoldedBlockScalar;", "Lnet/pwall/yaml/YAMLSimple$BlockScalar;", "indent", "", "chomping", "Lnet/pwall/yaml/YAMLSimple$BlockScalar$Chomping;", "(ILnet/pwall/yaml/YAMLSimple$BlockScalar$Chomping;)V", "appendText", "", "string", "", "yaml-simple"})
    public static final class FoldedBlockScalar
    extends BlockScalar {
        public FoldedBlockScalar(int indent, @NotNull BlockScalar.Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(indent, chomping);
        }

        @Override
        public void appendText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (StringsKt.endsWith$default((CharSequence)this.getText(), (char)'\n', (boolean)false, (int)2, null)) {
                this.getText().setLength(this.getText().length() - 1);
                while (StringsKt.endsWith$default((CharSequence)this.getText(), (char)'\n', (boolean)false, (int)2, null)) {
                    this.getText().setLength(this.getText().length() - 1);
                }
                this.getText().append(' ');
            }
            this.getText().append(string);
            this.getText().append('\n');
        }
    }
}

