/*
 * Decompiled with CFR 0.152.
 */
package net.qiujuer.genius.graphics;

import android.graphics.Bitmap;

public final class Blur {
    private static Bitmap a(Bitmap bitmap, int n) {
        if (n < 0 || n > 256) {
            throw new RuntimeException("Blur bitmap radius must >= 1 and <=256.");
        }
        if (bitmap == null) {
            throw new NullPointerException("Blur bitmap original isn't null.");
        }
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Blur bitmap can't blur a recycled bitmap.");
        }
        Bitmap.Config config = bitmap.getConfig();
        if (config != Bitmap.Config.ARGB_8888 && config != Bitmap.Config.RGB_565) {
            throw new RuntimeException("Blur bitmap only supported Bitmap.Config.ARGB_8888 and Bitmap.Config.RGB_565.");
        }
        return bitmap;
    }

    public static Bitmap onStackBlur(Bitmap bitmap, int n) {
        Bitmap bitmap2 = Blur.a(bitmap, n);
        if (n == 1) {
            return bitmap2;
        }
        Blur.nativeStackBlurBitmap(bitmap2, n);
        return bitmap2;
    }

    public static Bitmap onStackBlurClip(Bitmap bitmap, int n) {
        Bitmap bitmap2 = Blur.a(bitmap, n);
        if (n == 1) {
            return bitmap2;
        }
        int n2 = bitmap2.getHeight();
        int n3 = bitmap2.getWidth();
        int n4 = 262144;
        float f = n2 * n3 / 262144;
        int n5 = n + n + 50;
        if (f >= 2.0f) {
            float f2 = (float)n2 / f;
            f2 = f2 < (float)n5 ? (float)n5 : f2;
            f = (float)n2 / f2;
        }
        if (f < 2.0f) {
            Blur.nativeStackBlurBitmap(bitmap2, n);
        } else {
            if (f > 12.0f) {
                f = 12.0f;
            }
            Blur.onStackBlurClip(bitmap2, n, (int)f);
        }
        return bitmap2;
    }

    public static Bitmap onStackBlurClip(Bitmap bitmap, int n, int n2) {
        Bitmap bitmap2 = Blur.a(bitmap, n);
        if (n2 < 2 || n2 > 12) {
            throw new RuntimeException("Blur bitmap parts must >= 2 and <=12.");
        }
        if (bitmap.getHeight() / n2 < n + n) {
            throw new RuntimeException("Blur bitmap height/partsCount must > radius+radius values.");
        }
        Blur.nativeStackBlurBitmapClip(bitmap2, n, n2);
        return bitmap2;
    }

    public static int[] onStackBlurPixels(int[] nArray, int n, int n2, int n3) {
        if (n3 < 0 || n3 > 256) {
            throw new RuntimeException("Blur bitmap radius must >= 1 and <=256.");
        }
        if (nArray == null) {
            throw new RuntimeException("Blur bitmap pix isn't null.");
        }
        if (nArray.length < n * n2) {
            throw new RuntimeException("Blur bitmap pix length must >= w * h.");
        }
        Blur.nativeStackBlurPixels(nArray, n, n2, n3);
        return nArray;
    }

    public static Bitmap onStackBlurJava(Bitmap bitmap, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        Bitmap bitmap2 = Blur.a(bitmap, n);
        if (n == 1) {
            return bitmap2;
        }
        int n18 = bitmap2.getWidth();
        int n19 = bitmap2.getHeight();
        int[] nArray2 = new int[n18 * n19];
        bitmap2.getPixels(nArray2, 0, n18, 0, 0, n18, n19);
        int n20 = n18 - 1;
        int n21 = n19 - 1;
        int n22 = n18 * n19;
        int n23 = n + n + 1;
        short[] sArray = new short[n22];
        short[] sArray2 = new short[n22];
        short[] sArray3 = new short[n22];
        int[] nArray3 = new int[Math.max(n18, n19)];
        int n24 = n23 + 1 >> 1;
        n24 *= n24;
        short[] sArray4 = new short[256 * n24];
        for (n17 = 0; n17 < 256 * n24; ++n17) {
            sArray4[n17] = (short)(n17 / n24);
        }
        int n25 = 0;
        int n26 = 0;
        int[][] nArray4 = new int[n23][3];
        int n27 = n + 1;
        for (n16 = 0; n16 < n19; ++n16) {
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            for (n17 = -n; n17 <= n; ++n17) {
                n6 = nArray2[n25 + Math.min(n20, Math.max(n17, 0))];
                nArray = nArray4[n17 + n];
                nArray[0] = (n6 & 0xFF0000) >> 16;
                nArray[1] = (n6 & 0xFF00) >> 8;
                nArray[2] = n6 & 0xFF;
                n5 = n27 - Math.abs(n17);
                n13 += nArray[0] * n5;
                n14 += nArray[1] * n5;
                n15 += nArray[2] * n5;
                if (n17 > 0) {
                    n7 += nArray[0];
                    n8 += nArray[1];
                    n9 += nArray[2];
                    continue;
                }
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
            }
            n4 = n;
            for (n3 = 0; n3 < n18; ++n3) {
                sArray[n25] = sArray4[n13];
                sArray2[n25] = sArray4[n14];
                sArray3[n25] = sArray4[n15];
                n13 -= n10;
                n14 -= n11;
                n15 -= n12;
                n2 = n4 - n + n23;
                nArray = nArray4[n2 % n23];
                n10 -= nArray[0];
                n11 -= nArray[1];
                n12 -= nArray[2];
                if (n16 == 0) {
                    nArray3[n3] = Math.min(n3 + n + 1, n20);
                }
                n6 = nArray2[n26 + nArray3[n3]];
                nArray[0] = (n6 & 0xFF0000) >> 16;
                nArray[1] = (n6 & 0xFF00) >> 8;
                nArray[2] = n6 & 0xFF;
                n13 += (n7 += nArray[0]);
                n14 += (n8 += nArray[1]);
                n15 += (n9 += nArray[2]);
                n4 = (n4 + 1) % n23;
                nArray = nArray4[n4 % n23];
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
                n7 -= nArray[0];
                n8 -= nArray[1];
                n9 -= nArray[2];
                ++n25;
            }
            n26 += n18;
        }
        for (n3 = 0; n3 < n18; ++n3) {
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            int n28 = -n * n18;
            for (n17 = -n; n17 <= n; ++n17) {
                n25 = Math.max(0, n28) + n3;
                nArray = nArray4[n17 + n];
                nArray[0] = sArray[n25];
                nArray[1] = sArray2[n25];
                nArray[2] = sArray3[n25];
                n5 = n27 - Math.abs(n17);
                n13 += sArray[n25] * n5;
                n14 += sArray2[n25] * n5;
                n15 += sArray3[n25] * n5;
                if (n17 > 0) {
                    n7 += nArray[0];
                    n8 += nArray[1];
                    n9 += nArray[2];
                } else {
                    n10 += nArray[0];
                    n11 += nArray[1];
                    n12 += nArray[2];
                }
                if (n17 >= n21) continue;
                n28 += n18;
            }
            n25 = n3;
            n4 = n;
            for (n16 = 0; n16 < n19; ++n16) {
                nArray2[n25] = 0xFF000000 & nArray2[n25] | sArray4[n13] << 16 | sArray4[n14] << 8 | sArray4[n15];
                n13 -= n10;
                n14 -= n11;
                n15 -= n12;
                n2 = n4 - n + n23;
                nArray = nArray4[n2 % n23];
                n10 -= nArray[0];
                n11 -= nArray[1];
                n12 -= nArray[2];
                if (n3 == 0) {
                    nArray3[n16] = Math.min(n16 + n27, n21) * n18;
                }
                n6 = n3 + nArray3[n16];
                nArray[0] = sArray[n6];
                nArray[1] = sArray2[n6];
                nArray[2] = sArray3[n6];
                n13 += (n7 += nArray[0]);
                n14 += (n8 += nArray[1]);
                n15 += (n9 += nArray[2]);
                n4 = (n4 + 1) % n23;
                nArray = nArray4[n4];
                n10 += nArray[0];
                n11 += nArray[1];
                n12 += nArray[2];
                n7 -= nArray[0];
                n8 -= nArray[1];
                n9 -= nArray[2];
                n25 += n18;
            }
        }
        bitmap2.setPixels(nArray2, 0, n18, 0, 0, n18, n19);
        return bitmap2;
    }

    private static native void nativeStackBlurPixels(int[] var0, int var1, int var2, int var3);

    private static native void nativeStackBlurBitmap(Bitmap var0, int var1);

    private static native void nativeStackBlurBitmapClip(Bitmap var0, int var1, int var2);

    static {
        System.loadLibrary("genius_graphics");
    }
}

