/*
 * Copyright 2017 Arnaud Fonce <arnaud.fonce@r-w-x.net>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.rwx.padlock;

import jakarta.enterprise.context.RequestScoped;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * Provide a way to bind objects across more than one request.
 * 
 * Object use serialization to be added into session token.
 * 
 * <p>{@link PadlockSession} inherit from {@link HttpSession} to keep same method signatures.</p>
 * 
 * @see HttpSession
 * @author <a href="mailto:arnaud.fonce@r-w-x.net">Arnaud Fonce</a>
 */
@RequestScoped
public class PadlockSession implements HttpSession {

    private final Map<String, Object> attributes = new HashMap<>();
    private boolean authenticated = false;
    private boolean valid = true;
    
    public <T> T getAttribute(String name, Class<T> type) {
        return (T) attributes.get(name);
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public boolean isAuthenticated() {
        return authenticated;
    }
    
    public boolean isEmpty() {
        return attributes.isEmpty();
    }
    
    public boolean isValid() {
        return valid;
    }

    @Override
    public void setAttribute(String name, Object value) {
        attributes.put(name, value);
    }

    @Override
    public long getCreationTime() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public long getLastAccessedTime() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public ServletContext getServletContext() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void setMaxInactiveInterval(int i) {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public int getMaxInactiveInterval() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

//    @Override
//    public HttpSessionContext getSessionContext() {
//        throw new UnsupportedOperationException("Deprecated");
//    }

    @Override
    public Object getAttribute(String name) {
        return attributes.get(name);
    }

//    @Override
//    public Object getValue(String name) {
//        return getAttribute(name);
//    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(attributes.keySet());
    }

//    @Override
//    public String[] getValueNames() {
//        return attributes.keySet().toArray(new String[attributes.keySet().size()]);
//    }

//    @Override
//    public void putValue(String name, Object value) {
//        setAttribute(name, value);
//    }

    @Override
    public void removeAttribute(String name) {
        attributes.remove(name);
    }

//    @Override
//    public void removeValue(String name) {
//        removeAttribute(name);
//    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isNew() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
}
