/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.padlock;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;
import de.mkammerer.argon2.Argon2Helper;
import jakarta.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class PasswordService {
    private static final Argon2 ARGON2 = Argon2Factory.create();
    private static final int NB_ITERATIONS = Argon2Helper.findIterations((Argon2)ARGON2, (long)1000L, (int)65536, (int)1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hash(char[] password, boolean wipePassword) {
        try {
            String string = ARGON2.hash(NB_ITERATIONS, 65536, 1, password);
            return string;
        }
        finally {
            if (wipePassword) {
                ARGON2.wipeArray(password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(char[] password, String hash, boolean wipePassword) {
        try {
            boolean bl = ARGON2.verify(hash, password);
            return bl;
        }
        finally {
            if (wipePassword) {
                ARGON2.wipeArray(password);
            }
        }
    }
}

