/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.padlock.internal;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.rwx.padlock.annotations.Authorization;
import net.rwx.padlock.annotations.AuthorizationParameters;
import net.rwx.padlock.internal.AuthorizationParameter;
import net.rwx.padlock.internal.ParamConverters;
import net.rwx.padlock.internal.UnauthorizedException;

class AuthorizationChecker {
    private final Object checker;
    private final Collection<AuthorizationParameter> parameters;
    private final ParamConverters paramConverters;

    public void check() throws UnauthorizedException {
        try {
            this.tryToCheck();
        }
        catch (UnauthorizedException ue) {
            throw ue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void tryToCheck() throws Exception {
        for (AuthorizationParameter parameter : this.parameters) {
            this.setValueToChecker(parameter);
        }
        this.invokeChecker();
    }

    private void setValueToChecker(AuthorizationParameter parameter) throws Exception {
        for (PropertyDescriptor descriptor : Introspector.getBeanInfo(this.checker.getClass()).getPropertyDescriptors()) {
            if (!descriptor.getName().equals(parameter.getName())) continue;
            Method writeMethod = descriptor.getWriteMethod();
            Object paramValue = this.convertValue(parameter);
            writeMethod.invoke(this.checker, paramValue);
        }
    }

    private Object convertValue(AuthorizationParameter parameter) {
        return this.paramConverters.convertValueToType(parameter.getValue(), parameter.getType(), new ArrayList());
    }

    private void invokeChecker() throws Exception {
        Method checkerMethod = this.checker.getClass().getMethod("authorized", new Class[0]);
        if (checkerMethod != null) {
            if (!((Boolean)checkerMethod.invoke(this.checker, new Object[0])).booleanValue()) {
                throw new UnauthorizedException();
            }
        } else {
            throw new RuntimeException("No authorized method in authorization checker " + this.checker.getClass());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private AuthorizationChecker(Object authorizationChecker, Collection<AuthorizationParameter> parameters, ParamConverters paramConverters) {
        this.parameters = parameters;
        this.paramConverters = paramConverters;
        this.checker = authorizationChecker == null ? this : authorizationChecker;
    }

    public boolean authorized() {
        return true;
    }

    public static class Builder {
        private Method authorizedMethod;
        private BeanManager beanManager;
        private ContainerRequestContext requestContext;

        private Builder() {
        }

        public Builder fromAuthorizedMethod(Method value) {
            this.authorizedMethod = value;
            return this;
        }

        public Builder withBeanManager(BeanManager value) {
            this.beanManager = value;
            return this;
        }

        public Builder valueFrom(ContainerRequestContext value) {
            this.requestContext = value;
            return this;
        }

        public AuthorizationChecker build() {
            Authorization authorization = this.authorizedMethod.getAnnotation(Authorization.class);
            Object authorizationChecker = this.getReferenceToChecker(authorization);
            Collection<AuthorizationParameter> authParameters = this.buildAuthorizationParameters();
            ParamConverters converters = this.getReferenceToBean(ParamConverters.class);
            return new AuthorizationChecker(authorizationChecker, authParameters, converters);
        }

        private Object getReferenceToChecker(Authorization authorization) {
            if (authorization == null) {
                return null;
            }
            return this.getReferenceToBean(authorization.value());
        }

        private <T> T getReferenceToBean(Class<T> type) {
            Bean bean = this.beanManager.resolve(this.beanManager.getBeans(type, new Annotation[0]));
            return (T)this.beanManager.getReference(bean, type, this.beanManager.createCreationalContext((Contextual)bean));
        }

        private Collection<AuthorizationParameter> buildAuthorizationParameters() {
            ArrayList<AuthorizationParameter> authParameters = new ArrayList<AuthorizationParameter>();
            for (net.rwx.padlock.annotations.AuthorizationParameter paramAnnotation : this.getParameterAnnotations()) {
                authParameters.add(AuthorizationParameter.builder().name(paramAnnotation.value()).describeByMethod(this.authorizedMethod).valueFrom(this.requestContext).build());
            }
            return authParameters;
        }

        private net.rwx.padlock.annotations.AuthorizationParameter[] getParameterAnnotations() {
            AuthorizationParameters params = this.authorizedMethod.getAnnotation(AuthorizationParameters.class);
            net.rwx.padlock.annotations.AuthorizationParameter param = this.authorizedMethod.getAnnotation(net.rwx.padlock.annotations.AuthorizationParameter.class);
            if (params != null) {
                return params.value();
            }
            if (param != null) {
                net.rwx.padlock.annotations.AuthorizationParameter[] paramsArray = new net.rwx.padlock.annotations.AuthorizationParameter[]{param};
                return paramsArray;
            }
            return new net.rwx.padlock.annotations.AuthorizationParameter[0];
        }
    }
}

