/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.padlock.internal;

import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

class AuthorizationParameter {
    private final String name;
    private final Class<?> type;
    private final String value;

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    private AuthorizationParameter(String name, Class<?> type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public static class Builder {
        private String name;
        private Method resourceMethod;
        private String value;
        private Class<?> valueType;
        private ContainerRequestContext requestContext;

        private Builder() {
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder describeByMethod(Method value) {
            this.resourceMethod = value;
            return this;
        }

        public Builder valueFrom(ContainerRequestContext value) {
            this.requestContext = value;
            return this;
        }

        public AuthorizationParameter build() {
            this.extractValueAndTypeFromMethodAndRequest();
            return new AuthorizationParameter(this.name, this.valueType, this.value);
        }

        private void extractValueAndTypeFromMethodAndRequest() {
            Annotation[][] annotations = this.resourceMethod.getParameterAnnotations();
            for (int iMethodParameter = 0; iMethodParameter < annotations.length; ++iMethodParameter) {
                for (Annotation annotation : annotations[iMethodParameter]) {
                    this.extractPathParam(annotation, iMethodParameter);
                    this.extractQueryParam(annotation, iMethodParameter);
                }
            }
            this.checkIfValueHasBeenFound();
        }

        private void checkIfValueHasBeenFound() {
            if (this.value == null || this.valueType == null) {
                throw new RuntimeException("No parameter " + this.name + " on resource " + this.resourceMethod.getName());
            }
        }

        private void extractPathParam(Annotation annotation, int iMethodParameter) {
            if (annotation instanceof PathParam && ((PathParam)annotation).value().equals(this.name)) {
                this.value = (String)this.requestContext.getUriInfo().getPathParameters().getFirst((Object)this.name);
                this.valueType = this.resourceMethod.getParameterTypes()[iMethodParameter];
            }
        }

        private void extractQueryParam(Annotation annotation, int iMethodParameter) {
            if (annotation instanceof QueryParam && ((QueryParam)annotation).value().equals(this.name)) {
                this.value = (String)this.requestContext.getUriInfo().getQueryParameters().getFirst((Object)this.name);
                this.valueType = this.resourceMethod.getParameterTypes()[iMethodParameter];
            }
        }
    }
}

