/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.padlock.internal;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import net.rwx.padlock.PadlockSession;
import net.rwx.padlock.annotations.WithoutAuthentication;
import net.rwx.padlock.internal.AuthorizationChecker;
import net.rwx.padlock.internal.BadTokenException;
import net.rwx.padlock.internal.TokenHelper;
import net.rwx.padlock.internal.UnauthorizedException;

@Provider
class PadlockFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String JWT_COOKIE_NAME = "JTOKEN";
    private static final ConcurrentHashMap<ContainerRequestContext, PadlockSession> sessionsMap = new ConcurrentHashMap();
    @Inject
    private PadlockSession session;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private BeanManager beanManager;
    @Inject
    private TokenHelper tokenHelper;

    PadlockFilter() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filter(ContainerRequestContext requestContext) {
        try {
            this.readTokenCookie(requestContext);
            if (this.needAuthentication()) {
                if (!this.session.isAuthenticated()) throw new UnauthorizedException();
                this.checkAuthorization(requestContext);
                sessionsMap.put(requestContext, this.getBeanInstanceFromContext());
                return;
            } else {
                sessionsMap.put(requestContext, this.getBeanInstanceFromContext());
            }
            return;
        }
        catch (UnauthorizedException ue) {
            this.unauthorized(requestContext);
            return;
        }
        catch (BadTokenException bte) {
            this.unauthorizedWithCookieRemove(requestContext);
        }
    }

    private boolean needAuthentication() {
        return !this.resourceInfo.getResourceMethod().isAnnotationPresent(WithoutAuthentication.class);
    }

    private void readTokenCookie(ContainerRequestContext requestContext) throws BadTokenException {
        Cookie tokenCookie = (Cookie)requestContext.getCookies().get(JWT_COOKIE_NAME);
        if (tokenCookie != null) {
            this.tokenHelper.parseTokenAndExtractBean(this.session, tokenCookie.getValue());
        }
    }

    private void checkAuthorization(ContainerRequestContext requestContext) throws UnauthorizedException {
        AuthorizationChecker authChecker = AuthorizationChecker.builder().fromAuthorizedMethod(this.resourceInfo.getResourceMethod()).valueFrom(requestContext).withBeanManager(this.beanManager).build();
        authChecker.check();
    }

    private void unauthorized(ContainerRequestContext requestContext) {
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    private void unauthorizedWithCookieRemove(ContainerRequestContext requestContext) {
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("Set-Cookie", (Object)this.buildCookieHeaderToRemoveToken()).build());
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        PadlockSession sessionFromMap = sessionsMap.remove(requestContext);
        if (sessionFromMap != null && !sessionFromMap.isValid()) {
            responseContext.getHeaders().add((Object)"Set-Cookie", (Object)this.buildCookieHeaderToRemoveToken());
        } else if (sessionFromMap != null && !sessionFromMap.isEmpty()) {
            String token = this.tokenHelper.serializeBeanAndCreateToken(sessionFromMap);
            NewCookie cookie = (NewCookie)RuntimeDelegate.getInstance().createHeaderDelegate(NewCookie.class).fromString("JTOKEN=" + token + ";Secure;HttpOnly;Path=/");
            responseContext.getHeaders().add((Object)"Set-Cookie", (Object)cookie);
        }
    }

    private NewCookie buildCookieHeaderToRemoveToken() {
        return (NewCookie)RuntimeDelegate.getInstance().createHeaderDelegate(NewCookie.class).fromString("JTOKEN=deleted;Secure;HttpOnly;Path=/;expires=Thu, 01 Jan 1970 00:00:00 GMT");
    }

    private PadlockSession getBeanInstanceFromContext() {
        Bean bean = this.beanManager.resolve(this.beanManager.getBeans(PadlockSession.class, new Annotation[0]));
        return (PadlockSession)this.beanManager.getContext(bean.getScope()).get((Contextual)bean, this.beanManager.createCreationalContext((Contextual)bean));
    }
}

