/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.padlock.internal;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.ext.ParamConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@ApplicationScoped
class ParamConverters {
    private Map<String, ParamConverter> converters = new HashMap<String, ParamConverter>();

    public ParamConverters() {
        this.converters.put(Integer.TYPE.getName(), new IntegerConverter());
        this.converters.put(Long.TYPE.getName(), new LongConverter());
        this.converters.put(Boolean.TYPE.getName(), new BooleanConverter());
        this.converters.put(Integer.class.getName(), new IntegerConverter());
        this.converters.put(Long.class.getName(), new LongConverter());
        this.converters.put(Boolean.class.getName(), new BooleanConverter());
        this.converters.put(String.class.getName(), new StringConverter());
    }

    public <T> T convertValueToType(String value, Class<T> type, Collection<Class<?>> customConverters) {
        ParamConverter<T> converter = this.findParamConverter(type);
        return (T)converter.fromString(value);
    }

    private <T> ParamConverter<T> findParamConverter(Class<T> type) {
        return this.converters.get(type.getName());
    }

    private class BooleanConverter
    extends FromStringConverter<Boolean> {
        private BooleanConverter() {
        }

        public Boolean fromString(String value) {
            return Boolean.parseBoolean(value);
        }
    }

    private class StringConverter
    extends FromStringConverter<String> {
        private StringConverter() {
        }

        public String fromString(String value) {
            return value;
        }
    }

    private class LongConverter
    extends FromStringConverter<Long> {
        private LongConverter() {
        }

        public Long fromString(String value) {
            return Long.parseLong(value);
        }
    }

    private class IntegerConverter
    extends FromStringConverter<Integer> {
        private IntegerConverter() {
        }

        public Integer fromString(String value) {
            return Integer.parseInt(value);
        }
    }

    private abstract class FromStringConverter<T>
    implements ParamConverter<T> {
        private FromStringConverter() {
        }

        public String toString(T value) {
            throw new UnsupportedOperationException("Should convert to string with this converter");
        }
    }
}

