/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.padlock.internal;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.Key;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.rwx.padlock.KeyProvider;
import net.rwx.padlock.PadlockSession;
import net.rwx.padlock.internal.BadTokenException;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.JoseException;

@ApplicationScoped
class TokenHelper {
    private static final String CLAIM_AUTHENTICATED = "net.rwx.padlock.authenticated";
    private static final String CLAIM_ATTRIBUTE_PREFIX = "net.rwx.padlock.attribute.";
    private static final Logger logger = Logger.getLogger(TokenHelper.class.getName());
    @Context
    private Application application;
    @Inject
    private BeanManager beanManager;

    TokenHelper() {
    }

    void parseTokenAndExtractBean(PadlockSession session, String token) throws BadTokenException {
        try {
            JwtConsumer jwtConsumer = this.buildTokenConsumer();
            JwtClaims claims = jwtConsumer.processToClaims(token);
            for (String name : claims.getClaimNames()) {
                if (name.startsWith(CLAIM_ATTRIBUTE_PREFIX)) {
                    String attributeName = name.substring(CLAIM_ATTRIBUTE_PREFIX.length());
                    Object bean = this.deserializeBean((String)claims.getClaimValue(name, String.class));
                    session.setAttribute(attributeName, bean);
                    continue;
                }
                if (!name.equals(CLAIM_AUTHENTICATED)) continue;
                session.setAuthenticated((Boolean)claims.getClaimValue(name, Boolean.class));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while parsing JWT token", e);
            throw new BadTokenException();
        }
    }

    String serializeBeanAndCreateToken(PadlockSession bean) {
        try {
            JwtClaims claims = new JwtClaims();
            Enumeration<String> names = bean.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                String claim = this.serializeBean(bean.getAttribute(name));
                claims.setClaim(CLAIM_ATTRIBUTE_PREFIX + name, (Object)claim);
            }
            claims.setClaim(CLAIM_AUTHENTICATED, (Object)bean.isAuthenticated());
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)new HmacKey(this.retreiveProvidedKey()));
            jws.setAlgorithmHeaderValue("HS256");
            return jws.getCompactSerialization();
        }
        catch (IOException | JoseException e) {
            logger.log(Level.WARNING, "Error while creating JWT token", e);
            throw new RuntimeException(e);
        }
    }

    private JwtConsumer buildTokenConsumer() {
        return new JwtConsumerBuilder().setVerificationKey((Key)new HmacKey(this.retreiveProvidedKey())).build();
    }

    private byte[] retreiveProvidedKey() {
        Optional<Class> keyProviderType = this.application.getClasses().stream().filter(cls -> KeyProvider.class.isAssignableFrom((Class<?>)cls)).findFirst();
        if (keyProviderType.isPresent()) {
            Bean bean = this.beanManager.resolve(this.beanManager.getBeans((Type)keyProviderType.get(), new Annotation[0]));
            KeyProvider keyProvider = (KeyProvider)this.beanManager.getReference(bean, (Type)keyProviderType.get(), this.beanManager.createCreationalContext((Contextual)bean));
            return keyProvider.getKey();
        }
        throw new RuntimeException("No key provided");
    }

    private Object deserializeBean(String serializedBean) throws Exception {
        try (ObjectInputStream ois = TokenHelper.buildObjectInputStream(serializedBean);){
            Object object = ois.readObject();
            return object;
        }
    }

    private String serializeBean(Object bean) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(bean);
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    private static ObjectInputStream buildObjectInputStream(String serializedBean) throws IOException {
        return new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(serializedBean)));
    }
}

