/*
 * Decompiled with CFR 0.152.
 */
package net.radai;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileReader;
import net.radai.Grep;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="grep", threadSafe=true)
public class GrepMojo
extends AbstractMojo {
    @Parameter(required=true)
    private List<Grep> greps;
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter(required=false)
    private String outputPattern;
    private Log log = this.getLog();

    public List<Grep> getGreps() {
        return this.greps;
    }

    public void setGreps(List<Grep> greps) {
        this.greps = greps;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            for (Grep grep : this.greps) {
                Pattern lookingFor = Pattern.compile(grep.getGrepPattern());
                if (grep.getFile() != null) {
                    TFile theFile = new TFile(this.basedir, grep.getFile());
                    this.grepInFile(theFile, lookingFor, grep);
                    continue;
                }
                if (grep.getFilePattern() == null) continue;
                this.log.error((CharSequence)"file patterns not implemented yet");
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoFailureException("error grepping", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grepInFile(TFile theFile, Pattern lookingFor, Grep grep) throws Exception {
        if (!theFile.exists()) {
            this.log.warn((CharSequence)("specified file does not exist: " + theFile.getCanonicalPath()));
            return;
        }
        if (!theFile.canRead()) {
            this.log.warn((CharSequence)("cannot read from file " + theFile.getCanonicalPath()));
            return;
        }
        this.log.info((CharSequence)("grepping for " + lookingFor + " in " + theFile.getCanonicalPath()));
        try (TFileReader reader = null;){
            String line;
            reader = new TFileReader((File)theFile);
            BufferedReader bufferedReader = new BufferedReader((Reader)reader);
            int lineNumber = 0;
            boolean found = false;
            while ((line = bufferedReader.readLine()) != null) {
                ++lineNumber;
                Matcher m = lookingFor.matcher(line);
                if (!m.find()) continue;
                this.processMatchingLine(theFile, line, grep, lineNumber);
                found = true;
            }
            if (!found) {
                this.failIfNotFound(theFile, grep);
            }
        }
    }

    private void processMatchingLine(TFile theFile, String theLine, Grep grep, int lineNumber) throws Exception {
        this.printMatch(theFile, theLine, grep, lineNumber);
        this.failIfFound(theFile, theLine, grep, lineNumber);
    }

    private void printMatch(TFile theFile, String theLine, Grep grep, int lineNumber) throws IOException, TemplateException {
        String templateToUse = grep.getOutputPattern();
        if (templateToUse == null) {
            templateToUse = this.outputPattern;
        }
        if (templateToUse == null) {
            this.log.info((CharSequence)theLine);
        } else {
            Template template = new Template("templateName", (Reader)new StringReader(templateToUse), new Configuration());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("line", theLine);
            parameters.put("fileName", theFile.getName());
            parameters.put("lineNumber", lineNumber + "");
            StringWriter output = new StringWriter();
            template.process(parameters, (Writer)output);
            this.log.info((CharSequence)output.toString());
        }
    }

    private void failIfFound(TFile theFile, String theLine, Grep grep, int lineNumber) throws IOException, MojoFailureException {
        if (grep.isFailIfFound()) {
            String msg = grep.getGrepPattern() + " found in  " + theFile.getCanonicalPath() + ":" + lineNumber + " (" + theLine + ")";
            this.log.error((CharSequence)msg);
            throw new MojoFailureException(msg);
        }
    }

    private void failIfNotFound(TFile theFile, Grep grep) throws IOException, MojoFailureException {
        if (grep.isFailIfNotFound()) {
            String msg = grep.getGrepPattern() + " not found in  " + theFile.getCanonicalPath();
            this.log.error((CharSequence)msg);
            throw new MojoFailureException(msg);
        }
    }
}

