/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import java.beans.ConstructorProperties;
import javax.servlet.Filter;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessSecurityAttributesSaveFilter;
import net.rakugakibox.spring.boot.logback.access.jetty.JettyLogbackAccessInstaller;
import net.rakugakibox.spring.boot.logback.access.tomcat.TomcatLogbackAccessInstaller;
import net.rakugakibox.spring.boot.logback.access.undertow.UndertowLogbackAccessInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.web.context.AbstractSecurityWebApplicationInitializer;

@ConditionalOnProperty(name={"logback.access.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={LogbackAccessProperties.class})
@Configuration
public class LogbackAccessAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LogbackAccessAutoConfiguration.class);

    @ConditionalOnClass(value={AbstractSecurityWebApplicationInitializer.class})
    @Configuration
    public static class ForSpringSecurity {
        @ConditionalOnMissingBean(name={"logbackAccessSecurityAttributesSaveFilter"})
        @Bean(value={"logbackAccessSecurityAttributesSaveFilter"})
        public FilterRegistrationBean logbackAccessSecurityAttributesSaveFilter() {
            LogbackAccessSecurityAttributesSaveFilter filter = new LogbackAccessSecurityAttributesSaveFilter();
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
            log.debug("Created a LogbackAccessSecurityAttributesSaveFilter: [{}]", (Object)filter);
            return filterRegistrationBean;
        }
    }

    @ConditionalOnBean(value={UndertowEmbeddedServletContainerFactory.class})
    @Configuration
    public static class ForUndertow {
        private final LogbackAccessProperties logbackAccessProperties;
        private final Environment environment;
        private final ApplicationEventPublisher applicationEventPublisher;

        @ConditionalOnMissingBean
        @Bean
        public UndertowLogbackAccessInstaller undertowLogbackAccessInstaller() {
            UndertowLogbackAccessInstaller installer = new UndertowLogbackAccessInstaller(this.logbackAccessProperties, this.environment, this.applicationEventPublisher);
            log.debug("Created a UndertowLogbackAccessInstaller: [{}]", (Object)installer);
            return installer;
        }

        @ConstructorProperties(value={"logbackAccessProperties", "environment", "applicationEventPublisher"})
        public ForUndertow(LogbackAccessProperties logbackAccessProperties, Environment environment, ApplicationEventPublisher applicationEventPublisher) {
            this.logbackAccessProperties = logbackAccessProperties;
            this.environment = environment;
            this.applicationEventPublisher = applicationEventPublisher;
        }
    }

    @ConditionalOnBean(value={JettyEmbeddedServletContainerFactory.class})
    @Configuration
    public static class ForJetty {
        private final LogbackAccessProperties logbackAccessProperties;
        private final Environment environment;
        private final ApplicationEventPublisher applicationEventPublisher;

        @ConditionalOnMissingBean
        @Bean
        public JettyLogbackAccessInstaller jettyLogbackAccessInstaller() {
            JettyLogbackAccessInstaller installer = new JettyLogbackAccessInstaller(this.logbackAccessProperties, this.environment, this.applicationEventPublisher);
            log.debug("Created a JettyLogbackAccessInstaller: [{}]", (Object)installer);
            return installer;
        }

        @ConstructorProperties(value={"logbackAccessProperties", "environment", "applicationEventPublisher"})
        public ForJetty(LogbackAccessProperties logbackAccessProperties, Environment environment, ApplicationEventPublisher applicationEventPublisher) {
            this.logbackAccessProperties = logbackAccessProperties;
            this.environment = environment;
            this.applicationEventPublisher = applicationEventPublisher;
        }
    }

    @ConditionalOnBean(value={TomcatEmbeddedServletContainerFactory.class})
    @Configuration
    public static class ForTomcat {
        private final LogbackAccessProperties logbackAccessProperties;
        private final Environment environment;
        private final ApplicationEventPublisher applicationEventPublisher;

        @ConditionalOnMissingBean
        @Bean
        public TomcatLogbackAccessInstaller tomcatLogbackAccessInstaller() {
            TomcatLogbackAccessInstaller installer = new TomcatLogbackAccessInstaller(this.logbackAccessProperties, this.environment, this.applicationEventPublisher);
            log.debug("Created a TomcatLogbackAccessInstaller: [{}]", (Object)installer);
            return installer;
        }

        @ConstructorProperties(value={"logbackAccessProperties", "environment", "applicationEventPublisher"})
        public ForTomcat(LogbackAccessProperties logbackAccessProperties, Environment environment, ApplicationEventPublisher applicationEventPublisher) {
            this.logbackAccessProperties = logbackAccessProperties;
            this.environment = environment;
            this.applicationEventPublisher = applicationEventPublisher;
        }
    }
}

