/*
 * Decompiled with CFR 0.152.
 */
package rapture.blob.cassandra;

import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.exceptions.BadRequestException;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.storage.CassandraChunkedStorageProvider;
import com.netflix.astyanax.recipes.storage.ChunkedStorage;
import com.netflix.astyanax.recipes.storage.ChunkedStorageProvider;
import com.netflix.astyanax.recipes.storage.ObjectMetadata;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import rapture.blob.BaseBlobStore;
import rapture.common.CallingContext;
import rapture.common.RaptureURI;
import rapture.config.MultiValueConfigLoader;

public class CassandraBlobStore
extends BaseBlobStore {
    private Map<String, String> config = new HashMap<String, String>();
    private Keyspace keyspace;
    private String blobCFName = "blobCF";
    private String blobKSName = "blobKS";
    private ColumnFamily<String, String> blobCF = ColumnFamily.newColumnFamily((String)this.blobCFName, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
    private CassandraChunkedStorageProvider chunkedProvider;

    public CassandraBlobStore() throws ConnectionException {
        this.reconfigure();
    }

    private void createSchema() throws ConnectionException {
        boolean keyspaceExists = false;
        try {
            if (this.keyspace.describeKeyspace() != null) {
                keyspaceExists = true;
            }
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        if (!keyspaceExists) {
            this.keyspace.createKeyspace((Map)ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)"1").build()).put((Object)"strategy_class", (Object)"SimpleStrategy").build());
        }
        if (this.keyspace.describeKeyspace().getColumnFamily(this.blobCFName) == null) {
            this.keyspace.createColumnFamily(this.blobCF, (Map)ImmutableMap.builder().put((Object)"key_validation_class", (Object)"UTF8Type").put((Object)"comparator_type", (Object)"UTF8Type").build());
        }
    }

    public Boolean storeBlob(CallingContext context, RaptureURI blobUri, Boolean append, InputStream content) {
        if (append.booleanValue()) {
            throw new UnsupportedOperationException("Append is not currently supported for the Cassandra blob store");
        }
        try {
            ChunkedStorage.newWriter((ChunkedStorageProvider)this.chunkedProvider, (String)blobUri.getDocPath(), (InputStream)content).withChunkSize(4096).withConcurrencyLevel(8).call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return true;
    }

    public Long getBlobSize(CallingContext context, RaptureURI blobUri) {
        try {
            ObjectMetadata meta = ChunkedStorage.newInfoReader((ChunkedStorageProvider)this.chunkedProvider, (String)blobUri.getDocPath()).call();
            return meta.getObjectSize();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Boolean deleteBlob(CallingContext context, RaptureURI blobUri) {
        try {
            ChunkedStorage.newDeleter((ChunkedStorageProvider)this.chunkedProvider, (String)blobUri.getDocPath()).call();
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Boolean deleteFolder(CallingContext context, RaptureURI blobUri) {
        return false;
    }

    public InputStream getBlob(CallingContext context, RaptureURI blobUri) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ChunkedStorage.newReader((ChunkedStorageProvider)this.chunkedProvider, (String)blobUri.getDocPath(), (OutputStream)baos).call();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
        try {
            this.reconfigure();
        }
        catch (ConnectionException e) {
            new IllegalStateException(e);
        }
    }

    private void reconfigure() throws ConnectionException {
        String seeds = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + this.getInstanceName() + ".seeds"), (String)"localhost");
        String clusterName = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + this.getInstanceName() + ".clusterName"), (String)"Test Cluster");
        ConsistencyLevel readCL = ConsistencyLevel.CL_ONE;
        ConsistencyLevel writeCL = ConsistencyLevel.CL_ONE;
        if (this.config.containsKey("readConsistency")) {
            readCL = ConsistencyLevel.valueOf((String)this.config.get("readConsistency"));
        }
        if (this.config.containsKey("writeConsistency")) {
            writeCL = ConsistencyLevel.valueOf((String)this.config.get("writeConsistency"));
        }
        AstyanaxContext context = new AstyanaxContext.Builder().forCluster(clusterName).forKeyspace(this.blobKSName).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE).setDefaultReadConsistencyLevel(readCL).setDefaultWriteConsistencyLevel(writeCL)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl("astyanaxConnectionPool").setPort(9160).setMaxConnsPerHost(1).setSeeds(seeds)).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        context.start();
        this.keyspace = (Keyspace)context.getClient();
        this.createSchema();
        this.chunkedProvider = new CassandraChunkedStorageProvider(this.keyspace, this.blobCF);
    }

    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public void init() {
    }

    public Boolean deleteRepo() {
        return true;
    }
}

