/*
 * Decompiled with CFR 0.152.
 */
package rapture.cassandra;

import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.exceptions.BadRequestException;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.ExponentialBackoff;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import java.util.Map;
import org.apache.log4j.Logger;
import rapture.cassandra.CassandraConstants;
import rapture.common.Formattable;
import rapture.common.Messages;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.config.MultiValueConfigLoader;

public class AstyanaxCassandraBase {
    public static final String ALPHA_NUM_UNDERSCRORE = "^[A-Za-z]([A-Za-z]|_|[0-9]){0,31}$";
    private static final int MAX_SCHEMA_CREATE_RETRIES = 1;
    private static Logger log = Logger.getLogger(AstyanaxCassandraBase.class);
    private String keyspaceName;
    private String columnFamilyName;
    protected Keyspace keyspace;
    protected ColumnFamily<String, String> columnFamily;
    private ConsistencyLevel readCL = ConsistencyLevel.CL_ONE;
    private ConsistencyLevel writeCL = ConsistencyLevel.CL_ONE;
    private String replicationFactor;
    private String strategyClass;
    private String keyValidationClass;
    private String comparitorType;
    private int retryDelay;
    private int numberOfRetries;
    private int connectionPoolSize;
    public Messages messageCatalog = new Messages("Cassandra");

    public AstyanaxCassandraBase(String instance, Map<String, String> config) {
        String seeds = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".seeds"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.seeds", (String)"localhost"));
        String clusterName = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".clusterName"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.clusterName", (String)"Test Cluster"));
        this.setupStorageDetails(config);
        this.replicationFactor = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".replicationFactor"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.replicationFactor", (String)"1"));
        this.strategyClass = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".strategyClass"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.strategyClass", (String)"SimpleStrategy"));
        this.keyValidationClass = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".keyValidationClass"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.keyValidationClass", (String)"UTF8Type"));
        this.comparitorType = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".comparitorType"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.comparitorType", (String)"UTF8Type"));
        this.retryDelay = Integer.parseInt(MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".retryDelay"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.retryDelay", (String)"1000")));
        this.numberOfRetries = Integer.parseInt(MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".numberOfRetries"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.numberOfRetries", (String)"3")));
        this.connectionPoolSize = Integer.parseInt(MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".connectionPoolSize"), (String)MultiValueConfigLoader.getConfig((String)"CASSANDRA-default.connectionPoolSize", (String)"8")));
        this.columnFamily = ColumnFamily.newColumnFamily((String)this.columnFamilyName, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        log.info((Object)("Cassandra keyspace: " + this.keyspaceName));
        log.info((Object)("Cassandra columnFamily: " + this.columnFamilyName));
        if (config.containsKey("readConsistency")) {
            this.readCL = ConsistencyLevel.valueOf((String)config.get("readConsistency"));
        }
        if (config.containsKey("writeConsistency")) {
            this.writeCL = ConsistencyLevel.valueOf((String)config.get("writeConsistency"));
        }
        try {
            this.initConnection(clusterName, seeds);
            this.createSchema();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
    }

    protected void setupStorageDetails(Map<String, String> config) {
        String keyspace = config.get(CassandraConstants.KEYSPACECFG);
        this.setKeyspaceName(keyspace);
        String cfName = config.get(CassandraConstants.CFCFG);
        this.setColumnFamilyName(cfName);
    }

    protected void setColumnFamilyName(String cfName) {
        this.columnFamilyName = cfName;
        if (!this.columnFamilyName.matches(ALPHA_NUM_UNDERSCRORE) || !this.keyspaceName.matches(ALPHA_NUM_UNDERSCRORE)) {
            throw RaptureExceptionFactory.create((Integer)400, (String)("Error keyspace or CF not alphanumeric + underscores and must be less than 32 chars: " + this.keyspaceName + " " + this.columnFamilyName));
        }
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    protected void setKeyspaceName(String keyspace) {
        this.keyspaceName = keyspace;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    private void createSchema(int numRetries) throws ConnectionException {
        KeyspaceDefinition keyspaceDef = null;
        try {
            keyspaceDef = this.keyspace.describeKeyspace();
        }
        catch (Exception e) {
            log.info((Object)String.format("Got exception [%s] during keyspace description, assuming it does not exist", e.getMessage()));
        }
        try {
            if (keyspaceDef == null) {
                this.keyspace.createKeyspace((Map)ImmutableMap.builder().put((Object)"strategy_options", (Object)ImmutableMap.builder().put((Object)"replication_factor", (Object)this.replicationFactor).build()).put((Object)"strategy_class", (Object)this.strategyClass).build());
            }
            if (this.keyspace.describeKeyspace().getColumnFamily(this.columnFamilyName) == null) {
                this.keyspace.createColumnFamily(this.columnFamily, (Map)ImmutableMap.builder().put((Object)"key_validation_class", (Object)this.keyValidationClass).put((Object)"comparator_type", (Object)this.comparitorType).build());
            }
        }
        catch (BadRequestException e) {
            if (numRetries > 1) {
                throw e;
            }
            this.createSchema(++numRetries);
        }
    }

    private void createSchema() throws ConnectionException {
        this.createSchema(1);
    }

    private void initConnection(String clusterName, String seeds) {
        log.info((Object)String.format("Connecting to Cassandra at %s:%s", clusterName, seeds));
        AstyanaxContext context = new AstyanaxContext.Builder().forCluster(clusterName).forKeyspace(this.keyspaceName).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setRetryPolicy((RetryPolicy)new ExponentialBackoff(this.retryDelay, this.numberOfRetries)).setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE).setDefaultReadConsistencyLevel(this.readCL).setDefaultWriteConsistencyLevel(this.writeCL)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl("astyanaxConnectionPool").setPort(9160).setMaxConnsPerHost(this.connectionPoolSize).setSeeds(seeds)).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        context.start();
        this.keyspace = (Keyspace)context.getClient();
    }

    public ConsistencyLevel getReadCL() {
        return this.readCL;
    }

    public void setReadCL(ConsistencyLevel readCL) {
        this.readCL = readCL;
    }

    public ConsistencyLevel getWriteCL() {
        return this.writeCL;
    }

    public void setWriteCL(ConsistencyLevel writeCL) {
        this.writeCL = writeCL;
    }
}

