/*
 * Decompiled with CFR 0.152.
 */
package rapture.cassandra;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import rapture.cassandra.CassandraConstants;
import rapture.common.Formattable;
import rapture.common.Messages;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.config.MultiValueConfigLoader;

public class CassandraBase {
    private static Logger log = Logger.getLogger(CassandraBase.class);
    private String cassHost;
    private int cassPort;
    protected String keySpace;
    protected String columnFamily;
    private TTransport tr;
    private TProtocol proto;
    protected Cassandra.Client client;
    protected static final String UTF8 = "UTF-8";
    private ConsistencyLevel readCL = ConsistencyLevel.ONE;
    private ConsistencyLevel writeCL = ConsistencyLevel.ONE;
    public Messages messageCatalog = new Messages("Cassandra");

    public String getColumnFamily() {
        return this.columnFamily;
    }

    protected ByteBuffer getByteBuffer(String val) throws UnsupportedEncodingException {
        return ByteBuffer.wrap(val.getBytes(UTF8));
    }

    public CassandraBase(String instance, Map<String, String> config) {
        String cassPortString;
        this.cassHost = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".host"));
        if (this.cassHost == null) {
            this.cassHost = "localhost";
        }
        if ((cassPortString = MultiValueConfigLoader.getConfig((String)("CASSANDRA-" + instance + ".port"))) == null) {
            cassPortString = "9160";
        }
        this.cassPort = Integer.valueOf(cassPortString);
        this.keySpace = config.get(CassandraConstants.KEYSPACECFG);
        this.columnFamily = config.get(CassandraConstants.CFCFG);
        try {
            this.getConnection();
        }
        catch (TTransportException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
        }
        this.ensureAllPresent();
        if (config.containsKey("readConsistency")) {
            this.readCL = ConsistencyLevel.valueOf((String)config.get("readConsistency"));
        }
        if (config.containsKey("writeConsistency")) {
            this.writeCL = ConsistencyLevel.valueOf((String)config.get("writeConsistency"));
        }
    }

    public void ensureStandardCF(String cfName) throws InvalidRequestException, TException, UnavailableException, TimedOutException, SchemaDisagreementException {
        KsDef keyspace = this.getKeyspace(this.keySpace);
        log.info((Object)String.format("Ensuring standard cf:%s", cfName));
        for (CfDef cfdef : keyspace.getCf_defs()) {
            if (!cfdef.getName().equals(cfName)) continue;
            return;
        }
        String cql = "CREATE TABLE %s (KEY text PRIMARY KEY) WITH comparator=text";
        this.executeCQL(String.format(cql, cfName));
    }

    private KsDef getKeyspace(String keys) throws InvalidRequestException, TException {
        List keyspaces = this.client.describe_keyspaces();
        for (KsDef k : keyspaces) {
            if (!k.getName().equals(keys)) continue;
            return k;
        }
        return null;
    }

    private void ensureAllPresent() {
        log.info((Object)String.format("Ensuring keyspace:%s and cf:%s are present", this.keySpace, this.columnFamily));
        try {
            KsDef keyspace = this.getKeyspace(this.keySpace);
            if (keyspace == null) {
                String cql = "CREATE keyspace " + this.keySpace + " WITH strategy_class = 'SimpleStrategy' AND strategy_options:replication_factor = '1'";
                this.executeCQL(cql);
            }
            this.client.set_keyspace(this.keySpace);
            this.ensureStandardCF(this.columnFamily);
        }
        catch (InvalidRequestException | SchemaDisagreementException | TimedOutException | UnavailableException | TException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
        }
    }

    private void getConnection() throws TTransportException {
        log.info((Object)String.format("Connecting to Cassandra at %s:%d", this.cassHost, this.cassPort));
        this.tr = new TFramedTransport((TTransport)new TSocket(this.cassHost, this.cassPort));
        this.proto = new TBinaryProtocol(this.tr);
        this.client = new Cassandra.Client(this.proto);
        this.tr.open();
    }

    protected void executeCQL(String cql) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        try {
            this.client.execute_cql_query(ByteBuffer.wrap(cql.getBytes(UTF8)), Compression.NONE);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Argument is not in UTF-8 character set");
        }
    }

    public ConsistencyLevel getReadCL() {
        return this.readCL;
    }

    public void setReadCL(ConsistencyLevel readCL) {
        this.readCL = readCL;
    }

    public ConsistencyLevel getWriteCL() {
        return this.writeCL;
    }

    public void setWriteCL(ConsistencyLevel writeCL) {
        this.writeCL = writeCL;
    }
}

