/*
 * Decompiled with CFR 0.152.
 */
package rapture.repo.cassandra;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.util.RangeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import rapture.cassandra.AstyanaxCassandraBase;
import rapture.common.Formattable;
import rapture.common.RaptureFolderInfo;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.repo.cassandra.ConfigParser;
import rapture.repo.cassandra.key.KeyNormalizer;
import rapture.repo.cassandra.key.NormalizedKey;
import rapture.repo.cassandra.key.PathBuilder;

public class AstyanaxRepoConnection
extends AstyanaxCassandraBase {
    protected static Logger log = Logger.getLogger(AstyanaxRepoConnection.class);
    protected final KeyNormalizer keyNormalizer;
    private Optional<String> pKeyPrefix;

    public AstyanaxRepoConnection(String instance, Map<String, String> config) {
        super(instance, config);
        this.keyNormalizer = new KeyNormalizer(this.pKeyPrefix);
    }

    @Override
    protected void setupStorageDetails(Map<String, String> config) {
        ConfigParser configParser = new ConfigParser(config);
        configParser.parse();
        this.setKeyspaceName(configParser.getKeyspaceName());
        this.setColumnFamilyName(configParser.getCfName());
        this.pKeyPrefix = configParser.getpKeyPrefix();
    }

    public boolean drop() {
        return false;
    }

    public void dropRepo() {
        this.dropRepo(this.columnFamily.getName());
    }

    public void dropRepo(String columnFam) {
        try {
            this.keyspace.dropColumnFamily(columnFam);
            if (this.keyspace.describeKeyspace().getColumnFamilyList().size() == 0) {
                this.keyspace.dropKeyspace();
            }
        }
        catch (ConnectionException e) {
            log.error((Object)e);
        }
    }

    public boolean deleteEntries(List<String> keys) {
        List<NormalizedKey> normalizedKeys = this.keyNormalizer.normalizeKeys(keys);
        MutationBatch mb = this.keyspace.prepareMutationBatch();
        for (NormalizedKey key : normalizedKeys) {
            mb.withRow(this.columnFamily, (Object)key.get()).delete();
        }
        try {
            mb.execute();
        }
        catch (ConnectionException ce) {
            log.error((Object)ce);
            return false;
        }
        return true;
    }

    public boolean deleteEntry(String key) {
        NormalizedKey normalizedKey = this.keyNormalizer.normalizeKey(key);
        MutationBatch mb = this.keyspace.prepareMutationBatch();
        mb.withRow(this.columnFamily, (Object)normalizedKey.get()).delete();
        try {
            mb.execute();
        }
        catch (ConnectionException ce) {
            log.error((Object)ce);
            return false;
        }
        return true;
    }

    public boolean deleteVersionsUpTo(String key, String versionColumnName) {
        throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("NotImplemented"));
    }

    protected String getVersionColumnName() {
        return "data";
    }

    public String get(String key) {
        return this.get(key, this.getVersionColumnName());
    }

    public String get(String key, String versionColumnName) {
        ColumnList result;
        NormalizedKey normalizedKey = this.keyNormalizer.normalizeKey(key);
        try {
            result = (ColumnList)this.keyspace.prepareQuery(this.columnFamily).getKey((Object)normalizedKey.get()).withColumnRange(new RangeBuilder().setStart(versionColumnName).setEnd(versionColumnName).setLimit(1).build()).execute().getResult();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        if (!result.isEmpty()) {
            return result.getColumnByName((Object)versionColumnName).getStringValue();
        }
        return null;
    }

    public long getRowNumber() {
        try {
            long count = 0L;
            Rows rows = (Rows)this.keyspace.prepareQuery(this.columnFamily).getAllRows().execute().getResult();
            for (Row row : rows) {
                count += (long)row.getColumns().size();
            }
            return count;
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
    }

    public List<String> batchGet(List<String> rawKeys) {
        ArrayList<String> ret = new ArrayList<String>(rawKeys.size());
        for (String k : rawKeys) {
            ret.add(this.get(k));
        }
        return ret;
    }

    public void putData(String key, String value) {
        this.putData(key, this.getVersionColumnName(), value);
    }

    public void putData(String key, String versionColumnName, String value) {
        NormalizedKey normalizedKey = this.keyNormalizer.normalizeKey(key);
        try {
            this.keyspace.prepareColumnMutation(this.columnFamily, (Object)normalizedKey.get(), (Object)versionColumnName).putValue(value, null).execute();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
    }

    private int getFolderCount(String cf, String rawPrefix, String childName) {
        ColumnList result;
        NormalizedKey prefix = this.keyNormalizer.normalizePrefix(rawPrefix);
        try {
            ColumnFamily cFam = ColumnFamily.newColumnFamily((String)cf, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
            result = (ColumnList)this.keyspace.prepareQuery(cFam).getKey((Object)prefix.get()).withColumnRange(new RangeBuilder().setStart(childName).setEnd(childName).setLimit(1).build()).execute().getResult();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        if (!result.isEmpty()) {
            return result.getColumnByName((Object)childName).getIntegerValue();
        }
        return 0;
    }

    public void addFolderDocument(String cf, String prefix, String docName) {
        this.addPrefixValue(cf, prefix, docName, -1);
    }

    private void addPrefixValue(String cf, String rawPrefix, String childName, int folderCount) {
        NormalizedKey normalizedPrefix = this.keyNormalizer.normalizePrefix(rawPrefix);
        try {
            ColumnFamily cFam = ColumnFamily.newColumnFamily((String)cf, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
            this.keyspace.prepareColumnMutation(cFam, (Object)normalizedPrefix.get(), (Object)childName).putValue(folderCount, null).execute();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
    }

    public void addFolderFolder(String cf, String prefix, String childName) {
        int folderCount = this.getFolderCount(cf, prefix, childName);
        this.addPrefixValue(cf, prefix, childName, ++folderCount);
    }

    List<RaptureFolderInfo> getFolderChildren(String cf, String prefix) {
        return this.getFolderChildren(cf, this.keyNormalizer.normalizePrefix(prefix));
    }

    private List<RaptureFolderInfo> getFolderChildren(String cf, NormalizedKey prefix) {
        ColumnList result;
        ArrayList<RaptureFolderInfo> ret = new ArrayList<RaptureFolderInfo>();
        try {
            ColumnFamily cFam = ColumnFamily.newColumnFamily((String)cf, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
            result = (ColumnList)this.keyspace.prepareQuery(cFam).getKey((Object)prefix.get()).withColumnRange(new RangeBuilder().setLimit(1000).build()).execute().getResult();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        for (Column column : result) {
            RaptureFolderInfo info = new RaptureFolderInfo();
            info.setName((String)column.getName());
            info.setFolder(column.getIntegerValue() != -1);
            ret.add(info);
        }
        return ret;
    }

    public List<String> getAllFolderChildren(String cf, String prefix) {
        NormalizedKey normalizedPrefix = this.keyNormalizer.normalizePrefix(prefix);
        ArrayList<String> ret = new ArrayList<String>();
        List<RaptureFolderInfo> thisLevel = this.getFolderChildren(cf, normalizedPrefix);
        for (RaptureFolderInfo info : thisLevel) {
            if (info.isFolder()) {
                String lowerLevel = new PathBuilder(prefix).subPath(info.getName()).build();
                ret.addAll(this.getAllFolderChildren(cf, lowerLevel));
                continue;
            }
            ret.add(new PathBuilder(prefix).subPath(info.getName()).build());
        }
        return ret;
    }

    private void removePrefixValue(String cf, String rawPrefix, String docName) {
        NormalizedKey normalizedPrefix = this.keyNormalizer.normalizePrefix(rawPrefix);
        ColumnFamily cFam = ColumnFamily.newColumnFamily((String)cf, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        try {
            this.keyspace.prepareColumnMutation(cFam, (Object)normalizedPrefix.get(), (Object)docName).deleteColumn().execute();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
    }

    public void removeFolderDocument(String cf, String prefix, String docName) {
        this.removePrefixValue(cf, prefix, docName);
    }

    public void removeFolderFolder(String cf, String prefix, String childName) {
        int folderCount = this.getFolderCount(cf, prefix, childName);
        if (folderCount != 0) {
            if (--folderCount != 0) {
                this.addPrefixValue(cf, prefix, childName, folderCount);
            } else {
                this.removePrefixValue(cf, prefix, childName);
            }
        }
    }

    public void ensureStandardCF(String cf) {
        try {
            if (this.keyspace.describeKeyspace().getColumnFamily(cf) == null) {
                ColumnFamily cFam = ColumnFamily.newColumnFamily((String)cf, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
                this.keyspace.createColumnFamily(cFam, (Map)ImmutableMap.builder().put((Object)"key_validation_class", (Object)"UTF8Type").put((Object)"comparator_type", (Object)"UTF8Type").build());
            }
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
    }

    public Boolean validate() {
        this.get("ignore");
        return true;
    }

    public String getUniqueId() {
        return String.format("%s-%s-%s", this.getKeyspaceName(), this.getColumnFamilyName(), this.pKeyPrefix.isPresent() ? this.pKeyPrefix.get() : "[]");
    }

    public Optional<String> getPKeyPrefix() {
        return this.pKeyPrefix;
    }
}

