/*
 * Decompiled with CFR 0.152.
 */
package rapture.repo.cassandra;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.util.RangeBuilder;
import java.util.Iterator;
import java.util.Map;
import rapture.common.Formattable;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.repo.cassandra.AstyanaxRepoConnection;
import rapture.repo.cassandra.key.NormalizedKey;

public class AstyanaxVersionedRepoConnection
extends AstyanaxRepoConnection {
    public AstyanaxVersionedRepoConnection(String instance, Map<String, String> config) {
        super(instance, config);
    }

    @Override
    protected String getVersionColumnName() {
        return "" + System.currentTimeMillis();
    }

    @Override
    public String get(String key, String versionColumnName) {
        ColumnList result;
        NormalizedKey normalizedKey = this.keyNormalizer.normalizeKey(key);
        try {
            result = (ColumnList)this.keyspace.prepareQuery(this.columnFamily).getKey((Object)normalizedKey.get()).withColumnRange(new RangeBuilder().setStart(versionColumnName).setLimit(1).setReversed(true).build()).execute().getResult();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        if (!result.isEmpty()) {
            return result.getColumnByIndex(0).getStringValue();
        }
        return null;
    }

    @Override
    public boolean deleteVersionsUpTo(String key, String versionColumnName) {
        ColumnList result;
        NormalizedKey normalizedKey = this.keyNormalizer.normalizeKey(key);
        try {
            result = (ColumnList)this.keyspace.prepareQuery(this.columnFamily).getKey((Object)normalizedKey.get()).withColumnRange(new RangeBuilder().setEnd(versionColumnName).build()).execute().getResult();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        if (!result.isEmpty()) {
            MutationBatch mutationBatch = this.keyspace.prepareMutationBatch();
            ColumnListMutation columnListMutation = mutationBatch.withRow(this.columnFamily, (Object)normalizedKey.get());
            Iterator columnIterator = result.iterator();
            while (columnIterator.hasNext()) {
                columnListMutation.deleteColumn(((Column)columnIterator.next()).getName());
            }
            try {
                mutationBatch.execute();
            }
            catch (ConnectionException ce) {
                log.error((Object)ce);
                return false;
            }
        }
        return true;
    }
}

