/*
 * Decompiled with CFR 0.152.
 */
package rapture.repo.cassandra;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import rapture.common.RaptureFolderInfo;
import rapture.repo.cassandra.AstyanaxRepoConnection;
import rapture.repo.cassandra.key.PathBuilder;

public class CassFolderHandler {
    private static final String FOLDERPOSTFIX = "_folder";
    private static Logger log = Logger.getLogger(CassFolderHandler.class);
    public static final String DOLLAR_ROOT = "$root";
    private AstyanaxRepoConnection cass;
    private String cf;

    public CassFolderHandler(AstyanaxRepoConnection cass, String standardCf) {
        this.cass = cass;
        this.cf = standardCf + FOLDERPOSTFIX;
        try {
            cass.ensureStandardCF(this.cf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        this.cass.dropRepo(this.cf);
    }

    public void registerDocument(String k) {
        String[] pathParts = k.split("/");
        StringBuilder currentPrefix = new StringBuilder();
        for (int i = 0; i < pathParts.length; ++i) {
            String prefixKey;
            if (currentPrefix.length() == 0) {
                prefixKey = DOLLAR_ROOT;
                currentPrefix.append(pathParts[i]);
            } else {
                prefixKey = currentPrefix.toString();
                currentPrefix.append("/");
                currentPrefix.append(pathParts[i]);
            }
            if (i == pathParts.length - 1) {
                log.debug((Object)String.format("Adding folder document %s:%s", prefixKey, pathParts[i]));
                this.cass.addFolderDocument(this.cf, prefixKey, pathParts[i]);
                continue;
            }
            log.debug((Object)String.format("Adding folder %s:%s", prefixKey, pathParts[i]));
            this.cass.addFolderFolder(this.cf, prefixKey, pathParts[i]);
        }
    }

    public List<RaptureFolderInfo> getChildren(String prefix) {
        return this.cass.getFolderChildren(this.cf, prefix);
    }

    public List<String> getAllChildren(String prefix) {
        return this.cass.getAllFolderChildren(this.cf, prefix);
    }

    public void removeDocument(String k) {
        String[] pathParts = k.split("/");
        StringBuilder currentPrefix = new StringBuilder();
        for (int i = 0; i < pathParts.length; ++i) {
            if (currentPrefix.length() == 0) {
                currentPrefix.append(pathParts[i]);
                continue;
            }
            if (i == pathParts.length - 1) {
                this.cass.removeFolderDocument(this.cf, currentPrefix.toString(), pathParts[i]);
            } else {
                this.cass.removeFolderFolder(this.cf, currentPrefix.toString(), pathParts[i]);
            }
            currentPrefix.append("/");
            currentPrefix.append(pathParts[i]);
        }
    }

    public List<RaptureFolderInfo> removeChildren(String prefix, Boolean force) {
        LinkedList<RaptureFolderInfo> ret = new LinkedList<RaptureFolderInfo>();
        List<RaptureFolderInfo> fi = this.getChildren(prefix);
        for (RaptureFolderInfo f : fi) {
            String next = new PathBuilder(prefix).subPath(f.getName()).build();
            RaptureFolderInfo rfi = new RaptureFolderInfo();
            rfi.setName(next);
            if (f.isFolder()) {
                ret.addAll(this.removeChildren(next, force));
                rfi.setFolder(true);
            } else {
                rfi.setFolder(false);
            }
            this.removeDocument(next);
            ret.add(rfi);
        }
        return ret;
    }
}

