/*
 * Decompiled with CFR 0.152.
 */
package rapture.repo.cassandra;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rapture.cassandra.CassandraConstants;
import rapture.common.RaptureFolderInfo;
import rapture.common.RaptureNativeQueryResult;
import rapture.common.RaptureQueryResult;
import rapture.common.exception.RaptNotSupportedException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JsonContent;
import rapture.index.IndexHandler;
import rapture.index.IndexProducer;
import rapture.repo.KeyStore;
import rapture.repo.RepoLockHandler;
import rapture.repo.RepoVisitor;
import rapture.repo.StoreKeyVisitor;
import rapture.repo.cassandra.AstyanaxRepoConnection;
import rapture.repo.cassandra.AstyanaxVersionedRepoConnection;
import rapture.repo.cassandra.CassFolderHandler;
import rapture.repo.cassandra.key.PathBuilder;

public class CassandraKeyStore
implements KeyStore {
    private CassFolderHandler folderHandler;
    private AstyanaxRepoConnection repoConnection;
    private String instance = "default";
    private Map<String, String> config;
    private boolean usesFolderHandling = true;
    private boolean useVersionedRepoConnection = false;

    public void setConfig(Map<String, String> config) {
        this.config = config;
        this.repoConnection = this.useVersionedRepoConnection ? new AstyanaxVersionedRepoConnection(this.instance, this.config) : new AstyanaxRepoConnection(this.instance, this.config);
        this.folderHandler = new CassFolderHandler(this.repoConnection, this.repoConnection.getColumnFamilyName());
    }

    public void setUseVersionedRepoConnection(Boolean useIt) {
        this.useVersionedRepoConnection = useIt;
    }

    public void resetFolderHandling() {
        this.usesFolderHandling = false;
    }

    public boolean containsKey(String ref) {
        return this.get(ref) != null;
    }

    public long countKeys() throws RaptNotSupportedException {
        return 0L;
    }

    public KeyStore createRelatedKeyStore(String relation) {
        HashMap<String, String> configCopy = new HashMap<String, String>(this.config);
        configCopy.put(CassandraConstants.CFCFG, this.repoConnection.getColumnFamilyName() + "_" + relation);
        if (this.repoConnection.getPKeyPrefix().isPresent()) {
            configCopy.put(CassandraConstants.PARTITION_KEY_PREFIX, (String)this.repoConnection.getPKeyPrefix().get());
        }
        CassandraKeyStore ret = new CassandraKeyStore();
        ret.setInstanceName(this.instance);
        if (relation.equals("version") || relation.equals("meta")) {
            ret.setUseVersionedRepoConnection(true);
        }
        ret.setConfig(configCopy);
        if (!this.usesFolderHandling) {
            ret.resetFolderHandling();
        }
        return ret;
    }

    public boolean delete(String key) {
        if (this.usesFolderHandling) {
            this.folderHandler.removeDocument(key);
        }
        return this.repoConnection.deleteEntry(key);
    }

    public boolean delete(List<String> keys) {
        if (this.usesFolderHandling) {
            for (String key : keys) {
                this.folderHandler.removeDocument(key);
            }
        }
        return this.repoConnection.deleteEntries(keys);
    }

    public boolean deleteUpTo(String key, long millisTimestamp) {
        return this.repoConnection.deleteVersionsUpTo(key, "" + millisTimestamp);
    }

    public boolean dropKeyStore() {
        if (this.usesFolderHandling) {
            this.folderHandler.drop();
        }
        this.repoConnection.dropRepo();
        return true;
    }

    public String get(String k) {
        return this.repoConnection.get(k);
    }

    public String get(String k, long millisTimestamp) {
        return this.repoConnection.get(k, Long.toString(millisTimestamp));
    }

    public List<String> getBatch(List<String> keys) {
        return this.repoConnection.batchGet(keys);
    }

    public String getStoreId() {
        return this.repoConnection.getUniqueId();
    }

    public void put(String k, String v) {
        this.repoConnection.putData(k, v);
        if (this.usesFolderHandling) {
            this.folderHandler.registerDocument(k);
        }
    }

    public void put(String k, long millisTimestamp, String v) {
        this.repoConnection.putData(k, "" + millisTimestamp, v);
        if (this.usesFolderHandling) {
            this.folderHandler.registerDocument(k);
        }
    }

    public RaptureQueryResult runNativeQuery(String repoType, List<String> queryParams) {
        throw new UnsupportedOperationException("Native queries not supported in Cassandra yet!");
    }

    public RaptureNativeQueryResult runNativeQueryWithLimitAndBounds(String repoType, List<String> queryParams, int limit, int offset) {
        throw new UnsupportedOperationException("Native queries not supported in Cassandra yet!");
    }

    public void setInstanceName(String instanceName) {
        this.instance = instanceName;
    }

    public void visit(String folderPrefix, RepoVisitor iRepoVisitor) {
        String content;
        JsonContent jc;
        RaptureFolderInfo folder;
        String fullName;
        if (!this.usesFolderHandling) {
            throw RaptureExceptionFactory.create((Integer)500, (String)"No folder handling");
        }
        List<RaptureFolderInfo> thisFolder = this.folderHandler.getChildren(folderPrefix);
        Iterator<RaptureFolderInfo> iterator = thisFolder.iterator();
        while (iterator.hasNext() && iRepoVisitor.visit(fullName = new PathBuilder(folderPrefix).subPath((folder = iterator.next()).getName()).build(), jc = new JsonContent(content = folder.isFolder() ? null : this.get(fullName)), folder.isFolder())) {
        }
    }

    public void visitKeys(String prefix, StoreKeyVisitor iStoreKeyVisitor) {
        List<String> docKeys = this.getAllSubKeys(prefix);
        for (String dK : docKeys) {
            String content;
            if (!iStoreKeyVisitor.visit(dK, content = this.get(dK))) break;
        }
    }

    public void visitKeysFromStart(String startPoint, StoreKeyVisitor iStoreKeyVisitor) {
        this.visitKeys(startPoint, iStoreKeyVisitor);
    }

    public List<RaptureFolderInfo> getSubKeys(String prefix) {
        if (this.usesFolderHandling) {
            return this.folderHandler.getChildren(prefix);
        }
        throw RaptureExceptionFactory.create((Integer)500, (String)"No folder handling supported");
    }

    public List<RaptureFolderInfo> removeSubKeys(String folder, Boolean force) {
        if (this.usesFolderHandling) {
            return this.folderHandler.removeChildren(folder, force);
        }
        throw RaptureExceptionFactory.create((Integer)500, (String)"No folder handling supported");
    }

    public boolean matches(String key, String value) {
        String v = this.get(key);
        if (v != null) {
            return v.equals(value);
        }
        return false;
    }

    public List<String> getAllSubKeys(String prefix) {
        if (this.usesFolderHandling) {
            return this.folderHandler.getAllChildren(prefix);
        }
        throw RaptureExceptionFactory.create((Integer)500, (String)"No folder handling supported");
    }

    public IndexHandler createIndexHandler(IndexProducer indexProducer) {
        return null;
    }

    public Boolean validate() {
        return this.repoConnection.validate();
    }

    public long getSize() {
        long result = this.repoConnection.getRowNumber();
        return result;
    }

    public void setRepoLockHandler(RepoLockHandler repoLockHandler) {
    }

    public boolean supportsVersionLookupByTime() {
        return true;
    }
}

