/*
 * Decompiled with CFR 0.152.
 */
package rapture.repo.cassandra;

import com.google.common.base.Optional;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import rapture.cassandra.CassandraConstants;

public class ConfigParser {
    private static final Optional<String> ABSENT = Optional.absent();
    private final Map<String, String> config;
    private String keyspaceName;
    private String cfName;
    private Optional<String> pKeyPrefix;

    public ConfigParser(Map<String, String> config) {
        this.config = config;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void parse() {
        this.keyspaceName = this.config.get(CassandraConstants.KEYSPACECFG);
        this.cfName = this.config.get(CassandraConstants.CFCFG);
        if (StringUtils.isBlank((String)this.cfName)) {
            String authority = this.config.get("authority");
            if (!StringUtils.isBlank((String)authority)) {
                int indexDot = authority.indexOf(".");
                if (indexDot != -1) {
                    this.cfName = authority.substring(0, indexDot);
                    this.pKeyPrefix = authority.length() > indexDot + 1 ? Optional.of((Object)authority.substring(indexDot + 1, authority.length())) : ABSENT;
                } else {
                    this.cfName = authority;
                    this.pKeyPrefix = ABSENT;
                }
            }
        } else {
            String tempPrefix = this.config.get(CassandraConstants.PARTITION_KEY_PREFIX);
            this.pKeyPrefix = StringUtils.isBlank((String)tempPrefix) ? ABSENT : Optional.of((Object)tempPrefix);
        }
    }

    public String getCfName() {
        return this.cfName;
    }

    public Optional<String> getpKeyPrefix() {
        return this.pKeyPrefix;
    }
}

