/*
 * Decompiled with CFR 0.152.
 */
package rapture.repo.cassandra.key;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import rapture.repo.cassandra.key.NormalizedKey;
import rapture.repo.cassandra.key.PathStripper;

public class KeyNormalizer {
    private static final String NORMALIZED_FORMAT = "%s/%s";
    private static final Logger log = Logger.getLogger(KeyNormalizer.class);
    private final Optional<String> pKeyPrefix;

    public KeyNormalizer(Optional<String> pKeyPrefix) {
        this.pKeyPrefix = pKeyPrefix;
    }

    public List<NormalizedKey> normalizeKeys(List<String> original) {
        ArrayList<NormalizedKey> normalized = new ArrayList<NormalizedKey>(original.size());
        for (String key : original) {
            normalized.add(this.normalizeKey(key));
        }
        return normalized;
    }

    public NormalizedKey normalizeKey(String key) {
        if (this.pKeyPrefix.isPresent()) {
            return new NormalizedKey(String.format(NORMALIZED_FORMAT, this.pKeyPrefix.get(), key));
        }
        return new NormalizedKey(key);
    }

    public NormalizedKey normalizePrefix(String prefix) {
        prefix = PathStripper.stripPrefix(prefix);
        return this.normalizeKey(prefix);
    }
}

