/*
 * Decompiled with CFR 0.152.
 */
package rapture.series.cassandra;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.util.RangeBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import rapture.cassandra.AstyanaxCassandraBase;
import rapture.common.Formattable;
import rapture.common.RaptureFolderInfo;
import rapture.common.SeriesValue;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.dsl.serfun.SeriesValueCodec;
import rapture.dsl.serfun.StringSeriesValue;
import rapture.series.children.ChildKeyUtil;
import rapture.series.children.ChildrenRepo;

public class AstyanaxSeriesConnection
extends AstyanaxCassandraBase {
    private static final String DIRECTORY_KEY = "..directory";
    private final int OVERFLOW_LIMIT;
    private Cache<String, Boolean> keyCache = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.SECONDS).build();
    private final ChildrenRepo childrenRepo;
    private static Function<SeriesValue, String> colFunc = new Function<SeriesValue, String>(){

        public String apply(SeriesValue v) {
            return v.getColumn();
        }
    };
    private Callable<Boolean> FALSE_CALL = new Callable<Boolean>(){

        @Override
        public Boolean call() {
            return false;
        }
    };

    public AstyanaxSeriesConnection(String instance, Map<String, String> config, int overflowLimit) {
        super(instance, config);
        this.OVERFLOW_LIMIT = overflowLimit;
        this.childrenRepo = new ChildrenRepo(){

            public List<SeriesValue> getPoints(String key) {
                try {
                    return AstyanaxSeriesConnection.this.getPoints(key);
                }
                catch (IOException e) {
                    throw RaptureExceptionFactory.create((Integer)500, (Formattable)AstyanaxSeriesConnection.this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
                }
            }

            public boolean addPoint(String key, SeriesValue value) {
                AstyanaxSeriesConnection.this.addPoint(key, value);
                return true;
            }

            public boolean dropPoints(String key, List<String> points) {
                return AstyanaxSeriesConnection.this.dropPoints(key, points);
            }

            public boolean dropRow(String key) {
                return AstyanaxSeriesConnection.this.dropAllPoints(key);
            }
        };
    }

    public void drop() throws OperationException, ConnectionException {
        this.keyCache.invalidateAll();
        this.keyspace.truncateColumnFamily(this.columnFamily);
    }

    private SeriesValue makeSeriesValueFromByteArray(String column, byte[] array) throws IOException {
        return SeriesValueCodec.decode((String)column, (byte[])array);
    }

    public void addPoint(String key, SeriesValue value) {
        this.registerKey(key);
        try {
            this.keyspace.prepareColumnMutation(this.columnFamily, (Object)key, (Object)value.getColumn()).putValue(SeriesValueCodec.encodeValue((SeriesValue)value), null).execute();
        }
        catch (ConnectionException | UnsupportedEncodingException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
    }

    public Boolean dropPoints(String key, List<String> columns) {
        MutationBatch m = this.keyspace.prepareMutationBatch();
        for (String columnName : columns) {
            m.withRow(this.columnFamily, (Object)key).deleteColumn((Object)columnName);
        }
        try {
            m.execute();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        return true;
    }

    public boolean dropAllPoints(String key) {
        this.unregisterKey(key);
        MutationBatch m = this.keyspace.prepareMutationBatch();
        m.withRow(this.columnFamily, (Object)key).delete();
        try {
            m.execute();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        return true;
    }

    public List<SeriesValue> getPoints(String key) throws IOException {
        String startColumn = "";
        return this.getPointsAfter(key, startColumn, Integer.MAX_VALUE, false);
    }

    public List<SeriesValue> getPointsAfter(String key, String startColumn, int maxNumber, boolean reverse) throws IOException {
        return this.getPointsAfter(key, startColumn, "", maxNumber, reverse);
    }

    public List<SeriesValue> getPointsAfter(String key, String startColumn, String endColumn, int maxNumber, boolean reverse) throws IOException {
        ColumnList result;
        ArrayList<SeriesValue> ret = new ArrayList<SeriesValue>();
        int limit = maxNumber > this.OVERFLOW_LIMIT ? this.OVERFLOW_LIMIT + 1 : maxNumber;
        try {
            result = (ColumnList)this.keyspace.prepareQuery(this.columnFamily).getKey((Object)key).withColumnRange(new RangeBuilder().setStart(startColumn).setEnd(endColumn).setLimit(limit).setReversed(reverse).build()).execute().getResult();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        if (result.size() > this.OVERFLOW_LIMIT) {
            throw RaptureExceptionFactory.create((Formattable)this.messageCatalog.getMessage("SmallerPages", "" + this.OVERFLOW_LIMIT));
        }
        for (Column column : result) {
            ret.add(this.makeSeriesValue((Column<String>)column));
        }
        return ret;
    }

    public List<String> getSeriesLike(String keyPrefix) throws IOException {
        if (Strings.isNullOrEmpty((String)keyPrefix)) {
            List<SeriesValue> listings = this.getPoints(DIRECTORY_KEY);
            return Lists.transform(listings, colFunc);
        }
        int lastCharValue = keyPrefix.charAt(keyPrefix.length() - 1) + '\u0001';
        String endPrefix = keyPrefix.substring(0, keyPrefix.length() - 1) + (char)lastCharValue;
        List<SeriesValue> listings = this.getPointsAfter(DIRECTORY_KEY, keyPrefix, endPrefix, Integer.MAX_VALUE, false);
        List result = Lists.transform(listings, colFunc);
        if (result.size() > 0 && endPrefix.equals(result.get(result.size() - 1))) {
            result.subList(result.size() - 1, result.size()).clear();
        }
        return result;
    }

    public void addPoint(String key, List<SeriesValue> values) {
        boolean nullKey = false;
        try {
            this.registerKey(key);
            MutationBatch m = this.keyspace.prepareMutationBatch();
            ColumnListMutation mut = m.withRow(this.columnFamily, (Object)key);
            for (SeriesValue value : values) {
                if (value.getColumn() == null) {
                    nullKey = true;
                    continue;
                }
                mut.putColumn((Object)value.getColumn(), SeriesValueCodec.encodeValue((SeriesValue)value), null);
            }
            m.execute();
        }
        catch (ConnectionException ce) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)ce);
        }
        catch (UnsupportedEncodingException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("BadSeriesValue"), (Throwable)e);
        }
        if (nullKey) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.messageCatalog.getMessage("BadKey"));
        }
    }

    void registerKey(String key) {
        if (DIRECTORY_KEY.equals(key) || ChildKeyUtil.isRowKey((String)key)) {
            return;
        }
        try {
            if (!((Boolean)this.keyCache.get((Object)key, this.FALSE_CALL)).booleanValue()) {
                this.addPoint(DIRECTORY_KEY, (SeriesValue)new StringSeriesValue(".", key));
                this.childrenRepo.registerParentage(key);
                this.keyCache.put((Object)key, (Object)true);
            }
        }
        catch (ExecutionException e) {
            throw RaptureExceptionFactory.create((String)"Severe: the line 'return false;' just failed");
        }
    }

    void unregisterKey(String key) {
        this.unregisterKey(key, false);
    }

    boolean unregisterKey(String key, boolean isFolder) {
        boolean ret = false;
        if (DIRECTORY_KEY.equals(key)) {
            return ret;
        }
        this.dropPoints(DIRECTORY_KEY, (List<String>)ImmutableList.of((Object)key));
        ret = isFolder ? this.childrenRepo.dropFolderEntry(key) : this.childrenRepo.dropFileEntry(key);
        this.keyCache.invalidate((Object)key);
        return ret;
    }

    private final SeriesValue makeSeriesValue(Column<String> column) throws IOException {
        return this.makeSeriesValueFromByteArray((String)column.getName(), column.getByteArrayValue());
    }

    public List<RaptureFolderInfo> getChildren(String folderName) {
        return this.childrenRepo.getChildren(folderName);
    }
}

