/*
 * Decompiled with CFR 0.152.
 */
package rapture.series.cassandra;

import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import rapture.cassandra.CassandraConstants;
import rapture.common.Formattable;
import rapture.common.Messages;
import rapture.common.RaptureFolderInfo;
import rapture.common.SeriesValue;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.dsl.serfun.DecimalSeriesValue;
import rapture.dsl.serfun.LongSeriesValue;
import rapture.dsl.serfun.StringSeriesValue;
import rapture.dsl.serfun.StructureSeriesValueImpl;
import rapture.series.SeriesPaginator;
import rapture.series.SeriesStore;
import rapture.series.cassandra.AstyanaxSeriesConnection;

public class CassandraSeriesStore
implements SeriesStore {
    private AstyanaxSeriesConnection cass;
    Messages messageCatalog = new Messages("Cassandra");
    private String instance = "default";
    private Map<String, String> config;

    public void drop() {
        try {
            this.cass.drop();
        }
        catch (ConnectionException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
        }
    }

    public void addPointToSeries(String key, SeriesValue value) {
        if (value.getColumn() == null) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.messageCatalog.getMessage("NoColumnNull"));
        }
        this.cass.addPoint(key, value);
    }

    public void addDoubleToSeries(String key, String column, double value) {
        this.addPointToSeries(key, (SeriesValue)new DecimalSeriesValue(value, column));
    }

    public void addDoublesToSeries(String key, List<String> columns, List<Double> values) {
        this.addPointsToSeries(key, DecimalSeriesValue.zip(columns, values));
    }

    public void addLongToSeries(String key, String column, long value) {
        this.addPointToSeries(key, (SeriesValue)new LongSeriesValue(value, column));
    }

    public void addLongsToSeries(String key, List<String> columns, List<Long> values) {
        this.addPointsToSeries(key, LongSeriesValue.zip(columns, values));
    }

    public void addStringToSeries(String key, String column, String value) {
        this.addPointToSeries(key, (SeriesValue)new StringSeriesValue(value, column));
    }

    public void addStringsToSeries(String key, List<String> columns, List<String> values) {
        this.addPointsToSeries(key, StringSeriesValue.zip(columns, values));
    }

    public void addStructureToSeries(String key, String column, String jsonValue) {
        try {
            this.addPointToSeries(key, (SeriesValue)StructureSeriesValueImpl.unmarshal((String)jsonValue, (String)column));
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.messageCatalog.getMessage("JsonParseError"), (Throwable)e);
        }
    }

    public void addStructuresToSeries(String key, List<String> columns, List<String> jsonValues) {
        try {
            this.addPointsToSeries(key, StructureSeriesValueImpl.zip(columns, jsonValues));
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.messageCatalog.getMessage("JsonParseError"), (Throwable)e);
        }
    }

    public void addPointsToSeries(String key, List<SeriesValue> values) {
        this.cass.addPoint(key, values);
    }

    public boolean deletePointsFromSeriesByPointKey(String key, List<String> pointKeys) {
        return this.cass.dropPoints(key, pointKeys);
    }

    public boolean deletePointsFromSeries(String key) {
        return this.cass.dropAllPoints(key);
    }

    public List<SeriesValue> getPoints(String key) {
        try {
            return this.cass.getPoints(key);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
        }
    }

    public Iterable<SeriesValue> getRangeAsIteration(String key, String startCol, String endCol, int pageSize) {
        return new SeriesPaginator(key, startCol, endCol, pageSize, (SeriesStore)this);
    }

    public List<SeriesValue> getRangeAsList(String key, String startCol, String endCol) {
        return this.getPointsAfter(key, startCol, endCol, Integer.MAX_VALUE);
    }

    public List<SeriesValue> getPointsAfter(String key, String startColumn, int maxNumber) {
        try {
            return this.cass.getPointsAfter(key, startColumn, maxNumber, false);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
        }
    }

    public List<SeriesValue> getPointsAfterReverse(String docPath, String startColumn, int maxNumber) {
        try {
            return this.cass.getPointsAfter(docPath, startColumn, maxNumber, true);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
        }
    }

    public List<SeriesValue> getPointsAfter(String key, String startColumn, String endColumn, int maxNumber) {
        try {
            return this.cass.getPointsAfter(key, startColumn, endColumn, maxNumber, false);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
        }
    }

    public void setInstanceName(String instanceName) {
        this.instance = instanceName;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
        if (!config.containsKey(CassandraConstants.KEYSPACECFG)) {
            config.put(CassandraConstants.KEYSPACECFG, this.instance);
        }
        if (!config.containsKey(CassandraConstants.CFCFG)) {
            config.put(CassandraConstants.CFCFG, this.instance);
        }
        int overflowLimit = 1000000;
        if (config.containsKey("overflowLimit")) {
            try {
                overflowLimit = Integer.valueOf(config.get("overflowLimit"));
            }
            catch (NumberFormatException ex) {
                throw RaptureExceptionFactory.create((String)"Overflow limit must be an integer value");
            }
        }
        this.cass = new AstyanaxSeriesConnection(this.instance, this.config, overflowLimit);
    }

    public List<String> getSeriesLike(String keyPrefix) {
        try {
            return this.cass.getSeriesLike(keyPrefix);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.messageCatalog.getMessage("DbCommsError"), (Throwable)e);
        }
    }

    public List<RaptureFolderInfo> listSeriesByUriPrefix(String dirName) {
        return this.cass.getChildren(dirName);
    }

    public boolean unregisterKey(String key) {
        return this.cass.unregisterKey(key, false);
    }

    public boolean unregisterKey(String key, boolean isFolder) {
        return this.cass.unregisterKey(key, isFolder);
    }

    public SeriesValue getLastPoint(String key) {
        List<SeriesValue> points = this.getPointsAfterReverse(key, "", 1);
        return points.isEmpty() ? null : points.get(0);
    }

    public void createSeries(String key) {
        this.cass.registerKey(key);
    }

    public void deleteSeries(String key) {
        this.unregisterKey(key);
        this.deletePointsFromSeries(key);
    }
}

