/*
 * Decompiled with CFR 0.152.
 */
package rapture.series.cassandra.config;

import java.util.Map;
import rapture.cassandra.CassandraConstants;
import rapture.common.Messages;
import rapture.series.config.ConfigValidator;
import rapture.series.config.InvalidConfigException;

public class CassandraConfigValidator
implements ConfigValidator {
    public static final String ALPHA_NUM_UNDERSCORE = "^[A-Za-z]([A-Za-z]|_|[0-9]){0,31}$";
    Messages messages = new Messages("Cassandra");

    public void validate(Map<String, String> configMap) throws InvalidConfigException {
        String keyspace = configMap.get(CassandraConstants.KEYSPACECFG);
        if (keyspace == null || keyspace.length() == 0 || !keyspace.matches(ALPHA_NUM_UNDERSCORE)) {
            throw new InvalidConfigException(this.messages.getMessage("BadFormat", (Object[])new String[]{CassandraConstants.KEYSPACECFG, keyspace}).format());
        }
        String cf = configMap.get(CassandraConstants.CFCFG);
        if (cf == null || cf.length() == 0 || !cf.matches(ALPHA_NUM_UNDERSCORE)) {
            throw new InvalidConfigException(this.messages.getMessage("BadFormat", (Object[])new String[]{CassandraConstants.CFCFG, cf}).format());
        }
        String limit = configMap.get("overflowLimit");
        if (limit != null) {
            try {
                Integer.valueOf(limit);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigException(this.messages.getMessage("BadInteger", (Object[])new String[]{"overflowLimit", limit}).format());
            }
        }
    }
}

