/*
 * Decompiled with CFR 0.152.
 */
package rapture.audit.mongodb;

import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.audit.AuditLog;
import rapture.audit.AuditUtil;
import rapture.common.RaptureURI;
import rapture.common.exception.ExceptionToString;
import rapture.common.model.AuditLogEntry;
import rapture.mongodb.MongoDBFactory;
import rapture.mongodb.MongoRetryWrapper;
import rapture.util.IDGenerator;

public class MongoDBAuditLog
implements AuditLog {
    private static Logger log = Logger.getLogger(MongoDBAuditLog.class);
    private static final String CATEGORY = "category";
    private static final String ENTRY_ID = "entryId";
    private static final String SOURCE = "source";
    private static final String WHEN = "when";
    private static final String LOG_ID = "logId";
    private static final String USER = "user";
    private static final String MESSAGE = "message";
    private static final String LEVEL = "level";
    private String tableName;
    private String instanceName = "default";
    private static final String TABLE_NAME = "prefix";
    private String logId;

    private MongoCollection<Document> getAuditCollection() {
        return MongoDBFactory.getCollection(this.instanceName, this.tableName);
    }

    public List<AuditLogEntry> getRecentEntries(final int count) {
        final Document sort = this.getSortObject();
        MongoRetryWrapper<List<AuditLogEntry>> wrapper = new MongoRetryWrapper<List<AuditLogEntry>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                return MongoDBAuditLog.this.getAuditCollection().find().sort((Bson)sort).limit(count);
            }

            @Override
            public List<AuditLogEntry> action(FindIterable<Document> cursor) {
                ArrayList<AuditLogEntry> ret = new ArrayList<AuditLogEntry>();
                MongoDBAuditLog.this.fillFromCursor(ret, (FindIterable<Document>)cursor);
                return ret;
            }
        };
        return (List)wrapper.doAction();
    }

    private static String safeString(Document obj, String fieldName) {
        Object val;
        if (obj != null && (val = obj.get((Object)fieldName)) != null) {
            return val.toString();
        }
        return "";
    }

    private void fillFromCursor(List<AuditLogEntry> ret, FindIterable<Document> cursor) throws MongoException {
        for (Document obj : cursor) {
            AuditLogEntry entry = new AuditLogEntry();
            entry.setLevel(((Integer)obj.get((Object)LEVEL)).intValue());
            entry.setMessage(MongoDBAuditLog.safeString(obj, MESSAGE));
            entry.setUser(MongoDBAuditLog.safeString(obj, USER));
            entry.setLogId(MongoDBAuditLog.safeString(obj, LOG_ID));
            entry.setWhen((Date)obj.get((Object)WHEN));
            entry.setSource(MongoDBAuditLog.safeString(obj, SOURCE));
            entry.setEntryId(MongoDBAuditLog.safeString(obj, ENTRY_ID));
            entry.setCategory(MongoDBAuditLog.safeString(obj, CATEGORY));
            ret.add(entry);
        }
    }

    public List<AuditLogEntry> getEntriesSince(AuditLogEntry when) {
        final Document sort = this.getSortObject();
        final Document query = new Document();
        Document test = new Document();
        test.put("$gt", (Object)when.getWhen());
        query.put(WHEN, (Object)test);
        MongoRetryWrapper<List<AuditLogEntry>> wrapper = new MongoRetryWrapper<List<AuditLogEntry>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                return MongoDBAuditLog.this.getAuditCollection().find((Bson)query).sort((Bson)sort);
            }

            @Override
            public List<AuditLogEntry> action(FindIterable<Document> cursor) {
                ArrayList<AuditLogEntry> ret = new ArrayList<AuditLogEntry>();
                MongoDBAuditLog.this.fillFromCursor(ret, (FindIterable<Document>)cursor);
                return ret;
            }
        };
        return (List)wrapper.doAction();
    }

    public void setConfig(String logId, Map<String, String> config) {
        this.tableName = config.get(TABLE_NAME);
        this.logId = logId;
        try {
            this.getAuditCollection().createIndex((Bson)new BsonDocument(WHEN, (BsonValue)new BsonInt32(1)));
        }
        catch (MongoException e) {
            log.info((Object)("setConfig failed on " + this.tableName + ": " + e.getMessage()));
            log.debug((Object)ExceptionToString.format((Throwable)e));
        }
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public Boolean writeLog(String category, int level, String message, String user) {
        log.debug((Object)("Mongo write audit log - " + message));
        Document obj = new Document();
        obj.append(LEVEL, (Object)level);
        obj.append(MESSAGE, (Object)message);
        obj.append(USER, (Object)user);
        obj.append(WHEN, (Object)new Date());
        obj.append(LOG_ID, (Object)this.logId);
        obj.append(SOURCE, (Object)"");
        obj.append(CATEGORY, (Object)category);
        obj.append(ENTRY_ID, (Object)IDGenerator.getUUID());
        try {
            this.getAuditCollection().insertOne((Object)obj);
        }
        catch (MongoException e) {
            System.err.println("Cannot log " + message + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    public Boolean writeLogData(String category, int level, String message, String user, Map<String, Object> data) {
        return this.writeLog(category, level, message + " " + AuditUtil.getStringRepresentation(data), user);
    }

    private Document getSortObject() {
        Document ret = new Document();
        ret.append(WHEN, (Object)1);
        return ret;
    }

    public void setContext(RaptureURI internalURI) {
    }

    public List<AuditLogEntry> getRecentUserActivity(String user, final int count) {
        final Document sort = this.getSortObject();
        final Document query = new Document();
        Document test = new Document();
        test.put("$eq", (Object)user);
        query.put(USER, (Object)test);
        MongoRetryWrapper<List<AuditLogEntry>> wrapper = new MongoRetryWrapper<List<AuditLogEntry>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                FindIterable ret = MongoDBAuditLog.this.getAuditCollection().find((Bson)query).sort((Bson)sort);
                if (count > 0) {
                    ret = ret.limit(count);
                }
                return ret;
            }

            @Override
            public List<AuditLogEntry> action(FindIterable<Document> cursor) {
                ArrayList<AuditLogEntry> ret = new ArrayList<AuditLogEntry>();
                MongoDBAuditLog.this.fillFromCursor(ret, (FindIterable<Document>)cursor);
                return ret;
            }
        };
        return (List)wrapper.doAction();
    }
}

