/*
 * Decompiled with CFR 0.152.
 */
package rapture.blob.mongodb;

import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import rapture.blob.mongodb.BlobHandler;
import rapture.common.CallingContext;
import rapture.common.exception.ExceptionToString;
import rapture.mongodb.MongoDBFactory;
import rapture.mongodb.MongoRetryWrapper;

public class DocHandler
implements BlobHandler {
    private static Logger log = Logger.getLogger(DocHandler.class);
    private static final String CONTENT = "content";
    private static final String BLOB_NAME = "blobName";
    private String instanceName;
    private String bucket;
    private volatile MongoCollection<Document> collection;
    private static final Object collectionLock = new Object();

    public DocHandler(String instanceName, String bucket) {
        this.instanceName = instanceName;
        this.bucket = bucket;
    }

    @Override
    public Boolean storeBlob(CallingContext context, String docPath, InputStream content, Boolean append) {
        log.debug((Object)("Saving " + docPath));
        try {
            byte[] toSave = IOUtils.toByteArray((InputStream)content);
            Document toStore = new Document();
            toStore.append(BLOB_NAME, (Object)docPath);
            toStore.append(CONTENT, (Object)toSave);
            try {
                this.getCollection().insertOne((Object)toStore);
                return true;
            }
            catch (MongoException e) {
                log.error((Object)("Could not store " + docPath + ": " + e.getMessage()));
                log.debug((Object)ExceptionToString.format((Throwable)e));
            }
        }
        catch (IOException e1) {
            log.error((Object)("Could not read content gto store: " + e1.getMessage()));
            log.debug((Object)ExceptionToString.format((Throwable)e1));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoCollection<Document> getCollection() {
        if (this.collection == null) {
            Object object = collectionLock;
            synchronized (object) {
                if (this.collection == null) {
                    this.collection = this.createCollection();
                }
            }
        }
        return this.collection;
    }

    private MongoCollection<Document> createCollection() {
        MongoDatabase db = MongoDBFactory.getDatabase(this.instanceName);
        MongoCollection tempCollection = db.getCollection(this.bucket);
        Document blobNameIndex = new Document(BLOB_NAME, (Object)1).append("unique", (Object)false).append("sparse", (Object)true);
        tempCollection.createIndex((Bson)blobNameIndex);
        return tempCollection;
    }

    @Override
    public Boolean deleteBlob(CallingContext context, String docPath) {
        log.debug((Object)("Removing " + docPath));
        Document query = new Document();
        query.append(BLOB_NAME, (Object)docPath);
        try {
            DeleteResult res = this.getCollection().deleteOne((Bson)query);
            return res.getDeletedCount() != 0L;
        }
        catch (MongoException e) {
            log.error((Object)("Could not delete " + docPath + ": " + e.getMessage()));
            log.debug((Object)ExceptionToString.format((Throwable)e));
            return false;
        }
    }

    @Override
    public InputStream getBlob(CallingContext context, String docPath) {
        final Document query = new Document(BLOB_NAME, (Object)docPath);
        final Document fields = new Document(CONTENT, (Object)"1");
        MongoRetryWrapper<ByteArrayInputStream> wrapper = new MongoRetryWrapper<ByteArrayInputStream>(){

            @Override
            public FindIterable<Document> makeCursor() {
                return DocHandler.this.getCollection().find((Bson)query).projection((Bson)fields);
            }

            @Override
            public ByteArrayInputStream action(FindIterable<Document> cursor) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                if (cursor != null) {
                    MongoCursor iterator = cursor.iterator();
                    if (!iterator.hasNext()) {
                        return null;
                    }
                    for (Document rec : cursor) {
                        Object content = rec.get((Object)DocHandler.CONTENT);
                        if (content instanceof Binary) {
                            try {
                                bao.write(((Binary)content).getData());
                            }
                            catch (IOException e) {
                                log.error((Object)e.getMessage());
                                log.debug((Object)ExceptionToString.format((Throwable)e));
                            }
                            continue;
                        }
                        log.error((Object)("Unexpected data type : expected org.bson.types.Binary but is " + content.getClass().getName()));
                    }
                }
                byte[] content = bao.toByteArray();
                return new ByteArrayInputStream(content);
            }
        };
        return (InputStream)wrapper.doAction();
    }
}

