/*
 * Decompiled with CFR 0.152.
 */
package rapture.blob.mongodb;

import com.mongodb.DB;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import rapture.blob.mongodb.BlobHandler;
import rapture.common.CallingContext;
import rapture.common.LockHandle;
import rapture.common.exception.ExceptionToString;
import rapture.kernel.Kernel;
import rapture.kernel.LockApiImpl;
import rapture.mongodb.MongoDBFactory;

public class GridFSBlobHandler
implements BlobHandler {
    private static final Logger log = Logger.getLogger(GridFSBlobHandler.class);
    private String instanceName;
    private String bucket;

    public GridFSBlobHandler(String instanceName, String bucket) {
        this.instanceName = instanceName;
        this.bucket = bucket;
    }

    public GridFS getGridFS() {
        DB db = MongoDBFactory.getDB(this.instanceName);
        return new GridFS(db, this.bucket);
    }

    @Override
    public Boolean storeBlob(CallingContext context, String docPath, InputStream newContent, Boolean append) {
        GridFSInputFile file;
        GridFS gridFS = this.getGridFS();
        if (!append.booleanValue()) {
            gridFS.remove(docPath);
            file = this.createNewFile(docPath, newContent);
        } else {
            GridFSDBFile existing = gridFS.findOne(docPath);
            if (existing != null) {
                try {
                    file = this.updateExisting(context, docPath, newContent, gridFS, existing);
                }
                catch (IOException e) {
                    file = null;
                    log.error((Object)String.format("Error while appending to docPath %s: %s", docPath, ExceptionToString.format((Throwable)e)));
                }
            } else {
                file = this.createNewFile(docPath, newContent);
            }
        }
        return file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridFSInputFile updateExisting(CallingContext context, String docPath, InputStream newContent, GridFS gridFS, GridFSDBFile existing) throws IOException {
        GridFSInputFile file;
        String lockKey = this.createLockKey(gridFS, docPath);
        LockHandle lockHandle = this.grabLock(context, lockKey);
        try {
            SequenceInputStream sequence;
            FileInputStream tempIn;
            block13: {
                File tempFile = File.createTempFile("rapture", "blob");
                existing.writeTo(tempFile);
                tempIn = FileUtils.openInputStream((File)tempFile);
                sequence = new SequenceInputStream(tempIn, newContent);
                try {
                    gridFS.remove(docPath);
                    file = this.createNewFile(docPath, sequence);
                    if (tempFile.delete()) break block13;
                    log.warn((Object)String.format("Unable to delete temp file created while appending docPath %s, at %s", docPath, tempFile.getAbsolutePath()));
                }
                catch (Throwable throwable) {
                    try {
                        sequence.close();
                    }
                    catch (IOException e) {
                        log.error((Object)String.format("Error closing sequence input stream: %s", ExceptionToString.format((Throwable)e)));
                    }
                    try {
                        tempIn.close();
                    }
                    catch (IOException e) {
                        log.error((Object)String.format("Error closing sequence input stream: %s", ExceptionToString.format((Throwable)e)));
                    }
                    throw throwable;
                }
            }
            try {
                sequence.close();
            }
            catch (IOException e) {
                log.error((Object)String.format("Error closing sequence input stream: %s", ExceptionToString.format((Throwable)e)));
            }
            try {
                tempIn.close();
            }
            catch (IOException e) {
                log.error((Object)String.format("Error closing sequence input stream: %s", ExceptionToString.format((Throwable)e)));
            }
        }
        finally {
            this.releaseLock(context, lockKey, lockHandle);
        }
        return file;
    }

    private void releaseLock(CallingContext context, String lockKey, LockHandle lockHandle) {
        Kernel.getLock().getTrusted().releaseLock(context, LockApiImpl.KERNEL_MANAGER_URI.toString(), lockKey, lockHandle);
    }

    private LockHandle grabLock(CallingContext context, String lockKey) {
        long secondsToWait = 5L;
        long secondsToKeep = 60L;
        return Kernel.getLock().getTrusted().acquireLock(context, LockApiImpl.KERNEL_MANAGER_URI.toString(), lockKey, secondsToWait, secondsToKeep);
    }

    private String createLockKey(GridFS gridFS, String docPath) {
        return gridFS.getDB().getName() + "." + gridFS.getBucketName() + "." + docPath;
    }

    protected GridFSInputFile createNewFile(String docPath, InputStream content) {
        GridFSInputFile file = this.getGridFS().createFile(content, docPath);
        if (file != null) {
            file.save();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean deleteBlob(CallingContext context, String docPath) {
        GridFS gridFS = this.getGridFS();
        String lockKey = this.createLockKey(gridFS, docPath);
        LockHandle lockHandle = this.grabLock(context, lockKey);
        boolean retVal = false;
        try {
            if (gridFS.findOne(docPath) != null) {
                gridFS.remove(docPath);
                retVal = true;
            }
        }
        finally {
            this.releaseLock(context, lockKey, lockHandle);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBlob(CallingContext context, String docPath) {
        GridFS gridFS = this.getGridFS();
        String lockKey = this.createLockKey(gridFS, docPath);
        LockHandle lockHandle = this.grabLock(context, lockKey);
        InputStream retVal = null;
        try {
            GridFSDBFile file = gridFS.findOne(docPath);
            if (file != null) {
                retVal = file.getInputStream();
            }
        }
        finally {
            this.releaseLock(context, lockKey, lockHandle);
        }
        return retVal;
    }
}

