/*
 * Decompiled with CFR 0.152.
 */
package rapture.blob.mongodb;

import com.mongodb.MongoException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import rapture.blob.BaseBlobStore;
import rapture.blob.mongodb.BlobHandler;
import rapture.blob.mongodb.DocHandler;
import rapture.blob.mongodb.GridFSBlobHandler;
import rapture.common.CallingContext;
import rapture.common.Formattable;
import rapture.common.Messages;
import rapture.common.RaptureURI;
import rapture.common.exception.RaptureExceptionFactory;

public class MongoDBBlobStore
extends BaseBlobStore {
    private static final String INSTANCE_NAME = "default";
    public static final String PRIMARY_CONFIG = "prefix";
    public static final String SECONDARY_CONFIG = "grid";
    public static final String MULTIPART = "multipart";
    private Messages mongoMsgCatalog = new Messages("Mongo");
    private BlobHandler blobHandler;

    public Boolean storeBlob(CallingContext context, RaptureURI blobUri, Boolean append, InputStream content) {
        try {
            return this.blobHandler.storeBlob(context, blobUri.getDocPath(), content, append);
        }
        catch (MongoException e) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("WriteError", (Object[])new String[]{blobUri.getDocPath(), e.getMessage()}));
        }
    }

    public Boolean deleteBlob(CallingContext context, RaptureURI blobUri) {
        try {
            return this.blobHandler.deleteBlob(context, blobUri.getDocPath());
        }
        catch (MongoException e) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("DeleteError", (Object[])new String[]{blobUri.getDocPath(), e.getMessage()}));
        }
    }

    public Boolean deleteFolder(CallingContext context, RaptureURI blobUri) {
        return false;
    }

    public InputStream getBlob(CallingContext context, RaptureURI blobUri) {
        try {
            return this.blobHandler.getBlob(context, blobUri.getDocPath());
        }
        catch (MongoException e) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("ReadError", (Object[])new String[]{blobUri.getDocPath(), e.getMessage()}));
        }
    }

    public void setConfig(Map<String, String> config) {
        String bucket = config.containsKey(PRIMARY_CONFIG) ? config.get(PRIMARY_CONFIG) : (config.containsKey(SECONDARY_CONFIG) ? config.get(SECONDARY_CONFIG) : null);
        if (StringUtils.isEmpty((String)bucket)) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("PrefixOrGrid"));
        }
        this.blobHandler = Boolean.valueOf(config.get(MULTIPART)) != false ? new DocHandler(INSTANCE_NAME, bucket) : new GridFSBlobHandler(INSTANCE_NAME, bucket);
    }

    public void init() {
    }

    public Boolean deleteRepo() {
        return true;
    }
}

