/*
 * Decompiled with CFR 0.152.
 */
package rapture.idgen.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.common.Formattable;
import rapture.common.Messages;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.dsl.idgen.IdGenStore;
import rapture.mongodb.MongoDBFactory;

public class IdGenMongoStore
implements IdGenStore {
    private static Logger log = Logger.getLogger(IdGenMongoStore.class);
    private static final String DOLLARINC = "$inc";
    private static final String SEQ = "seq";
    private static final String IDGEN = "idgen";
    private static final String IDGEN_NAME = "idgenName";
    private static final String TABLE_NAME = "prefix";
    private static final String VALID = "valid";
    private String tableName;
    private String idGenName = "idgen";
    private String instanceName = "default";
    private Messages mongoMsgCatalog = new Messages("Mongo");

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    private MongoCollection<Document> getIdGenCollection() {
        return MongoDBFactory.getCollection(this.instanceName, this.tableName);
    }

    private Document getIncUpdateObject(Document update) {
        Document realUpdate = new Document();
        realUpdate.put(DOLLARINC, (Object)update);
        return realUpdate;
    }

    public Long getNextIdGen(Long interval) {
        Document realUpdate = this.getIncUpdateObject(this.getUpdateObject(interval));
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
        Document ret = (Document)this.getIdGenCollection().findOneAndUpdate((Bson)this.getQueryObject(), (Bson)realUpdate, options);
        if (ret == null) {
            return null;
        }
        Boolean valid = (Boolean)ret.get((Object)VALID);
        if (valid != null && !valid.booleanValue()) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("IdGenerator"));
        }
        return (Long)ret.get((Object)SEQ);
    }

    private Document getQueryObject() {
        Document query = new Document();
        query.put(IDGEN, (Object)this.idGenName);
        return query;
    }

    private Document getUpdateObject(Long interval) {
        Document update = new Document();
        update.put(SEQ, (Object)interval);
        return update;
    }

    private Document getInvalidator() {
        Document invalidator = new Document();
        invalidator.append("$set", (Object)new Document().append(VALID, (Object)false));
        return invalidator;
    }

    private Document getRevalidator() {
        Document invalidator = new Document();
        invalidator.append("$set", (Object)new Document().append(VALID, (Object)true));
        return invalidator;
    }

    public void resetIdGen(Long number) {
        Long currentValue = this.getNextIdGen(0L);
        Long decrement = number - currentValue;
        this.getNextIdGen(decrement);
    }

    public void setConfig(Map<String, String> config) {
        log.info((Object)("Set config is " + config));
        this.tableName = config.get(TABLE_NAME);
        if (config.containsKey(IDGEN_NAME)) {
            this.idGenName = config.get(IDGEN_NAME);
        }
    }

    public void invalidate() {
        Document invalidator = this.getInvalidator();
        this.getIdGenCollection().findOneAndUpdate((Bson)this.getQueryObject(), (Bson)invalidator, new FindOneAndUpdateOptions().upsert(true));
    }

    public void makeValid() {
        Document invalidator = this.getRevalidator();
        this.getIdGenCollection().findOneAndUpdate((Bson)this.getQueryObject(), (Bson)invalidator, new FindOneAndUpdateOptions().upsert(true));
    }

    public void init() {
    }
}

