/*
 * Decompiled with CFR 0.152.
 */
package rapture.lock.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOptions;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.bson.BsonInt32;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.common.LockHandle;
import rapture.lock.ILockingHandler;
import rapture.mongodb.MongoDBFactory;

public class MongoLockHandler
implements ILockingHandler {
    private static final String RELEASETIME = "rt";
    private static final String DOLLARPUSH = "$push";
    private static final String DOLLARPULL = "$pull";
    private static final String NAME = "name";
    private static final String CTX = "ctx";
    private static final String LOCKS = "locks";
    private static final String RANDOM = "rnd";
    private static Logger log = Logger.getLogger(MongoLockHandler.class);
    private static final String tableName = "raplock";
    private String instanceName = "default";

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    private boolean waitAndShouldBail(long bailTime) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return System.currentTimeMillis() > bailTime;
    }

    public LockHandle acquireLock(String lockHolder, String lockName, long secondsToWait, long secondsToHold) {
        log.trace((Object)"Mongo acquire lock");
        String random = this.makeRandom();
        Document query = this.getLockQuery(lockName);
        Document val = this.createLockVal(lockHolder, secondsToHold, random);
        Document update = this.createAddValObject(val);
        MongoCollection<Document> coll = this.getLockCollection();
        long bailTime = System.currentTimeMillis() + secondsToWait * 1000L;
        boolean gotLock = false;
        coll.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        while (!gotLock) {
            Document obj = (Document)coll.find((Bson)query).first();
            if (obj != null) {
                log.trace((Object)"Locks are present");
                List locks = (List)obj.get((Object)LOCKS);
                if (locks.size() > 0) {
                    Document first = (Document)locks.get(0);
                    log.trace((Object)("First lock is " + first.get((Object)CTX)));
                    if (first.get((Object)CTX).toString().equals(lockHolder) && first.get((Object)RANDOM).toString().equals(random)) {
                        log.trace((Object)String.format("We have the lock  with name '%s'", lockName));
                        gotLock = true;
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("name: [%s]\nctx: [%s], rnd: [%s]\nctx: [%s], rnd: [%s]", lockName, first.get((Object)CTX).toString(), first.get((Object)RANDOM).toString(), lockHolder, random));
                    }
                    if (this.expired(first)) {
                        this.releaseLockWithRandom(first.get((Object)CTX).toString(), lockName, first.get((Object)RANDOM).toString());
                    }
                    if (!this.waitAndShouldBail(bailTime)) continue;
                    break;
                }
                log.trace((Object)"Locks return list was zero size");
                if (!this.waitAndShouldBail(bailTime)) continue;
                break;
            }
            log.trace((Object)"No update, bailing with no lock");
            break;
        }
        if (gotLock) {
            LockHandle lockHandle = new LockHandle();
            lockHandle.setLockName(lockName);
            lockHandle.setHandle(random);
            lockHandle.setLockHolder(lockHolder);
            return lockHandle;
        }
        log.info((Object)String.format("Could not get lock for %s, bailing", lockName));
        this.releaseLockWithRandom(lockHolder, lockName, random);
        return null;
    }

    private String makeRandom() {
        return UUID.randomUUID().toString();
    }

    private Document createAddValObject(Document val) {
        Document update = new Document();
        Document upVal = new Document();
        upVal.put(LOCKS, (Object)val);
        update.put(DOLLARPUSH, (Object)upVal);
        return update;
    }

    private Document createLockVal(String lockHolder, long secondsToHold, String random) {
        Document val = new Document();
        val.put(CTX, (Object)lockHolder);
        val.put(RANDOM, (Object)random);
        val.put(RELEASETIME, (Object)(System.currentTimeMillis() + secondsToHold * 1000L));
        return val;
    }

    private boolean expired(Document obj) {
        Object val = obj.get((Object)RELEASETIME);
        return val != null && val instanceof Long && (Long)val < System.currentTimeMillis();
    }

    protected MongoCollection<Document> getLockCollection() {
        return MongoDBFactory.getCollection(this.instanceName, tableName);
    }

    Document getLockQuery(String lockName) {
        Document query = new Document();
        query.put(NAME, (Object)lockName);
        return query;
    }

    String getCtxKey() {
        return CTX;
    }

    String getLocksKey() {
        return LOCKS;
    }

    public Boolean releaseLock(String lockHolder, String lockName, LockHandle lockHandle) {
        log.debug((Object)"Mongo release lock");
        if (lockHandle != null) {
            String random = lockHandle.getHandle();
            return this.releaseLockWithRandom(lockHolder, lockName, random);
        }
        log.error((Object)String.format("Unable to release lock %s, because null lockHandle passed in.", lockName));
        return false;
    }

    private Boolean releaseLockWithRandom(String lockHolder, String lockName, String random) {
        Document query = this.getLockQuery(lockName);
        Document toRemove = new Document();
        toRemove.put(CTX, (Object)lockHolder);
        toRemove.put(RANDOM, (Object)random);
        Document field = new Document();
        field.put(LOCKS, (Object)toRemove);
        Document oper = new Document();
        oper.put(DOLLARPULL, (Object)field);
        this.getLockCollection().updateOne((Bson)query, (Bson)oper, new UpdateOptions().upsert(false));
        return true;
    }

    private Boolean breakLock(String lockHolder, String lockName) {
        Document query = this.getLockQuery(lockName);
        Document test = new Document();
        test.put(CTX, (Object)lockHolder);
        Document field = new Document();
        field.put(LOCKS, (Object)test);
        Document oper = new Document();
        oper.put(DOLLARPULL, (Object)field);
        this.getLockCollection().updateOne((Bson)query, (Bson)oper, new UpdateOptions().upsert(false));
        return true;
    }

    public void setConfig(Map<String, String> config) {
        this.getLockCollection().createIndex((Bson)new Document(NAME, (Object)new BsonInt32(1)));
    }

    public Boolean forceReleaseLock(String lockName) {
        log.debug((Object)"Mongo break lock");
        Document query = this.getLockQuery(lockName);
        Document current = (Document)this.getLockCollection().find((Bson)query).first();
        if (current != null) {
            BasicDBList locks = (BasicDBList)current.get((Object)LOCKS);
            Document first = (Document)locks.get(0);
            String holder = first.get((Object)CTX).toString();
            this.breakLock(holder, lockName);
            return true;
        }
        return false;
    }
}

