/*
 * Decompiled with CFR 0.152.
 */
package rapture.lock.mongodb;

import com.mongodb.MongoServerException;
import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.common.LockHandle;
import rapture.common.exception.ExceptionToString;
import rapture.lock.ILockingHandler;
import rapture.mongodb.MongoDBFactory;

public class MongoLockHandler2
implements ILockingHandler {
    private static Logger log = Logger.getLogger(MongoLockHandler2.class);
    private static final String tableName = "raplock2_";
    private String instanceName = "default";

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public LockHandle acquireLock(String lockHolder, String lockName, long secondsToWait, long secondsToHold) {
        log.debug((Object)("Mongo acquire lock2  " + lockName + ":" + secondsToHold + ":" + secondsToWait));
        long start = System.currentTimeMillis();
        MongoCollection<Document> coll = this.getLockCollection(lockName);
        log.debug((Object)("lock COLLECTION for " + lockName + "IS " + coll.getNamespace().getFullName()));
        long bailTime = System.currentTimeMillis() + secondsToWait * 1000L;
        long leaseTime = System.currentTimeMillis() + secondsToHold * 1000L;
        Document lockFile = new Document();
        lockFile.put("lockName", (Object)lockName);
        lockFile.put("lockHolder", (Object)lockHolder);
        lockFile.put("lease", (Object)leaseTime);
        long myLockID = System.currentTimeMillis();
        lockFile.put("_id", (Object)("" + myLockID));
        log.debug((Object)("id is " + myLockID));
        log.debug((Object)("bailtime " + bailTime));
        while (bailTime > System.currentTimeMillis()) {
            try {
                myLockID = System.currentTimeMillis();
                lockFile.put("_id", (Object)("" + myLockID));
                lockFile.put("lease", (Object)(myLockID + secondsToHold * 1000L));
                coll.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertOne((Object)lockFile);
                log.debug((Object)("inserted file" + lockFile));
                break;
            }
            catch (MongoServerException e) {
                log.error((Object)ExceptionToString.format((Throwable)e));
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        while (bailTime > System.currentTimeMillis()) {
            FindIterable results = coll.find((Bson)new Document("lease", (Object)new Document("$gt", (Object)System.currentTimeMillis()))).sort((Bson)new Document("_id", (Object)1)).limit(1);
            Document lock = (Document)results.first();
            if (lock != null && ((String)lock.get((Object)"_id")).equals("" + myLockID)) {
                log.debug((Object)("* i have the lock" + lock.get((Object)"_id") + ":" + myLockID));
                LockHandle lockHandle = new LockHandle();
                lockHandle.setLockName(lockName);
                lockHandle.setHandle("" + myLockID);
                lockHandle.setLockHolder(lockHolder);
                long end = System.currentTimeMillis();
                log.debug((Object)("* NG acquired lock in " + (end - start)));
                return lockHandle;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.debug((Object)("giving up " + myLockID));
        long end2 = System.currentTimeMillis();
        log.debug((Object)("denied lock in " + (end2 - start)));
        return null;
    }

    public Boolean releaseLock(String lockHolder, String lockName, LockHandle lockHandle) {
        return this.releaseLock(lockHandle);
    }

    protected MongoCollection<Document> getLockCollection(String lockName) {
        return MongoDBFactory.getCollection(this.instanceName, tableName + lockName);
    }

    public Boolean releaseLock(LockHandle lockHandle) {
        log.debug((Object)"Mongo release lock");
        if (lockHandle != null) {
            String id = lockHandle.getHandle();
            String lockName = lockHandle.getLockName();
            return this.releaseLockWithID(lockName, id);
        }
        log.error((Object)"Unable to release lock %s, because null lockHandle passed in.");
        return false;
    }

    private Boolean releaseLockWithID(String lockName, String id) {
        Document lockFileQuery = new Document();
        lockFileQuery.put("_id", (Object)id);
        MongoCollection<Document> coll = this.getLockCollection(lockName);
        DeleteResult res = coll.deleteOne((Bson)lockFileQuery);
        return res.getDeletedCount() == 1L;
    }

    public Boolean forceReleaseLock(String lockName) {
        MongoCollection<Document> coll = this.getLockCollection(lockName);
        if (coll != null) {
            coll.drop();
        }
        return true;
    }

    public void setConfig(Map<String, String> config) {
    }

    public LockHandle getLockForName(String lockName) {
        FindIterable results = this.getLockCollection(lockName).find((Bson)new Document("lease", (Object)new Document("$gt", (Object)System.currentTimeMillis()))).sort((Bson)new Document("_id", (Object)1)).limit(1);
        Document lock = (Document)results.first();
        if (lock != null) {
            LockHandle lockHandle = new LockHandle();
            lockHandle.setLockName((String)lock.get((Object)"lockName"));
            lockHandle.setHandle((String)lock.get((Object)"_id"));
            lockHandle.setLockHolder((String)lock.get((Object)"lockHolder"));
            return lockHandle;
        }
        return null;
    }
}

