/*
 * Decompiled with CFR 0.152.
 */
package rapture.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.mongodb.MongoRetryWrapper;

public class EpochManager {
    private static final String _ID = "_id";
    private static final String SEQ = "seq";
    private static final String DOLLARINC = "$inc";
    private static final String EPOCH_DOCUMENT = "epochDocument";

    public static Long nextEpoch(final MongoCollection<Document> collection) {
        final FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
        MongoRetryWrapper<Long> wrapper = new MongoRetryWrapper<Long>(){

            @Override
            public Long action(FindIterable<Document> cursor) {
                Document ret = (Document)collection.findOneAndUpdate((Bson)EpochManager.getEpochQueryObject(), (Bson)EpochManager.getIncUpdateObject(EpochManager.getUpdateObject()), options);
                return (Long)ret.get((Object)EpochManager.SEQ);
            }
        };
        return (Long)wrapper.doAction();
    }

    public static Long getLatestEpoch(final MongoCollection<Document> collection) {
        MongoRetryWrapper<Long> wrapper = new MongoRetryWrapper<Long>(){

            @Override
            public FindIterable<Document> makeCursor() {
                return collection.find((Bson)EpochManager.getEpochQueryObject());
            }

            @Override
            public Long action(FindIterable<Document> cursor) {
                MongoCursor iterator = cursor.iterator();
                return iterator.hasNext() ? (Long)((Document)iterator.next()).get((Object)EpochManager.SEQ) : 0L;
            }
        };
        return (Long)wrapper.doAction();
    }

    public static Document getNotEqualEpochQueryObject() {
        return new Document(_ID, (Object)new Document("$ne", (Object)EPOCH_DOCUMENT));
    }

    private static Document getEpochQueryObject() {
        return new Document(_ID, (Object)EPOCH_DOCUMENT);
    }

    private static Document getIncUpdateObject(Document update) {
        return new Document(DOLLARINC, (Object)update);
    }

    private static Document getUpdateObject() {
        return new Document(SEQ, (Object)1L);
    }
}

