/*
 * Decompiled with CFR 0.152.
 */
package rapture.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bson.Document;
import rapture.common.ConnectionInfo;
import rapture.common.Formattable;
import rapture.common.Messages;
import rapture.common.connection.ConnectionType;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.config.MultiValueConfigLoader;
import rapture.kernel.ContextFactory;
import rapture.kernel.Kernel;

public enum MongoDBFactory {
    INSTANCE;

    private Messages mongoMsgCatalog = new Messages("Mongo");
    private static Logger log;
    private Map<String, Mongo> mongoInstances = new HashMap<String, Mongo>();
    private Map<String, DB> mongoDBs = new HashMap<String, DB>();
    private Map<String, MongoDatabase> mongoDatabases = new HashMap<String, MongoDatabase>();
    private static int retryCount;

    public static int getRetryCount() {
        return retryCount;
    }

    public static void setRetryCount(int retryCount) {
        MongoDBFactory.retryCount = retryCount;
    }

    private Mongo getMongoForInstance(String instanceName) {
        if (instanceName == null) {
            instanceName = "default";
        }
        if (this.mongoInstances.containsKey(instanceName)) {
            return this.mongoInstances.get(instanceName);
        }
        if (Kernel.getSys() == null) {
            return this.getMongoFromLocalConfig(instanceName);
        }
        return this.getMongoFromSysConfig(instanceName);
    }

    private Mongo getMongoFromLocalConfig(String instanceName) {
        String mongoHost = MultiValueConfigLoader.getConfig((String)("MONGODB-" + instanceName));
        log.info((Object)("Host is " + mongoHost));
        if (StringUtils.isBlank((String)mongoHost)) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("NoHost"));
        }
        MongoClientURI uri = new MongoClientURI(mongoHost);
        log.info((Object)("Username is " + uri.getUsername()));
        log.info((Object)("Host is " + uri.getHosts().toString()));
        log.info((Object)("DBName is " + uri.getDatabase()));
        log.info((Object)("Collection is " + uri.getCollection()));
        try {
            MongoClient mongo = new MongoClient(uri);
            this.mongoDBs.put(instanceName, mongo.getDB(uri.getDatabase()));
            this.mongoDatabases.put(instanceName, mongo.getDatabase(uri.getDatabase()));
            this.mongoInstances.put(instanceName, (Mongo)mongo);
            return mongo;
        }
        catch (MongoException e) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)new ExceptionToString((Throwable)e));
        }
    }

    private Mongo getMongoFromSysConfig(String instanceName) {
        Map map = Kernel.getSys().getConnectionInfo(ContextFactory.getKernelUser(), ConnectionType.MONGODB.toString());
        if (!map.containsKey(instanceName)) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.mongoMsgCatalog.getMessage("NoInstance", instanceName));
        }
        ConnectionInfo info = (ConnectionInfo)map.get(instanceName);
        log.info((Object)("Connection info = " + info));
        try {
            MongoClient mongo = new MongoClient(info.getHost(), info.getPort());
            this.mongoDBs.put(instanceName, mongo.getDB(info.getDbName()));
            this.mongoDatabases.put(instanceName, mongo.getDatabase(info.getDbName()));
            this.mongoInstances.put(instanceName, (Mongo)mongo);
            return mongo;
        }
        catch (MongoException e) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)new ExceptionToString((Throwable)e));
        }
    }

    public boolean canConnect() {
        return !this.mongoInstances.isEmpty();
    }

    @Deprecated
    public static DB getDB(String instanceName) {
        return INSTANCE._getDB(instanceName);
    }

    private DB _getDB(String instanceName) {
        if (this.mongoDBs.containsKey(instanceName)) {
            return this.mongoDBs.get(instanceName);
        }
        this.getMongoForInstance(instanceName);
        if (this.mongoDBs.containsKey(instanceName)) {
            return this.mongoDBs.get(instanceName);
        }
        throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("NotInitialized"));
    }

    public static MongoCollection<Document> getCollection(String instanceName, String name) {
        return INSTANCE._getMongoDatabase(instanceName).getCollection(name);
    }

    public static MongoDatabase getDatabase(String instanceName) {
        return INSTANCE._getMongoDatabase(instanceName);
    }

    private MongoDatabase _getMongoDatabase(String instanceName) {
        if (this.mongoDatabases.containsKey(instanceName)) {
            return this.mongoDatabases.get(instanceName);
        }
        this.getMongoForInstance(instanceName);
        if (this.mongoDatabases.containsKey(instanceName)) {
            return this.mongoDatabases.get(instanceName);
        }
        throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("NotInitialized"));
    }

    static {
        log = Logger.getLogger(MongoDBFactory.class);
        retryCount = 3;
    }
}

