/*
 * Decompiled with CFR 0.152.
 */
package rapture.mongodb;

import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import org.apache.log4j.Logger;
import org.bson.Document;
import rapture.common.exception.ExceptionToString;
import rapture.mongodb.MongoDBFactory;

public abstract class MongoRetryWrapper<T> {
    private static Logger log = Logger.getLogger(MongoRetryWrapper.class);
    private int retryCount = MongoDBFactory.getRetryCount();

    public abstract T action(FindIterable<Document> var1);

    public FindIterable<Document> makeCursor() {
        return null;
    }

    public T doAction() {
        T object = null;
        FindIterable<Document> cursor = null;
        while (this.retryCount-- > 0) {
            try {
                cursor = this.makeCursor();
                object = this.action(cursor);
                this.retryCount = 0;
            }
            catch (MongoException e) {
                log.info((Object)("Exception talking to Mongo: \n" + ExceptionToString.format((Throwable)e)));
                log.info((Object)("Remaining tries: " + this.retryCount));
            }
        }
        return object;
    }
}

