/*
 * Decompiled with CFR 0.152.
 */
package rapture.notification.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Projections;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.common.CallingContext;
import rapture.common.NotificationInfo;
import rapture.common.NotificationResult;
import rapture.mongodb.EpochManager;
import rapture.mongodb.MongoDBFactory;
import rapture.mongodb.MongoRetryWrapper;
import rapture.notification.INotificationHandler;
import rapture.util.IDGenerator;

public class MongoNotificationHandler
implements INotificationHandler {
    private static Logger log = Logger.getLogger(MongoNotificationHandler.class);
    private static final Object PREFIX_NAME = "prefix";
    private String tableName;
    private String instanceName = "default";
    private static final String RECORDTYPE = "recordType";
    private static final String NOTIFICATION = "notification";

    public void setConfig(Map<String, String> config) {
        this.tableName = config.get(PREFIX_NAME);
    }

    public Long getLatestNotificationEpoch() {
        return EpochManager.getLatestEpoch(this.getNotificationCollection());
    }

    public String publishNotification(CallingContext context, String referenceId, String content, String contentType) {
        log.debug((Object)"Mongo push notification - content");
        Document recordObject = new Document();
        recordObject.put(RECORDTYPE, (Object)NOTIFICATION);
        recordObject.put("epoch", (Object)EpochManager.nextEpoch(this.getNotificationCollection()));
        String id = IDGenerator.getUUID();
        recordObject.put("id", (Object)id);
        recordObject.put("reference", (Object)referenceId);
        recordObject.put("content", (Object)content);
        recordObject.put("when", (Object)new Date());
        recordObject.put("contentType", (Object)contentType);
        recordObject.put("who", (Object)context.getUser());
        recordObject.put("kernelId", (Object)context.getContext());
        this.getNotificationCollection().insertOne((Object)recordObject);
        return id;
    }

    public NotificationResult findNotificationsAfterEpoch(final CallingContext context, Long lastEpochSeen) {
        final Document queryObject = new Document();
        queryObject.put(RECORDTYPE, (Object)NOTIFICATION);
        Document greaterEpochObject = new Document();
        greaterEpochObject.put("$gt", (Object)lastEpochSeen);
        queryObject.put("epoch", (Object)greaterEpochObject);
        MongoRetryWrapper<NotificationResult> wrapper = new MongoRetryWrapper<NotificationResult>(){

            @Override
            public FindIterable<Document> makeCursor() {
                return MongoNotificationHandler.this.getNotificationCollection().find((Bson)queryObject).projection(Projections.include((String[])new String[]{"id", "kernelId"}));
            }

            @Override
            public NotificationResult action(FindIterable<Document> cursor) {
                NotificationResult res = new NotificationResult(MongoNotificationHandler.this.getLatestNotificationEpoch());
                for (Document dobj : cursor) {
                    String kernelId = (String)dobj.get((Object)"kernelId");
                    if (kernelId != null && kernelId.equals(context.getContext())) continue;
                    res.addId((String)dobj.get((Object)"id"));
                }
                return res;
            }
        };
        return (NotificationResult)wrapper.doAction();
    }

    public NotificationInfo getNotification(String id) {
        Document queryObject = new Document();
        queryObject.put(RECORDTYPE, (Object)NOTIFICATION);
        queryObject.put("id", (Object)id);
        Document one = (Document)this.getNotificationCollection().find((Bson)queryObject).first();
        if (one != null) {
            NotificationInfo info = new NotificationInfo();
            info.setContent((String)one.get((Object)"content"));
            info.setEpoch((Long)one.get((Object)"epoch"));
            info.setId(id);
            info.setReference((String)one.get((Object)"reference"));
            info.setWhen((Date)one.get((Object)"when"));
            info.setContentType((String)one.get((Object)"contentType"));
            if (one.get((Object)"who") != null) {
                info.setWho((String)one.get((Object)"who"));
            }
            info.setKernelId((String)one.get((Object)"kernelId"));
            return info;
        }
        return null;
    }

    private MongoCollection<Document> getNotificationCollection() {
        return MongoDBFactory.getCollection(this.instanceName, this.tableName);
    }
}

