/*
 * Decompiled with CFR 0.152.
 */
package rapture.repo.mongodb;

import java.util.List;
import java.util.Map;
import rapture.common.SeriesValue;
import rapture.series.children.ChildrenRepo;
import rapture.series.mongo.MongoSeriesStore;

public class MongoChildrenRepo
extends ChildrenRepo {
    private final MongoSeriesStore seriesStore;

    public MongoChildrenRepo(MongoSeriesStore seriesStore) {
        this.seriesStore = seriesStore;
    }

    public void setInstanceName(String instanceName) {
        this.seriesStore.setInstanceName(instanceName);
    }

    public void setConfig(Map<String, String> dirConfig) {
        this.seriesStore.setConfig(dirConfig);
    }

    public List<SeriesValue> getPoints(String key) {
        return this.seriesStore.getPoints(key);
    }

    public boolean addPoint(String key, SeriesValue value) {
        this.seriesStore.addPointToSeries(key, value);
        return true;
    }

    public boolean dropPoints(String key, List<String> points) {
        return this.seriesStore.deletePointsFromSeriesByPointKey(key, points);
    }

    public boolean dropRow(String key) {
        return this.seriesStore.deletePointsFromSeries(key);
    }

    public void drop() {
        super.drop();
        this.seriesStore.drop();
    }
}

