/*
 * Decompiled with CFR 0.152.
 */
package rapture.repo.mongodb;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bson.BsonInt32;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.common.Formattable;
import rapture.common.Messages;
import rapture.common.RaptureFolderInfo;
import rapture.common.RaptureNativeQueryResult;
import rapture.common.RaptureNativeRow;
import rapture.common.RaptureQueryResult;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptNotSupportedException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.common.impl.jackson.JsonContent;
import rapture.index.IndexHandler;
import rapture.index.IndexProducer;
import rapture.kernel.Kernel;
import rapture.mongodb.MongoDBFactory;
import rapture.mongodb.MongoRetryWrapper;
import rapture.notification.NotificationMessage;
import rapture.notification.RaptureMessageListener;
import rapture.repo.AbstractKeyStore;
import rapture.repo.KeyStore;
import rapture.repo.RepoLockHandler;
import rapture.repo.RepoVisitor;
import rapture.repo.StoreKeyVisitor;
import rapture.repo.mongodb.MongoChildrenRepo;
import rapture.series.mongo.MongoSeriesStore;
import rapture.table.mongodb.MongoIndexHandler;

public class MongoDbDataStore
extends AbstractKeyStore
implements KeyStore,
RaptureMessageListener<NotificationMessage> {
    private static final Logger log = Logger.getLogger(MongoDbDataStore.class);
    private static final String MONGODB = "MONGODB";
    private static final String $IN = "$in";
    private static final String $SET = "$set";
    private static final String SORT = "sort";
    private static final String LIMIT = "limit";
    private static final String SKIP = "skip";
    public static final String PREFIX = "prefix";
    private static final String VALUE = "value";
    private static final String KEY = "key";
    private static final String VERSION = "version";
    private static final String SEPARATE_VERSION = "separateVersion";
    private String tableName;
    private String instanceName = "default";
    private boolean separateVersion = false;
    private boolean needsFolderHandling = true;
    private Messages mongoMsgCatalog;
    private final MongoChildrenRepo dirRepo = new MongoChildrenRepo(new MongoSeriesStore());

    public MongoDbDataStore() {
        this.mongoMsgCatalog = new Messages("Mongo");
        Kernel.getKernel().registerTypeListener(((Object)((Object)this)).getClass().getName(), (RaptureMessageListener)this);
        log.trace((Object)"Registered as a listener with TypeChangeManager ");
    }

    private void resetNeedsFolderHandling() {
        this.needsFolderHandling = false;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public boolean containsKey(String ref) {
        MongoCollection<Document> collection = MongoDBFactory.getCollection(this.instanceName, this.tableName);
        return collection.count((Bson)new Document(KEY, (Object)ref)) > 0L;
    }

    public long countKeys() throws RaptNotSupportedException {
        return MongoDBFactory.getCollection(this.instanceName, this.tableName).count();
    }

    public KeyStore createRelatedKeyStore(String relation) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(PREFIX, this.tableName + "_" + relation);
        MongoDbDataStore related = new MongoDbDataStore();
        related.resetNeedsFolderHandling();
        related.setInstanceName(VERSION.equalsIgnoreCase(relation) && this.separateVersion ? VERSION : this.instanceName);
        related.setConfig(config);
        return related;
    }

    public boolean delete(String key) {
        Document query;
        boolean deleted;
        MongoCollection<Document> collection = this.getCollection();
        boolean bl = deleted = null != collection.findOneAndDelete((Bson)(query = new Document(KEY, (Object)key)));
        if (deleted && this.needsFolderHandling) {
            this.dirRepo.dropFileEntry(key);
        }
        return deleted;
    }

    public void setRepoLockHandler(RepoLockHandler repoLockHandler) {
        this.dirRepo.setRepoLockHandler(repoLockHandler);
    }

    public boolean delete(List<String> keys) {
        Document inClause = new Document($IN, keys);
        Document query = new Document(KEY, (Object)inClause);
        try {
            Document result = (Document)this.getCollection().findOneAndDelete((Bson)query);
            if (result != null && this.needsFolderHandling) {
                for (String key : keys) {
                    this.dirRepo.dropFileEntry(key);
                }
            }
            return result != null;
        }
        catch (MongoException me) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)new ExceptionToString((Throwable)me));
        }
    }

    public boolean dropKeyStore() {
        MongoDBFactory.getCollection(this.instanceName, this.tableName).drop();
        this.dirRepo.drop();
        return true;
    }

    public String get(String k) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get " + k));
        }
        MongoCollection<Document> collection = MongoDBFactory.getCollection(this.instanceName, this.tableName);
        Document query = new Document();
        query.put(KEY, (Object)k);
        FindIterable obj = collection.find((Bson)query).limit(1);
        if (obj != null) {
            for (Document doc : obj) {
                Object v = doc.get((Object)VALUE);
                if (v == null) continue;
                return v.toString();
            }
        }
        return null;
    }

    public boolean matches(String key, String value) {
        String val = this.get(key);
        if (val != null) {
            String tester = StringUtils.deleteWhitespace((String)JacksonUtil.jsonFromObject((Object)JacksonUtil.getMapFromJson((String)val)));
            return tester.equals(StringUtils.deleteWhitespace((String)value));
        }
        return false;
    }

    public List<String> getBatch(final List<String> keys) {
        MongoRetryWrapper<List<String>> wrapper = new MongoRetryWrapper<List<String>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                MongoCollection<Document> collection = MongoDBFactory.getCollection(MongoDbDataStore.this.instanceName, MongoDbDataStore.this.tableName);
                Document inClause = new Document(MongoDbDataStore.$IN, (Object)keys);
                Document query = new Document(MongoDbDataStore.KEY, (Object)inClause);
                return collection.find((Bson)query);
            }

            @Override
            public List<String> action(FindIterable<Document> cursor) {
                ArrayList<String> ret = new ArrayList<String>();
                HashMap<String, String> retMap = new HashMap<String, String>();
                for (Document obj : cursor) {
                    if (obj == null) continue;
                    String v = obj.get((Object)MongoDbDataStore.VALUE).toString();
                    String k = obj.get((Object)MongoDbDataStore.KEY).toString();
                    retMap.put(k, v);
                }
                for (String key : keys) {
                    if (retMap.containsKey(key)) {
                        ret.add((String)retMap.get(key));
                        continue;
                    }
                    ret.add(null);
                }
                return ret;
            }
        };
        return (List)wrapper.doAction();
    }

    private Document getQueryObjFromQueryParams(List<String> queryParams) {
        return (Document)JSON.parse((String)queryParams.get(0));
    }

    public String getStoreId() {
        return this.tableName;
    }

    public void put(String key, String value) {
        MongoCollection<Document> collection = this.getCollection();
        Document query = new Document(KEY, (Object)key);
        Document toPut = new Document($SET, (Object)new Document(KEY, (Object)key).append(VALUE, (Object)value));
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.BEFORE);
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)toPut, options);
        if (this.needsFolderHandling && result == null) {
            this.dirRepo.registerParentage(key);
        }
    }

    public RaptureQueryResult runNativeQuery(String repoType, final List<String> queryParams) {
        if (repoType.toUpperCase().equals(MONGODB)) {
            MongoRetryWrapper<RaptureQueryResult> wrapper = new MongoRetryWrapper<RaptureQueryResult>(){

                @Override
                public FindIterable<Document> makeCursor() {
                    Document queryObj = MongoDbDataStore.this.getQueryObjFromQueryParams(queryParams);
                    MongoCollection<Document> collection = MongoDBFactory.getCollection(MongoDbDataStore.this.instanceName, MongoDbDataStore.this.tableName);
                    FindIterable find = collection.find((Bson)queryObj).batchSize(100);
                    if (queryParams.size() > 2) {
                        Map options = JacksonUtil.getMapFromJson((String)((String)queryParams.get(2)));
                        if (options.containsKey(MongoDbDataStore.SKIP)) {
                            find.skip(((Integer)options.get(MongoDbDataStore.SKIP)).intValue());
                        }
                        if (options.containsKey(MongoDbDataStore.LIMIT)) {
                            find.limit(((Integer)options.get(MongoDbDataStore.LIMIT)).intValue());
                        }
                        if (options.containsKey(MongoDbDataStore.SORT)) {
                            Map sortInfo = JacksonUtil.getMapFromJson((String)options.get(MongoDbDataStore.SORT).toString());
                            Document sortInfoObject = new Document();
                            sortInfoObject.putAll(sortInfo);
                            find.sort((Bson)sortInfoObject);
                        }
                    }
                    return find;
                }

                @Override
                public RaptureQueryResult action(FindIterable<Document> iterable) {
                    RaptureQueryResult res = new RaptureQueryResult();
                    for (Document d : iterable) {
                        res.addRowContent(new JsonContent(d.toString()));
                    }
                    return res;
                }
            };
            return (RaptureQueryResult)wrapper.doAction();
        }
        throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("Mismatch", repoType));
    }

    public RaptureNativeQueryResult runNativeQueryWithLimitAndBounds(String repoType, final List<String> queryParams, final int limit, final int offset) {
        if (repoType.toUpperCase().equals(MONGODB)) {
            MongoRetryWrapper<RaptureNativeQueryResult> wrapper = new MongoRetryWrapper<RaptureNativeQueryResult>(){

                @Override
                public FindIterable<Document> makeCursor() {
                    Document queryObj = MongoDbDataStore.this.getQueryObjFromQueryParams(queryParams);
                    MongoCollection<Document> collection = MongoDBFactory.getCollection(MongoDbDataStore.this.instanceName, MongoDbDataStore.this.tableName);
                    FindIterable cursor = collection.find((Bson)queryObj);
                    cursor = cursor.skip(offset).limit(limit);
                    return cursor;
                }

                @Override
                public RaptureNativeQueryResult action(FindIterable<Document> iterable) {
                    RaptureNativeQueryResult res = new RaptureNativeQueryResult();
                    for (Document d : iterable) {
                        RaptureNativeRow row = new RaptureNativeRow();
                        row.setName(d.get((Object)MongoDbDataStore.KEY).toString());
                        row.setContent(new JsonContent(d.get((Object)MongoDbDataStore.VALUE).toString()));
                        res.addRowContent(row);
                    }
                    return res;
                }
            };
            return (RaptureNativeQueryResult)wrapper.doAction();
        }
        throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.mongoMsgCatalog.getMessage("Mismatch", repoType));
    }

    public void setConfig(Map<String, String> config) {
        String dirName;
        this.tableName = config.get(PREFIX);
        if (config.containsKey(SEPARATE_VERSION)) {
            this.separateVersion = Boolean.valueOf(config.get(SEPARATE_VERSION));
        }
        if (this.tableName == null || this.tableName.isEmpty()) {
            this.tableName = "__data__" + this.instanceName;
            dirName = "__dir__" + this.instanceName;
        } else {
            dirName = "__dir__" + this.tableName;
        }
        MongoCollection<Document> collection = this.getCollection();
        collection.createIndex((Bson)new Document(KEY, (Object)new BsonInt32(1)));
        this.dirRepo.setInstanceName(this.instanceName);
        ImmutableMap dirConfig = ImmutableMap.of((Object)PREFIX, (Object)dirName);
        this.dirRepo.setConfig((Map<String, String>)dirConfig);
        this.dirRepo.setRepoDescription(String.format("Mongo - %s", this.tableName));
    }

    private MongoCollection<Document> getCollection() {
        return MongoDBFactory.getCollection(this.instanceName, this.tableName);
    }

    public void visit(final String folderPrefix, final RepoVisitor iRepoVisitor) {
        MongoRetryWrapper<Object> wrapper = new MongoRetryWrapper<Object>(){

            @Override
            public FindIterable<Document> makeCursor() {
                MongoCollection collection = MongoDbDataStore.this.getCollection();
                Document query = new Document(MongoDbDataStore.KEY, (Object)Pattern.compile(folderPrefix));
                return collection.find((Bson)query);
            }

            @Override
            public Object action(FindIterable<Document> iterable) {
                Document d;
                MongoCursor cursor = iterable.iterator();
                while (cursor.hasNext() && ((d = (Document)cursor.next()).getString((Object)MongoDbDataStore.KEY).startsWith("$") || iRepoVisitor.visit(d.getString((Object)MongoDbDataStore.KEY), new JsonContent(d.getString((Object)MongoDbDataStore.VALUE)), false))) {
                }
                return null;
            }
        };
        wrapper.doAction();
    }

    public void visitKeys(final String prefix, final StoreKeyVisitor iStoreKeyVisitor) {
        MongoRetryWrapper<Object> wrapper = new MongoRetryWrapper<Object>(){

            @Override
            public FindIterable<Document> makeCursor() {
                MongoCollection collection = MongoDbDataStore.this.getCollection();
                String regex = "^\\Q" + prefix + "\\E";
                Document query = new Document(MongoDbDataStore.KEY, (Object)Pattern.compile(regex));
                return collection.find((Bson)query);
            }

            @Override
            public Object action(FindIterable<Document> iterable) {
                Document d;
                MongoCursor cursor = iterable.iterator();
                while (cursor.hasNext() && iStoreKeyVisitor.visit((d = (Document)cursor.next()).getString((Object)MongoDbDataStore.KEY), d.getString((Object)MongoDbDataStore.VALUE))) {
                }
                return null;
            }
        };
        wrapper.doAction();
    }

    public void visitKeysFromStart(final String startPoint, final StoreKeyVisitor iStoreKeyVisitor) {
        MongoRetryWrapper<Object> wrapper = new MongoRetryWrapper<Object>(){

            @Override
            public FindIterable<Document> makeCursor() {
                MongoCollection collection = MongoDbDataStore.this.getCollection();
                String regex = ".*";
                Document query = new Document(MongoDbDataStore.KEY, (Object)Pattern.compile(regex));
                return collection.find((Bson)query);
            }

            @Override
            public Object action(FindIterable<Document> iterable) {
                boolean canStart;
                MongoCursor cursor = iterable.iterator();
                boolean bl = canStart = startPoint == null;
                while (cursor.hasNext()) {
                    Document d = (Document)cursor.next();
                    if (canStart) {
                        if (iStoreKeyVisitor.visit(d.getString((Object)MongoDbDataStore.KEY), d.getString((Object)MongoDbDataStore.VALUE))) continue;
                        break;
                    }
                    if (!d.getString((Object)MongoDbDataStore.KEY).equals(startPoint)) continue;
                    canStart = true;
                }
                return null;
            }
        };
        wrapper.doAction();
    }

    public List<RaptureFolderInfo> getSubKeys(String prefix) {
        if (this.needsFolderHandling) {
            return this.dirRepo.getChildren(prefix);
        }
        return null;
    }

    private void removeEntries(List<RaptureFolderInfo> ret, String prefix) {
        List<RaptureFolderInfo> entries = this.getSubKeys(prefix);
        for (RaptureFolderInfo i : entries) {
            String nextLevel = prefix + "/" + i.getName();
            if (i.isFolder()) {
                this.removeEntries(ret, nextLevel);
                continue;
            }
            this.delete(nextLevel);
            RaptureFolderInfo nextRfi = new RaptureFolderInfo();
            nextRfi.setName(nextLevel);
            nextRfi.setFolder(false);
            ret.add(nextRfi);
        }
        RaptureFolderInfo topRfi = new RaptureFolderInfo();
        topRfi.setFolder(true);
        topRfi.setName(prefix);
        ret.add(topRfi);
        this.dirRepo.dropFolderEntry(prefix);
    }

    public List<RaptureFolderInfo> removeSubKeys(String folder, Boolean force) {
        ArrayList<RaptureFolderInfo> ret = new ArrayList<RaptureFolderInfo>();
        this.removeEntries(ret, folder);
        return ret;
    }

    public void resetFolderHandling() {
        this.resetNeedsFolderHandling();
    }

    public List<String> getAllSubKeys(String displayNamePart) {
        if (this.needsFolderHandling) {
            List<RaptureFolderInfo> base = this.getSubKeys(displayNamePart);
            ArrayList result = Lists.newArrayList();
            this.expandTree(base, result, null);
            return result;
        }
        return null;
    }

    public IndexHandler createIndexHandler(IndexProducer indexProducer) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(PREFIX, this.tableName + "_index_index");
        MongoIndexHandler mongoIndexHandler = new MongoIndexHandler();
        mongoIndexHandler.setInstanceName(this.instanceName);
        mongoIndexHandler.setIndexProducer(indexProducer);
        mongoIndexHandler.setConfig(config);
        mongoIndexHandler.initialize();
        return mongoIndexHandler;
    }

    private void expandTree(List<RaptureFolderInfo> base, List<String> result, String prefix) {
        for (RaptureFolderInfo info : base) {
            String name = prefix == null ? info.getName() : prefix + "/" + info.getName();
            result.add(name);
            this.expandTree(this.getSubKeys(name), result, name);
        }
    }

    public Boolean validate() {
        return this.getCollection() != null;
    }

    public long getSize() {
        return this.getCollection().count();
    }

    public void signalMessage(NotificationMessage message) {
    }
}

