/*
 * Decompiled with CFR 0.152.
 */
package rapture.series.mongo;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mongodb.MongoException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.DeleteResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.common.Formattable;
import rapture.common.Messages;
import rapture.common.RaptureFolderInfo;
import rapture.common.SeriesValue;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.dsl.serfun.DecimalSeriesValue;
import rapture.dsl.serfun.LongSeriesValue;
import rapture.dsl.serfun.StringSeriesValue;
import rapture.dsl.serfun.StructureSeriesValueImpl;
import rapture.mongodb.MongoDBFactory;
import rapture.mongodb.MongoRetryWrapper;
import rapture.series.SeriesPaginator;
import rapture.series.SeriesStore;
import rapture.series.children.ChildKeyUtil;
import rapture.series.children.ChildrenRepo;

public class MongoSeriesStore
implements SeriesStore {
    private String instanceName = "default";
    private String tableName;
    private static final String $SET = "$set";
    public static final String ROWKEY = "row";
    public static final String COLKEY = "col";
    public static final String VALKEY = "val";
    private Cache<String, Boolean> keyCache = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.SECONDS).build();
    private final ChildrenRepo childrenRepo;
    private static Logger log = Logger.getLogger(MongoSeriesStore.class);
    private Messages mongoMsgCatalog;
    private static final String DIRECTORY_KEY = "..directory";
    private Callable<Boolean> FALSE_CALL = new Callable<Boolean>(){

        @Override
        public Boolean call() {
            return false;
        }
    };
    private Callback<Double> multiDouble = new Callback<Double>(){

        @Override
        public void go(String key, String column, Double value) {
            MongoSeriesStore.this.addDoubleToSeries(key, column, value);
        }
    };
    private Callback<Long> multiLong = new Callback<Long>(){

        @Override
        public void go(String key, String column, Long value) {
            MongoSeriesStore.this.addLongToSeries(key, column, value);
        }
    };
    private Callback<String> multiString = new Callback<String>(){

        @Override
        public void go(String key, String column, String value) {
            MongoSeriesStore.this.addStringToSeries(key, column, value);
        }
    };
    private Callback<String> multiStruct = new Callback<String>(){

        @Override
        public void go(String key, String column, String value) {
            MongoSeriesStore.this.addStructureToSeries(key, column, value);
        }
    };
    private Callback<SeriesValue> multiPoint = new Callback<SeriesValue>(){

        @Override
        public void go(String key, String column, SeriesValue value) {
            if (value.isDouble()) {
                MongoSeriesStore.this.addDoubleToSeries(key, value.getColumn(), value.asDouble());
            } else if (value.isLong()) {
                MongoSeriesStore.this.addLongToSeries(key, value.getColumn(), value.asLong());
            } else if (value.isString()) {
                MongoSeriesStore.this.addStringToSeries(key, value.getColumn(), value.asString());
            } else if (value.isStructure()) {
                MongoSeriesStore.this.addStructureToSeries(key, value.getColumn(), value.asString());
            }
        }
    };
    private static final Document INDEX_KEYS = new Document("row", (Object)1).append("col", (Object)1);
    private static final IndexOptions INDEX_OPTS = new IndexOptions().unique(true);

    public MongoSeriesStore() {
        this.mongoMsgCatalog = new Messages("Mongo");
        this.childrenRepo = new ChildrenRepo(){

            public List<SeriesValue> getPoints(String key) {
                return MongoSeriesStore.this.getPoints(key);
            }

            public boolean addPoint(String key, SeriesValue value) {
                MongoSeriesStore.this.addPointToSeries(key, value);
                return true;
            }

            public boolean dropPoints(String key, List<String> points) {
                return MongoSeriesStore.this.deletePointsFromSeriesByPointKey(key, points);
            }

            public boolean dropRow(String key) {
                return MongoSeriesStore.this.deletePointsFromSeries(key);
            }
        };
    }

    public void drop() {
        MongoCollection<Document> collection = this.getCollection(null);
        collection.drop();
        this.keyCache.invalidateAll();
    }

    public void addDoubleToSeries(String key, String column, double value) {
        this.saveDocument(key, column, value);
    }

    public void addLongToSeries(String key, String column, long value) {
        this.saveDocument(key, column, value);
    }

    public void addStringToSeries(String key, String column, String value) {
        this.saveDocument(key, column, "'" + value);
    }

    public void addStructureToSeries(String key, String column, String json) {
        this.saveDocument(key, column, json);
    }

    public void addPointToSeries(String key, SeriesValue value) {
        if (value.isDouble()) {
            this.addDoubleToSeries(key, value.getColumn(), value.asDouble());
        } else if (value.isLong()) {
            this.addLongToSeries(key, value.getColumn(), value.asLong());
        } else if (value.isString()) {
            this.addStringToSeries(key, value.getColumn(), value.asString());
        } else if (value.isStructure()) {
            this.addStructureToSeries(key, value.getColumn(), value.asString());
        } else {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.mongoMsgCatalog.getMessage("NoEncoder", value.asString()));
        }
    }

    private void saveDocument(String key, String column, Object val) {
        this.registerKey(key);
        MongoCollection<Document> collection = this.getCollection(key);
        Document dbkey = new Document(ROWKEY, (Object)key).append(COLKEY, (Object)column);
        Document dbval = new Document($SET, (Object)new Document(ROWKEY, (Object)key).append(COLKEY, (Object)column).append(VALKEY, val));
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
        try {
            Document document = (Document)collection.findOneAndUpdate((Bson)dbkey, (Bson)dbval, options);
        }
        catch (MongoException me) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)new ExceptionToString((Throwable)me));
        }
    }

    private void registerKey(String key) {
        if (DIRECTORY_KEY.equals(key) || ChildKeyUtil.isRowKey((String)key)) {
            return;
        }
        try {
            if (!((Boolean)this.keyCache.get((Object)key, this.FALSE_CALL)).booleanValue()) {
                this.addPointToSeries(DIRECTORY_KEY, (SeriesValue)new StringSeriesValue(".", key));
                this.childrenRepo.registerParentage(key);
                this.keyCache.put((Object)key, (Object)true);
            }
        }
        catch (ExecutionException e) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)new ExceptionToString((Throwable)e));
        }
    }

    public boolean unregisterKey(String key) {
        return this.unregisterKey(key, false);
    }

    public boolean unregisterKey(String key, boolean isFolder) {
        if (DIRECTORY_KEY.equals(key)) {
            return false;
        }
        boolean ret = this.deletePointsFromSeriesByPointKey(DIRECTORY_KEY, (List<String>)ImmutableList.of((Object)key));
        if (ret) {
            if (isFolder) {
                this.childrenRepo.dropFolderEntry(key);
            } else {
                this.childrenRepo.dropFileEntry(key);
            }
        }
        this.keyCache.invalidate((Object)key);
        return ret;
    }

    private <T> void multiAdd(String key, List<String> columns, List<T> values, Callback<T> c) {
        boolean nullKey = false;
        Preconditions.checkArgument((columns.size() == values.size() ? 1 : 0) != 0);
        Iterator<String> col = columns.iterator();
        Iterator<T> val = values.iterator();
        while (col.hasNext()) {
            String column = col.next();
            T value = val.next();
            if (column == null) {
                nullKey = true;
                continue;
            }
            c.go(key, column, value);
        }
        if (nullKey) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.mongoMsgCatalog.getMessage("NullKey"));
        }
    }

    public void addDoublesToSeries(String key, List<String> columns, List<Double> values) {
        this.multiAdd(key, columns, values, this.multiDouble);
    }

    public void addLongsToSeries(String key, List<String> columns, List<Long> values) {
        this.multiAdd(key, columns, values, this.multiLong);
    }

    public void addStringsToSeries(String key, List<String> columns, List<String> values) {
        this.multiAdd(key, columns, values, this.multiString);
    }

    public void addStructuresToSeries(String key, List<String> columns, List<String> values) {
        this.multiAdd(key, columns, values, this.multiStruct);
    }

    public void addPointsToSeries(String key, List<SeriesValue> values) {
        Iterator<SeriesValue> val = values.iterator();
        while (val.hasNext()) {
            this.multiPoint.go(key, null, val.next());
        }
    }

    public boolean deletePointsFromSeriesByPointKey(String key, List<String> pointKeys) {
        MongoCollection<Document> collection = this.getCollection(key);
        boolean ret = false;
        for (String pointKey : pointKeys) {
            Document victim = new Document(ROWKEY, (Object)key).append(COLKEY, (Object)pointKey);
            try {
                DeleteResult result = collection.deleteMany((Bson)victim);
                log.info((Object)("Removed " + result.getDeletedCount() + " rows"));
                ret = result.getDeletedCount() > 0L;
            }
            catch (MongoException me) {
                throw RaptureExceptionFactory.create((Integer)500, (Formattable)new ExceptionToString((Throwable)me));
            }
        }
        return ret;
    }

    public boolean deletePointsFromSeries(String key) {
        boolean ret = false;
        MongoCollection<Document> collection = this.getCollection(key);
        Document victim = new Document(ROWKEY, (Object)key);
        try {
            DeleteResult result = collection.deleteMany((Bson)victim);
            log.info((Object)("Removed " + result.getDeletedCount() + " rows"));
            ret = result.getDeletedCount() > 0L;
        }
        catch (MongoException me) {
            throw RaptureExceptionFactory.create((Integer)500, (Formattable)new ExceptionToString((Throwable)me));
        }
        this.unregisterKey(key);
        return ret;
    }

    public List<SeriesValue> getPoints(final String key) {
        MongoRetryWrapper<List<SeriesValue>> wrapper = new MongoRetryWrapper<List<SeriesValue>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                Document query = new Document(MongoSeriesStore.ROWKEY, (Object)key);
                MongoCollection collection = MongoSeriesStore.this.getCollection(key);
                FindIterable cursor = collection.find((Bson)query);
                if (cursor == null) {
                    log.info((Object)("No points found for " + key));
                }
                return cursor;
            }

            @Override
            public List<SeriesValue> action(FindIterable<Document> cursor) {
                if (cursor == null) {
                    return null;
                }
                ArrayList result = Lists.newArrayList();
                for (Document entry : cursor) {
                    SeriesValue bolt = MongoSeriesStore.this.makeSeriesValue(entry);
                    result.add(bolt);
                }
                return result;
            }
        };
        return (List)wrapper.doAction();
    }

    private SeriesValue makeSeriesValue(Document entry) {
        Object val = entry.get((Object)VALKEY);
        String col = (String)entry.get((Object)COLKEY);
        if (val instanceof Double) {
            return new DecimalSeriesValue(((Double)val).doubleValue(), col);
        }
        if (val instanceof String) {
            return this.decodeString((String)val, col);
        }
        if (val instanceof Long) {
            return new LongSeriesValue(((Long)val).longValue(), col);
        }
        throw RaptureExceptionFactory.create((Integer)500, (Formattable)this.mongoMsgCatalog.getMessage("UnknownType"));
    }

    private SeriesValue decodeString(String val, String col) {
        if (val.startsWith("'")) {
            return new StringSeriesValue(val.substring(1), col);
        }
        try {
            return StructureSeriesValueImpl.unmarshal((String)val, (String)col);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("JsonError", val));
        }
    }

    public List<SeriesValue> getPointsAfter(final String key, final String startColumn, final int maxNumber) {
        MongoRetryWrapper<List<SeriesValue>> wrapper = new MongoRetryWrapper<List<SeriesValue>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                Document query;
                MongoCollection collection = MongoSeriesStore.this.getCollection(key);
                FindIterable cursor = collection.find((Bson)(query = new Document(MongoSeriesStore.ROWKEY, (Object)key).append(MongoSeriesStore.COLKEY, (Object)new Document("$gte", (Object)startColumn))));
                if (cursor == null) {
                    log.info((Object)("No points found for " + key));
                }
                return cursor;
            }

            @Override
            public List<SeriesValue> action(FindIterable<Document> cursor) {
                if (cursor == null) {
                    return null;
                }
                ArrayList result = Lists.newArrayList();
                int count = 0;
                for (Document entry : cursor) {
                    if (count >= maxNumber) break;
                    SeriesValue bolt = MongoSeriesStore.this.makeSeriesValue(entry);
                    result.add(bolt);
                    ++count;
                }
                return result;
            }
        };
        return (List)wrapper.doAction();
    }

    public List<SeriesValue> getPointsAfterReverse(final String key, final String startColumn, final int maxNumber) {
        MongoRetryWrapper<List<SeriesValue>> wrapper = new MongoRetryWrapper<List<SeriesValue>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                MongoCollection collection = MongoSeriesStore.this.getCollection(key);
                Document query = new Document(MongoSeriesStore.ROWKEY, (Object)key).append(MongoSeriesStore.COLKEY, (Object)new Document("$lte", (Object)startColumn));
                Document sort = new Document(MongoSeriesStore.COLKEY, (Object)-1);
                FindIterable cursor = collection.find((Bson)query).sort((Bson)sort);
                if (cursor == null) {
                    log.info((Object)("No points found for " + key));
                }
                return cursor;
            }

            @Override
            public List<SeriesValue> action(FindIterable<Document> cursor) {
                if (cursor == null) {
                    return null;
                }
                int count = 0;
                ArrayList result = Lists.newArrayList();
                for (Document entry : cursor) {
                    if (count >= maxNumber) break;
                    SeriesValue bolt = MongoSeriesStore.this.makeSeriesValue(entry);
                    result.add(bolt);
                    ++count;
                }
                return result;
            }
        };
        return (List)wrapper.doAction();
    }

    public List<SeriesValue> getPointsAfter(final String key, final String startColumn, final String endColumn, final int maxNumber) {
        MongoRetryWrapper<List<SeriesValue>> wrapper = new MongoRetryWrapper<List<SeriesValue>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                Document query;
                MongoCollection collection = MongoSeriesStore.this.getCollection(key);
                FindIterable cursor = collection.find((Bson)(query = new Document(MongoSeriesStore.ROWKEY, (Object)key).append(MongoSeriesStore.COLKEY, (Object)new Document("$gte", (Object)startColumn).append("$lte", (Object)endColumn))));
                if (cursor == null) {
                    log.info((Object)("No points found for " + key));
                }
                return cursor;
            }

            @Override
            public List<SeriesValue> action(FindIterable<Document> cursor) {
                if (cursor == null) {
                    return null;
                }
                int count = 0;
                ArrayList result = Lists.newArrayList();
                for (Document entry : cursor) {
                    if (count >= maxNumber) break;
                    SeriesValue bolt = MongoSeriesStore.this.makeSeriesValue(entry);
                    result.add(bolt);
                    ++count;
                }
                return result;
            }
        };
        return (List)wrapper.doAction();
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setConfig(Map<String, String> config) {
        this.tableName = config.get("prefix");
        log.debug((Object)("Table name is " + this.tableName + ", instance name is " + this.instanceName));
        if (this.tableName == null) {
            throw RaptureExceptionFactory.create((Integer)400, (Formattable)this.mongoMsgCatalog.getMessage("NoPrefix"));
        }
        MongoDBFactory.getCollection(this.instanceName, this.tableName).createIndex((Bson)INDEX_KEYS, INDEX_OPTS);
    }

    public List<String> getSeriesLike(String keyPrefix) {
        throw new UnsupportedOperationException();
    }

    public Iterable<SeriesValue> getRangeAsIteration(String key, String startCol, String endCol, int pageSize) {
        return new SeriesPaginator(key, startCol, endCol, pageSize, (SeriesStore)this);
    }

    public List<SeriesValue> getRangeAsList(String key, String startCol, String endCol) {
        return this.getPointsAfter(key, startCol, endCol, Integer.MAX_VALUE);
    }

    public List<RaptureFolderInfo> listSeriesByUriPrefix(String folderName) {
        return this.childrenRepo.getChildren(folderName);
    }

    private MongoCollection<Document> getCollection(String checkAllTheCallersIfYouStopIgnoringThisParameter) {
        MongoCollection<Document> result = MongoDBFactory.getCollection(this.instanceName, this.tableName);
        return result;
    }

    public SeriesValue getLastPoint(final String key) {
        MongoRetryWrapper<SeriesValue> wrapper = new MongoRetryWrapper<SeriesValue>(){

            @Override
            public FindIterable<Document> makeCursor() {
                MongoCollection collection = MongoSeriesStore.this.getCollection(key);
                Document query = new Document(MongoSeriesStore.ROWKEY, (Object)key);
                Document sort = new Document(MongoSeriesStore.COLKEY, (Object)-1);
                FindIterable cursor = collection.find((Bson)query).sort((Bson)sort).limit(1);
                if (cursor == null) {
                    log.info((Object)("No points found for " + key));
                }
                return cursor;
            }

            @Override
            public SeriesValue action(FindIterable<Document> cursor) {
                if (cursor == null) {
                    return null;
                }
                MongoCursor iterator = cursor.iterator();
                return iterator.hasNext() ? MongoSeriesStore.this.makeSeriesValue((Document)iterator.next()) : null;
            }
        };
        return (SeriesValue)wrapper.doAction();
    }

    public void createSeries(String key) {
        this.registerKey(key);
    }

    public void deleteSeries(String key) {
        this.unregisterKey(key);
        this.deletePointsFromSeries(key);
    }

    private static interface Callback<T> {
        public void go(String var1, String var2, T var3);
    }
}

