/*
 * Decompiled with CFR 0.152.
 */
package rapture.table.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import rapture.dsl.idef.FieldDefinition;
import rapture.dsl.idef.IndexDefinition;

public class IndexNameFactory {
    static String createIndexName(IndexDefinition indexDefinition) {
        String indexName = indexDefinition.getIndexName();
        if (indexName == null) {
            Iterable names = Iterables.transform((Iterable)indexDefinition.getFields(), (Function)new Function<FieldDefinition, String>(){

                public String apply(FieldDefinition input) {
                    return input.getName();
                }
            });
            indexName = StringUtils.join((Collection)Lists.newArrayList((Iterable)names), (String)"") + "_idx";
        }
        return indexName;
    }
}

