/*
 * Decompiled with CFR 0.152.
 */
package rapture.table.mongodb;

import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReturnDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import rapture.common.LockHandle;
import rapture.common.TableColumnSort;
import rapture.common.TableQuery;
import rapture.common.TableQueryResult;
import rapture.common.TableRecord;
import rapture.common.TableSelect;
import rapture.common.model.DocumentMetadata;
import rapture.config.MultiValueConfigLoader;
import rapture.dsl.idef.FieldDefinition;
import rapture.dsl.idef.IndexDefinition;
import rapture.dsl.iqry.IndexQuery;
import rapture.dsl.iqry.IndexQueryFactory;
import rapture.dsl.iqry.OrderDirection;
import rapture.dsl.iqry.WhereClause;
import rapture.dsl.iqry.WhereExtension;
import rapture.dsl.iqry.WhereStatement;
import rapture.dsl.iqry.WhereTest;
import rapture.index.IndexCreationLock;
import rapture.index.IndexHandler;
import rapture.index.IndexProducer;
import rapture.index.IndexRecord;
import rapture.mongodb.EpochManager;
import rapture.mongodb.MongoDBFactory;
import rapture.mongodb.MongoRetryWrapper;
import rapture.table.mongodb.IndexNameFactory;

public class MongoIndexHandler
implements IndexHandler {
    private static Logger log = Logger.getLogger(MongoIndexHandler.class);
    private static final String PREFIX = "prefix";
    private static final String KEY = "key";
    private static final String EPOCH = "epoch";
    private static final String $SET = "$set";
    private String tableName;
    private String instanceName = "default";
    private IndexProducer indexProducer;

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setConfig(Map<String, String> config) {
        this.tableName = config.get(PREFIX);
        MongoCollection<Document> collection = MongoDBFactory.getCollection(this.instanceName, this.tableName);
        collection.createIndex((Bson)new BsonDocument(KEY, (BsonValue)new BsonInt32(1)));
    }

    private String getKey(String rowId) {
        return "l/" + rowId;
    }

    public void deleteTable() {
        MongoDBFactory.getCollection(this.instanceName, this.tableName).drop();
    }

    public void removeAll(String rowId) {
        String key = this.getKey(rowId);
        MongoCollection<Document> collection = MongoDBFactory.getCollection(this.instanceName, this.tableName);
        Document query = new Document();
        query.put(KEY, (Object)key);
        collection.findOneAndDelete((Bson)query);
    }

    public void addedRecord(String key, String value, DocumentMetadata mdLatest) {
        List records = this.indexProducer.getIndexRecords(key, value, mdLatest);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (IndexRecord record : records) {
            values.putAll(record.getValues());
        }
        this.updateRow(key, values);
    }

    public void updateRow(String rowId, Map<String, Object> recordValues) {
        String key = this.getKey(rowId);
        MongoCollection<Document> collection = MongoDBFactory.getCollection(this.instanceName, this.tableName);
        Document query = new Document();
        query.put(KEY, (Object)key);
        Document toPut = new Document();
        toPut.put(KEY, (Object)key);
        toPut.put("rowId", (Object)rowId);
        toPut.put(EPOCH, (Object)EpochManager.nextEpoch(collection));
        toPut.putAll(recordValues);
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
        Document ret = (Document)collection.findOneAndUpdate((Bson)query, (Bson)new Document($SET, (Object)toPut), options);
    }

    public Long getLatestEpoch() {
        return EpochManager.getLatestEpoch(MongoDBFactory.getCollection(this.instanceName, this.tableName));
    }

    public void setIndexProducer(IndexProducer indexProducer) {
        this.indexProducer = indexProducer;
    }

    public void initialize() {
        for (IndexDefinition indexDefinition : this.indexProducer.getIndexDefinitions()) {
            this.createIndex(indexDefinition, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureIndicesExist() {
        log.info((Object)String.format("About to build indices for collection [%s]...", this.tableName));
        LockHandle lockHandle = null;
        try {
            lockHandle = IndexCreationLock.INSTANCE.grabLock();
            for (IndexDefinition indexDefinition : this.indexProducer.getIndexDefinitions()) {
                this.createIndex(indexDefinition, true);
            }
        }
        finally {
            if (lockHandle != null) {
                IndexCreationLock.INSTANCE.releaseLock(lockHandle);
            }
        }
        log.info((Object)String.format("Done building indices for collection [%s]", this.tableName));
    }

    private void createIndex(IndexDefinition indexDefinition, boolean force) {
        if (indexDefinition == null) {
            return;
        }
        String indexName = IndexNameFactory.createIndexName(indexDefinition);
        MongoCollection<Document> collection = MongoDBFactory.getCollection(this.instanceName, this.tableName);
        int limit = Integer.parseInt(MultiValueConfigLoader.getConfig((String)("MONGODB-" + this.instanceName + ".limit"), (String)MultiValueConfigLoader.getConfig((String)"MONGODB-default.limit", (String)"250")));
        boolean indexExists = false;
        ListIndexesIterable indexInfo = collection.listIndexes();
        for (Document dbObject : indexInfo) {
            Object name = dbObject.get((Object)"name");
            if (name == null || !name.toString().equals(indexName)) continue;
            indexExists = true;
            break;
        }
        if (force || collection.count() < (long)limit) {
            this.createIt(indexDefinition, force, indexName, collection);
        } else if (!indexExists) {
            log.warn((Object)(this.tableName + " collection has more than " + limit + " items. please index manually"));
        }
    }

    private void createIt(IndexDefinition indexDefinition, boolean force, String indexName, MongoCollection<Document> collection) {
        Document index = new Document();
        for (FieldDefinition f : indexDefinition.getFields()) {
            index.put(f.getName(), (Object)1);
        }
        IndexOptions options = new IndexOptions().name(indexName).background(!force);
        collection.createIndex((Bson)index, options);
    }

    public List<TableRecord> queryTable(final TableQuery querySpec) {
        MongoRetryWrapper<List<TableRecord>> wrapper = new MongoRetryWrapper<List<TableRecord>>(){

            @Override
            public FindIterable<Document> makeCursor() {
                List projection;
                MongoCollection<Document> collection = MongoDBFactory.getCollection(MongoIndexHandler.this.instanceName, MongoIndexHandler.this.tableName);
                Document query = EpochManager.getNotEqualEpochQueryObject();
                if (querySpec.getFieldTests() != null) {
                    for (TableSelect sel : querySpec.getFieldTests()) {
                        switch (sel.getOper()) {
                            case "=": {
                                query.append(sel.getFieldName(), sel.getTestValue());
                                break;
                            }
                            case ">": {
                                Document gt = new Document();
                                gt.append("$gt", sel.getTestValue());
                                query.append(sel.getFieldName(), (Object)gt);
                                break;
                            }
                            case "<": {
                                Document lt = new Document();
                                lt.append("$lt", sel.getTestValue());
                                query.append(sel.getFieldName(), (Object)lt);
                                break;
                            }
                            case "LIKE": {
                                query.append(sel.getFieldName(), (Object)Pattern.compile(sel.getTestValue().toString()));
                            }
                        }
                    }
                }
                if ((projection = querySpec.getFieldReturns()) != null) {
                    projection.add(MongoIndexHandler.KEY);
                }
                Document sort = new Document();
                if (querySpec.getSortFields() != null) {
                    for (TableColumnSort sortField : querySpec.getSortFields()) {
                        sort.put(sortField.getFieldName(), (Object)(sortField.getAscending() != false ? 1 : -1));
                    }
                }
                FindIterable ret = collection.find((Bson)query).projection(Projections.include((List)(projection == null ? Collections.emptyList() : projection)));
                if (!sort.isEmpty()) {
                    ret = ret.sort((Bson)sort);
                }
                if (querySpec.getSkip() != 0) {
                    ret = ret.skip(querySpec.getSkip());
                }
                if (querySpec.getLimit() != 0) {
                    ret = ret.limit(querySpec.getLimit());
                }
                return ret;
            }

            @Override
            public List<TableRecord> action(FindIterable<Document> cursor) {
                ArrayList<TableRecord> records = new ArrayList<TableRecord>();
                if (cursor != null) {
                    for (Document obj : cursor) {
                        if (obj == null) continue;
                        TableRecord rec = new TableRecord();
                        rec.setKeyName(obj.getString((Object)MongoIndexHandler.KEY));
                        rec.setFields((Map)obj);
                        rec.setContent(obj.toString());
                        records.add(rec);
                    }
                }
                return records;
            }
        };
        return (List)wrapper.doAction();
    }

    public TableQueryResult query(String query) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Performing query " + query));
        }
        IndexQuery parsedQuery = IndexQueryFactory.parseQuery((String)query);
        return this.query(parsedQuery);
    }

    public TableQueryResult query(final IndexQuery indexQuery) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsed query " + indexQuery));
        }
        TableQueryResult res = new TableQueryResult();
        final Document mongoQuery = this.getClause(indexQuery.getWhere());
        final MongoCollection<Document> collection = MongoDBFactory.getCollection(this.instanceName, this.tableName);
        if (!indexQuery.isDistinct()) {
            final Document fields = new Document();
            for (String fieldName : indexQuery.getSelect().getFieldList()) {
                log.debug((Object)("Adding return field " + fieldName));
                fields.put(fieldName, (Object)1);
            }
            res.setColumnNames(indexQuery.getSelect().getFieldList());
            fields.put(KEY, (Object)1);
            MongoRetryWrapper<List<List<Object>>> wrapper = new MongoRetryWrapper<List<List<Object>>>(){

                @Override
                public FindIterable<Document> makeCursor() {
                    FindIterable ret;
                    Document sort = new Document();
                    if (indexQuery.getOrderBy().getFieldList().size() > 0) {
                        for (String field : indexQuery.getOrderBy().getFieldList()) {
                            sort.put(field, (Object)(indexQuery.getDirection() == OrderDirection.ASC ? 1 : -1));
                        }
                    }
                    if (fields.isEmpty()) {
                        ret = collection.find((Bson)mongoQuery);
                    } else {
                        fields.put(MongoIndexHandler.KEY, (Object)1);
                        ret = collection.find((Bson)mongoQuery).projection((Bson)fields);
                    }
                    if (!sort.isEmpty()) {
                        ret = ret.sort((Bson)sort);
                    }
                    if (indexQuery.getLimit() != 0) {
                        ret = ret.limit(indexQuery.getLimit());
                    }
                    return ret;
                }

                @Override
                public List<List<Object>> action(FindIterable<Document> cursor) {
                    ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
                    for (Document obj : cursor) {
                        ArrayList<Object> row = new ArrayList<Object>();
                        for (String field : indexQuery.getSelect().getFieldList()) {
                            row.add(obj.get((Object)field));
                        }
                        rows.add(row);
                    }
                    return rows;
                }
            };
            res.setRows((List)wrapper.doAction());
        } else {
            String key = (String)indexQuery.getSelect().getFieldList().get(0);
            ArrayList rows = new ArrayList();
            DistinctIterable values = collection.distinct(key, (Bson)mongoQuery, String.class);
            for (String v : values) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(v);
                rows.add(row);
            }
            res.setRows(rows);
            ArrayList<String> columnNames = new ArrayList<String>();
            columnNames.add(key);
            res.setColumnNames(columnNames);
        }
        return res;
    }

    private Document getClause(WhereClause whereClause) {
        log.debug((Object)"Getting where clause");
        Document ret = EpochManager.getNotEqualEpochQueryObject();
        if (whereClause.getPrimary() != null) {
            this.workWith(whereClause.getPrimary(), ret);
            if (!whereClause.getExtensions().isEmpty()) {
                for (WhereExtension xt : whereClause.getExtensions()) {
                    this.workWith(xt.getClause(), ret);
                }
            }
        }
        return ret;
    }

    private void workWith(WhereStatement whereClause, Document ret) {
        if (whereClause.getOper() == WhereTest.EQUAL) {
            log.debug((Object)"Primary is = ");
            ret.append(whereClause.getField(), whereClause.getValue().getValue());
            log.debug((Object)("Query is " + ret.toString()));
        } else {
            Document inner = (Document)ret.get((Object)whereClause.getField());
            boolean addMe = false;
            if (inner == null) {
                addMe = true;
                inner = new Document();
            }
            switch (whereClause.getOper()) {
                case GT: {
                    inner.append("$gt", whereClause.getValue().getValue());
                    break;
                }
                case LT: {
                    inner.append("$lt", whereClause.getValue().getValue());
                    break;
                }
                case NOTEQUAL: {
                    inner.append("$ne", whereClause.getValue().getValue());
                    break;
                }
            }
            if (addMe) {
                ret.append(whereClause.getField(), (Object)inner);
            }
        }
    }
}

