/*
 * Decompiled with CFR 0.152.
 */
package plugin.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugin.model.AuthorityBaseReference;
import plugin.model.BaseTree;
import plugin.model.ReferenceWorker;

public class AuthorityBaseTree<T extends AuthorityBaseReference<T>>
extends BaseTree<T> {
    private Map<String, List<T>> referencesByAuthority = new HashMap<String, List<T>>();

    public void addReference(T reference) {
        String authority = ((AuthorityBaseReference)reference).getAuthority();
        this.ensureAuthorityPresent(authority);
        this.referencesByAuthority.get(authority).add(reference);
    }

    private void ensureAuthorityPresent(String authority) {
        if (!this.referencesByAuthority.containsKey(authority)) {
            this.referencesByAuthority.put(authority, this.getNewReferenceList());
        }
    }

    private List<T> getNewReferenceList() {
        return new ArrayList();
    }

    public void workThrough(int skipPercent, ReferenceWorker<T> worker) {
        for (Map.Entry<String, List<T>> entry : this.referencesByAuthority.entrySet()) {
            worker.startAuthority(entry.getKey());
            Collections.sort(entry.getValue());
            int total = entry.getValue().size();
            System.out.println("Size is " + total);
            int count = 0;
            int skipCount = 0;
            if (skipPercent != -1) {
                System.out.println("Skipping by " + skipPercent);
                skipCount = skipPercent * total / 100;
            }
            for (AuthorityBaseReference reference : entry.getValue()) {
                ++count;
                if (skipCount > 0) {
                    --skipCount;
                }
                if (skipCount <= 0) {
                    worker.workWithReference(reference);
                }
                if (count % 1000 != 0) continue;
                System.out.println("Processed " + count + " out of " + total + "(" + count * 100 / total + "%)");
            }
        }
        worker.finished();
    }
}

