/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin;

import rapture.common.PluginConfig;
import rapture.common.PluginConfigStorage;
import rapture.common.RaptureURI;
import rapture.common.Scheme;
import rapture.common.client.ScriptClient;
import rapture.common.exception.RaptureException;
import rapture.common.storable.helpers.PluginConfigHelper;

public class PluginPresence {
    private ScriptClient raptureClient;

    public PluginPresence(ScriptClient raptureClient) {
        this.raptureClient = raptureClient;
    }

    public boolean doesFeatureNeedInstalling(PluginConfig feature) {
        PluginConfig existingConfig = null;
        try {
            RaptureURI internalUri = new RaptureURI(feature.getPlugin(), Scheme.PLUGIN);
            existingConfig = PluginConfigStorage.readByAddress((RaptureURI)internalUri);
            return PluginConfigHelper.earlierThan((PluginConfig)existingConfig, (PluginConfig)feature);
        }
        catch (RaptureException e) {
            return true;
        }
    }

    public void registerFeatureInstalled(PluginConfig plugin) {
        PluginConfigStorage.add((PluginConfig)plugin, (String)this.raptureClient.getUser().getContext().getContext(), (String)"Recorded plugin");
    }
}

