/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rapture.common.api.ScriptingApi;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.common.model.DocumentWithMeta;
import rapture.common.uri.URIParser;
import rapture.util.DisplayNameParts;
import rapture.util.StringUtil;
import rapture.util.TypeUtil;
import reflex.AbstractReflexDataHandler;

public class ReflexDataHandler
extends AbstractReflexDataHandler {
    private ScriptingApi api;
    private ScriptingApi originalApi;

    public ReflexDataHandler(ScriptingApi scriptClient) {
        super(scriptClient);
    }

    public List<String> batchPushData(List<String> displayNames, List<Map<String, Object>> datas) {
        List displayBatches = TypeUtil.getBatches(displayNames, (int)50);
        List dataBatches = TypeUtil.getBatches(datas, (int)50);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < displayBatches.size(); ++i) {
            List batchDisplayNames = (List)displayBatches.get(i);
            List dataBatch = (List)dataBatches.get(i);
            ArrayList<String> parsedDisplayNames = new ArrayList<String>();
            ArrayList<String> contents = new ArrayList<String>();
            for (String disp : batchDisplayNames) {
                disp = URIParser.convertDocURI((String)disp);
                parsedDisplayNames.add(disp);
                contents.add(JacksonUtil.jsonFromObject(dataBatch.get(i)));
            }
            this.api.getDoc().putDocs(parsedDisplayNames, contents);
            ret.addAll(parsedDisplayNames);
        }
        return ret;
    }

    public List<Map<String, Object>> batchPullData(List<String> displayNames) {
        ArrayList content = new ArrayList();
        List batches = StringUtil.getBatches(displayNames, (int)50);
        for (List batch : batches) {
            ArrayList<String> batchDisplayNames = new ArrayList<String>();
            for (String disp : batch) {
                DisplayNameParts p = new DisplayNameParts(disp);
                batchDisplayNames.add(p.getDisplay());
            }
            Map contents = this.api.getDoc().getDocs(batchDisplayNames);
            content.addAll(contents.values());
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (String c : content) {
            if (c == null) {
                ret.add(null);
                continue;
            }
            ret.add(JacksonUtil.getMapFromJson((String)c));
        }
        return ret;
    }

    public Map<String, Object> pullData(String fullName) {
        String content = this.api.getDoc().getDoc(fullName);
        if (content == null) {
            return null;
        }
        return JacksonUtil.getMapFromJson((String)content);
    }

    public String pushData(String fullName, Map<String, Object> data) {
        String content = JacksonUtil.jsonFromObject(data);
        String ret = this.api.getDoc().putDoc(fullName, content);
        return ret;
    }

    public void remove(String displayName) {
        this.api.getDoc().deleteDoc(displayName);
    }

    public Map<String, Object> metaPullData(String fullName) {
        DocumentWithMeta content = this.api.getDoc().getDocAndMeta(fullName);
        if (content == null) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("meta", JacksonUtil.getHashFromObject((Object)content.getMetaData()));
        ret.put("content", JacksonUtil.getMapFromJson((String)content.getContent()));
        return ret;
    }

    public String rawPushData(String displayName, String content) {
        String ret = this.api.getDoc().putDoc(displayName, content);
        return ret;
    }

    public List<String> batchPushRawData(List<String> displayNames, List<String> datas) {
        List displayBatches = TypeUtil.getBatches(displayNames, (int)50);
        List dataBatches = TypeUtil.getBatches(datas, (int)50);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < displayBatches.size(); ++i) {
            List batchDisplayNames = (List)displayBatches.get(i);
            List dataBatch = (List)dataBatches.get(i);
            ArrayList<String> parsedDisplayNames = new ArrayList<String>();
            for (String disp : batchDisplayNames) {
                disp = URIParser.convertDocURI((String)disp);
                parsedDisplayNames.add(disp);
            }
            this.api.getDoc().putDocs(parsedDisplayNames, dataBatch);
            ret.addAll(parsedDisplayNames);
        }
        return ret;
    }

    public boolean hasCapability() {
        return true;
    }

    public void switchApi(ScriptingApi api) {
        this.api = api;
    }

    public void resetApi() {
        this.api = this.originalApi;
    }
}

