/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin;

import rapture.common.api.ScriptingApi;
import rapture.plugin.ReflexDataHandler;
import rapture.plugin.ReflexScriptHandler;
import rapture.plugin.ReflexStdOutDebugHandler;
import reflex.DefaultReflexIOHandler;
import reflex.DummyPortHandler;
import reflex.DummyReflexInputHandler;
import reflex.DummyReflexOutputHandler;
import reflex.IReflexCacheHandler;
import reflex.IReflexDataHandler;
import reflex.IReflexDebugHandler;
import reflex.IReflexHandler;
import reflex.IReflexIOHandler;
import reflex.IReflexInputHandler;
import reflex.IReflexOutputHandler;
import reflex.IReflexPortHandler;
import reflex.IReflexScriptHandler;
import reflex.IReflexSuspendHandler;
import reflex.NullReflexSuspendHandler;
import reflex.cache.DefaultReflexCacheHandler;

public class ReflexHandler
implements IReflexHandler {
    private ScriptingApi api;
    private IReflexDataHandler dataHandler;
    private IReflexDebugHandler debugHandler;
    private IReflexIOHandler ioHandler = new DefaultReflexIOHandler();
    private IReflexScriptHandler scriptHandler;
    private IReflexPortHandler portHandler = new DummyPortHandler();
    private IReflexSuspendHandler suspendHandler = new NullReflexSuspendHandler();
    private IReflexOutputHandler outputHandler = new DummyReflexOutputHandler();
    private IReflexInputHandler inputHandler = new DummyReflexInputHandler();
    private IReflexCacheHandler cacheHandler = new DefaultReflexCacheHandler();
    private ScriptingApi originalApi;

    public ReflexHandler(ScriptingApi scriptClient) {
        this.originalApi = this.api = scriptClient;
        this.scriptHandler = new ReflexScriptHandler(this.api);
        this.dataHandler = new ReflexDataHandler(scriptClient);
        this.debugHandler = new ReflexStdOutDebugHandler();
    }

    public ScriptingApi getApi() {
        return this.api;
    }

    public IReflexDataHandler getDataHandler() {
        return this.dataHandler;
    }

    public IReflexDebugHandler getDebugHandler() {
        return this.debugHandler;
    }

    public IReflexIOHandler getIOHandler() {
        return this.ioHandler;
    }

    public IReflexPortHandler getPortHandler() {
        return this.portHandler;
    }

    public IReflexScriptHandler getScriptHandler() {
        return this.scriptHandler;
    }

    public void setApi(ScriptingApi arg0) {
        this.api = arg0;
    }

    public void setDataHandler(IReflexDataHandler arg0) {
        this.dataHandler = arg0;
    }

    public IReflexSuspendHandler getSuspendHandler() {
        return this.suspendHandler;
    }

    public void setSuspendHandler(IReflexSuspendHandler suspendHandler) {
        this.suspendHandler = suspendHandler;
    }

    public IReflexOutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    public void setOutputHandler(IReflexOutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    public IReflexCacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public void setCacheHandler(IReflexCacheHandler cacheHandler) {
        this.cacheHandler = cacheHandler;
    }

    public IReflexInputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(IReflexInputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public void setIOHandler(IReflexIOHandler reflexIOHandler) {
        this.ioHandler = reflexIOHandler;
    }

    public void switchApi(ScriptingApi api) {
        this.api = api;
        this.dataHandler.switchApi(api);
    }

    public void resetApi() {
        this.api = this.originalApi;
        this.dataHandler.resetApi();
    }
}

