/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin.install;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import rapture.common.PluginConfig;
import rapture.common.PluginManifest;
import rapture.common.PluginManifestItem;
import rapture.common.PluginVersion;
import rapture.common.RaptureURI;
import rapture.common.api.ScriptingApi;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.plugin.PluginUtil;
import rapture.plugin.install.PluginContentReader;
import rapture.plugin.install.PluginSandboxItem;

public class PluginSandbox {
    private boolean strict = false;
    private String pluginName;
    private String description;
    private PluginVersion version;
    private File rootDir;
    private static final boolean debug = true;
    public static final String CONTENT = "content/";
    public static final String PLUGIN_TXT = "plugin.txt";
    public static final String DEPRECATED_FEATURE_TXT = "feature.txt";
    private Map<RaptureURI, PluginSandboxItem> uri2item = new LinkedHashMap<RaptureURI, PluginSandboxItem>();
    private Map<String, PluginVersion> depends = new LinkedHashMap<String, PluginVersion>();
    private Map<String, Map<RaptureURI, PluginSandboxItem>> variant2map = new LinkedHashMap<String, Map<RaptureURI, PluginSandboxItem>>();
    private static final Map<String, PluginVersion> emptyMap = ImmutableMap.of();
    private static Logger logger = Logger.getLogger((String)PluginSandbox.class.getName());
    private static final String IGNORE = "plugin.ignore";
    public static final PluginVersion DEFAULT_VERSION = new PluginVersion(0, 0, 0, 0L);

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
        for (PluginSandboxItem item : this.uri2item.values()) {
            item.updateFilePath(rootDir);
        }
    }

    public PluginSandboxItem getOrMakeItem(RaptureURI uri) {
        PluginSandboxItem item = this.uri2item.get(uri);
        if (item == null) {
            item = this.makeItem(uri);
            this.uri2item.put(uri, item);
        }
        return item;
    }

    public PluginSandboxItem getItem(RaptureURI uri) {
        return this.uri2item.get(uri);
    }

    private PluginSandboxItem makeItem(RaptureURI uri) {
        if (this.rootDir == null) {
            return new PluginSandboxItem(uri, null);
        }
        return new PluginSandboxItem(uri, this.rootDir, null);
    }

    public List<PluginSandboxItem> diffWithFolder(PluginManifest manifest, boolean cacheIfDifferent) throws NoSuchAlgorithmException, IOException {
        ArrayList result = Lists.newArrayList();
        for (PluginManifestItem mItem : manifest.getContents()) {
            PluginSandboxItem sItem = this.getOrMakeItem(PluginSandbox.makeURI(mItem));
            if (!sItem.diffWithFile(mItem.getHash(), cacheIfDifferent)) continue;
            result.add(sItem);
        }
        return result;
    }

    public boolean downloadAllContentFromRemote(ScriptingApi client, PluginManifest manifest) {
        boolean changed = false;
        for (PluginManifestItem item : manifest.getContents()) {
            changed |= this.downloadContentFromRemote(client, item);
        }
        return changed;
    }

    public boolean downloadContentFromRemote(ScriptingApi client, PluginManifestItem mItem) {
        PluginSandboxItem sItem = this.getOrMakeItem(PluginSandbox.makeURI(mItem));
        return sItem.download(client, true);
    }

    private static RaptureURI makeURI(PluginManifestItem item) {
        return new RaptureURI(item.getURI(), null);
    }

    public void readConfig() {
        String s = PluginUtil.getFileAsString(new File(this.rootDir, PLUGIN_TXT));
        PluginConfig config = null;
        try {
            config = (PluginConfig)JacksonUtil.objectFromJson((String)s, PluginConfig.class);
        }
        catch (Exception ex) {
            throw RaptureExceptionFactory.create((String)"The plugin.txt file has been corrupted.", (Throwable)ex);
        }
        if (!config.getPlugin().equals(this.pluginName)) {
            throw RaptureExceptionFactory.create((Integer)400, (String)("Config mismatch: " + config.getPlugin()));
        }
        this.setConfig(config);
    }

    public void setConfig(PluginConfig config) {
        this.pluginName = config.getPlugin();
        this.description = config.getDescription();
        this.version = config.getVersion();
        this.depends = config.getDepends();
    }

    private Collection<PluginSandboxItem> getVariantItems(String thisVariant) {
        if (thisVariant == null) {
            return ImmutableSet.of();
        }
        ArrayList matches = Lists.newArrayList();
        for (String name : this.variant2map.keySet()) {
            if (!name.equalsIgnoreCase(thisVariant)) continue;
            matches.add(name);
        }
        HashSet result = Sets.newHashSet();
        for (String name : matches) {
            result.addAll(this.variant2map.get(name).values());
        }
        return result;
    }

    public Iterable<PluginSandboxItem> getItems(String variant) {
        HashMap<RaptureURI, PluginSandboxItem> result = new HashMap<RaptureURI, PluginSandboxItem>();
        Set<RaptureURI> uris = this.uri2item.keySet();
        for (RaptureURI uri : uris) {
            result.put(uri, this.uri2item.get(uri));
        }
        Collection<PluginSandboxItem> variantItems = this.getVariantItems(variant);
        for (PluginSandboxItem variantItem : variantItems) {
            result.put(variantItem.getURI(), variantItem);
        }
        return result.values();
    }

    PluginConfig makeConfig() {
        PluginConfig config = new PluginConfig();
        config.setDepends(emptyMap);
        config.setDescription(this.description == null ? "" : this.description);
        config.setVersion(this.version);
        config.setPlugin(this.pluginName);
        return config;
    }

    public void writeConfig() throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(this.rootDir, PLUGIN_TXT)));
        this.writePlugin(out);
        out.close();
    }

    void writePlugin(OutputStream out) throws IOException {
        String s = JacksonUtil.jsonFromObject((Object)this.makeConfig());
        out.write(s.getBytes("UTF-8"));
    }

    public void save(ScriptingApi client) throws IOException {
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            throw RaptureExceptionFactory.create((Integer)500, (String)("Could not create directory" + this.rootDir.getPath()));
        }
        this.writeConfig();
        for (PluginSandboxItem pluginSandboxItem : this.uri2item.values()) {
            if (pluginSandboxItem.isFileCurrent()) continue;
            if (!pluginSandboxItem.isRemoteCurrent()) {
                pluginSandboxItem.download(client, true);
            }
            pluginSandboxItem.storeFile();
        }
        for (Map map : this.variant2map.values()) {
            for (PluginSandboxItem item : map.values()) {
                if (!item.isRemoteCurrent()) {
                    item.download(client, true);
                }
                item.storeFile();
            }
        }
    }

    public PluginSandboxItem addURI(String variant, RaptureURI uri) {
        PluginSandboxItem item = new PluginSandboxItem(uri, this.rootDir, variant);
        this.updateIndex(uri, variant, item);
        return item;
    }

    public PluginSandboxItem addURI(String variant, RaptureURI uri, String remoteHash) {
        PluginSandboxItem item = new PluginSandboxItem(uri, this.rootDir, variant, remoteHash);
        this.updateIndex(uri, variant, item);
        return item;
    }

    private void updateIndex(RaptureURI uri, String variant, PluginSandboxItem item) {
        if (variant == null) {
            this.uri2item.put(uri, item);
        } else {
            this.putVariantItem(uri, variant, item);
        }
    }

    public boolean removeURI(RaptureURI uri) {
        PluginSandboxItem item = this.uri2item.remove(uri);
        if (item == null) {
            return false;
        }
        item.delete();
        return true;
    }

    public Map<RaptureURI, String> extract(ScriptingApi client, boolean force) {
        LinkedHashMap<RaptureURI, String> errors = new LinkedHashMap<RaptureURI, String>();
        for (PluginSandboxItem item : this.uri2item.values()) {
            try {
                item.download(client, force);
            }
            catch (Exception ex) {
                errors.put(item.getURI(), ex.getMessage());
            }
        }
        return errors;
    }

    public void extract(ScriptingApi client, RaptureURI uri, boolean force) {
        PluginSandboxItem item = this.uri2item.get(uri);
        if (item == null) {
            throw RaptureExceptionFactory.create((Integer)400, (String)"URI not in manifest");
        }
        item.download(client, force);
    }

    public void writeZip(String filename, ScriptingApi client, String thisVariant, boolean build) throws IOException {
        if (thisVariant == null) {
            this.readAllVariants();
        } else {
            this.readContent(thisVariant);
        }
        ZipOutputStream out = null;
        File zipFile = new File(filename);
        File p = zipFile.getParentFile();
        if (p != null) {
            p.mkdirs();
        }
        out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
        ZipEntry entry = new ZipEntry(PLUGIN_TXT);
        out.putNextEntry(entry);
        this.writePlugin(out);
        for (PluginSandboxItem pluginSandboxItem : this.uri2item.values()) {
            pluginSandboxItem.writeZipEntry(out, client, build);
        }
        for (Map.Entry entry2 : this.variant2map.entrySet()) {
            if (thisVariant != null && !thisVariant.equals(entry2.getKey())) continue;
            for (PluginSandboxItem item : ((Map)entry2.getValue()).values()) {
                item.writeZipEntry(out, client, build);
            }
        }
        out.close();
    }

    public PluginManifest makeManifest(String variant) {
        Map<RaptureURI, PluginSandboxItem> map;
        HashMap<RaptureURI, PluginManifestItem> hashes = new HashMap<RaptureURI, PluginManifestItem>();
        PluginManifest manifest = new PluginManifest();
        manifest.setPlugin(this.pluginName);
        manifest.setDescription(this.description);
        manifest.setVersion(this.version);
        for (PluginSandboxItem item : this.uri2item.values()) {
            PluginManifestItem mItem = new PluginManifestItem();
            mItem.setURI(item.getURI().toShortString());
            mItem.setHash(item.getHash());
            hashes.put(item.getURI(), mItem);
        }
        if (variant != null && (map = this.variant2map.get(variant.toLowerCase())) != null) {
            for (PluginSandboxItem item : map.values()) {
                PluginManifestItem mItem = new PluginManifestItem();
                mItem.setURI(item.getURI().toString());
                mItem.setHash(item.getHash());
                hashes.put(item.getURI(), mItem);
            }
        }
        LinkedList contents = new LinkedList();
        contents.addAll(hashes.values());
        manifest.setContents(contents);
        return manifest;
    }

    public PluginSandboxItem makeItemFromInternalEntry(RaptureURI uri, InputStream is, String variant) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] content = PluginContentReader.readFromStreamWithDigest((InputStream)is, (MessageDigest)md);
        String hash = Hex.encodeHexString((byte[])md.digest());
        PluginSandboxItem result = new PluginSandboxItem(uri, null, hash, content);
        if (this.rootDir != null) {
            result.updateFilePath(this.rootDir);
        }
        this.updateIndex(uri, variant, result);
        return result;
    }

    public PluginSandboxItem makeItemFromInternalEntry(RaptureURI uri, InputStream is, String fullPath, String variant) throws NoSuchAlgorithmException, IOException {
        PluginSandboxItem result = this.makeItemFromInternalEntry(uri, is, null);
        if (!StringUtils.isBlank((CharSequence)fullPath)) {
            result.setFullFilePath(fullPath);
        }
        return result;
    }

    public void makeItemFromZipEntry(ZipFile zip, ZipEntry entry) throws IOException, NoSuchAlgorithmException {
        if (PLUGIN_TXT.equals(entry.getName())) {
            return;
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        try {
            Pair pair = PluginSandboxItem.calculateURI((ZipEntry)entry);
            RaptureURI uri = (RaptureURI)pair.getLeft();
            String variant = (String)pair.getRight();
            if (uri == null) {
                return;
            }
            byte[] content = PluginContentReader.readFromZip((ZipFile)zip, (ZipEntry)entry, (MessageDigest)md);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("name=%s, size=%s", entry.getName(), entry.getSize()));
                logger.debug((Object)String.format("content size=%s", content.length));
                logger.debug((Object)("********* SAME??? " + ((long)content.length == entry.getSize())));
            }
            String hash = Hex.encodeHexString((byte[])md.digest());
            PluginSandboxItem result = new PluginSandboxItem(uri, variant, hash, content);
            if (this.rootDir != null) {
                result.updateFilePath(this.rootDir);
            }
            this.updateIndex(uri, variant, result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void putVariantItem(RaptureURI uri, String variant, PluginSandboxItem result) {
        if (variant != null) {
            variant = variant.toLowerCase();
        }
        if (!this.variant2map.containsKey(variant)) {
            this.variant2map.put(variant, Maps.newHashMap());
        }
        this.variant2map.get(variant).put(uri, result);
    }

    public void readAllVariants() {
        this.readContent("*");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<Pattern> parseIgnoreFile(File dir) {
        File ignoreFile = new File(dir, IGNORE);
        if (!ignoreFile.exists()) return null;
        try (BufferedReader br = new BufferedReader(new FileReader(ignoreFile));){
            String line;
            HashSet<Pattern> ignores = new HashSet<Pattern>();
            while (br.ready() && (line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                ignores.add(Pattern.compile(line));
            }
            HashSet<Pattern> hashSet = ignores;
            return hashSet;
        }
        catch (IOException e) {
            System.out.println("Unable to read " + ignoreFile.getAbsolutePath() + " : " + e.getMessage());
        }
        return null;
    }

    public void readContent(String variant) {
        Set<Pattern> ignore = PluginSandbox.parseIgnoreFile(this.rootDir);
        for (File f : this.rootDir.listFiles()) {
            if (!f.isDirectory()) continue;
            String name = f.getName();
            if (variant != null && !"*".equals(variant) && !"content".equals(name) && !name.equalsIgnoreCase(variant)) continue;
            this.loadDir(f, ignore);
        }
    }

    private void loadDir(File dir, Set<Pattern> ignore) {
        File[] file;
        System.out.println("Loading from " + dir.getAbsolutePath());
        Set<Pattern> localIgnores = PluginSandbox.parseIgnoreFile(dir);
        if (localIgnores != null) {
            if (ignore != null) {
                localIgnores.addAll(ignore);
            }
            ignore = localIgnores;
        }
        for (File f : file = dir.listFiles()) {
            if (f.isDirectory()) {
                this.loadDir(f, ignore);
                continue;
            }
            this.loadSandboxItem(f, ignore);
        }
    }

    private void loadSandboxItem(File f, Set<Pattern> ignore) {
        Pair pair = null;
        try {
            System.out.println("Examining " + f.getAbsolutePath());
            if (ignore != null) {
                if (IGNORE.equals(f.getName())) {
                    return;
                }
                for (Pattern pattern : ignore) {
                    if (!pattern.matcher(f.getAbsolutePath()).matches()) continue;
                    this.warn("Ignoring " + f.getAbsolutePath() + " because it matches pattern " + pattern.pattern());
                    return;
                }
            }
            pair = PluginSandboxItem.calculateURI((File)f, (File)this.rootDir);
        }
        catch (Exception ex) {
            if (this.strict) {
                throw new Error(ex);
            }
            this.warn("Ignoring extraneous file: " + f.getPath());
            return;
        }
        RaptureURI uri = (RaptureURI)pair.getLeft();
        String variant = (String)pair.getRight();
        PluginSandboxItem item = new PluginSandboxItem(uri, this.rootDir, variant);
        item.setFullFilePath(f.getAbsolutePath());
        if (variant == null) {
            this.uri2item.put(uri, item);
        } else {
            this.putVariantItem(uri, variant, item);
        }
    }

    public void setVersion(PluginVersion version) {
        this.version = version;
    }

    public void deflate() {
        for (PluginSandboxItem pluginSandboxItem : this.uri2item.values()) {
            pluginSandboxItem.deflate();
        }
        for (Map map : this.variant2map.values()) {
            for (PluginSandboxItem item : map.values()) {
                item.deflate();
            }
        }
    }

    public void include(PluginSandbox includee) {
        PluginVersion version = includee.version;
        if (version == null) {
            version = DEFAULT_VERSION;
        }
        this.depends.put(includee.pluginName, version);
    }

    private void warn(String msg) {
        System.err.println(msg);
    }
}

