/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin.install;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopoSort<T> {
    private Set<T> entries = new HashSet<T>();
    private Set<Constraint<T>> constraints = new HashSet<Constraint<T>>();

    public List<T> sort() {
        return TopoSort.sort(this.entries, this.constraints);
    }

    public void addConstraint(T before, T after) {
        this.entries.add(before);
        this.entries.add(after);
        this.constraints.add(new Constraint<T>(before, after));
    }

    public void addEntry(T entry) {
        this.entries.add(entry);
    }

    public static <T> List<T> sort(Set<T> entries, Set<Constraint<T>> constraints) {
        HashMap key2scratch = new HashMap();
        ArrayList result = new ArrayList(entries.size());
        for (T t : entries) {
            key2scratch.put(t, new Scratch());
        }
        for (Constraint constraint : constraints) {
            ((Scratch)key2scratch.get(constraint.getAfter())).increment();
            ((Scratch)key2scratch.get(constraint.getBefore())).addFollower(constraint.getAfter());
        }
        LinkedList thisWave = new LinkedList();
        for (Map.Entry entry : key2scratch.entrySet()) {
            if (!((Scratch)entry.getValue()).ready()) continue;
            thisWave.add(entry.getKey());
        }
        while (thisWave.size() > 0) {
            LinkedList linkedList = new LinkedList();
            for (Object t : thisWave) {
                result.add(t);
                Scratch scratch = (Scratch)key2scratch.get(t);
                for (Object after : scratch.getFollowers()) {
                    if (!((Scratch)key2scratch.get(after)).decrement()) continue;
                    linkedList.add(after);
                }
            }
            thisWave = linkedList;
        }
        if (result.size() != entries.size()) {
            throw new IllegalStateException("Circular Dependency Detected");
        }
        return result;
    }

    Set<T> getEntries() {
        return Collections.unmodifiableSet(this.entries);
    }

    Set<Constraint<T>> getConstraints() {
        return Collections.unmodifiableSet(this.constraints);
    }

    private static class Scratch<T> {
        int priorCount = 0;
        List<T> followers = new LinkedList<T>();

        private Scratch() {
        }

        public final void increment() {
            ++this.priorCount;
        }

        public final boolean decrement() {
            --this.priorCount;
            return this.ready();
        }

        public final boolean ready() {
            return this.priorCount == 0;
        }

        public final void addFollower(T follower) {
            this.followers.add(follower);
        }

        public final Iterable<T> getFollowers() {
            return Collections.unmodifiableCollection(this.followers);
        }
    }

    static class Constraint<T> {
        public final T before;
        public final T after;

        Constraint(T before, T after) {
            this.before = before;
            this.after = after;
        }

        public final T getBefore() {
            return this.before;
        }

        public final T getAfter() {
            return this.after;
        }
    }
}

