/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import rapture.common.PluginConfig;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.plugin.install.PluginContentReader;

public class PluginUtils {
    private static final Logger log = Logger.getLogger(PluginUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginConfig getPluginConfigFromZip(String filename) {
        File zip = new File(filename);
        if (!zip.exists() || !zip.canRead()) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            ZipEntry configEntry = zipFile.getEntry("plugin.txt");
            if (configEntry != null && "plugin.txt".equals(configEntry.getName())) {
                try {
                    PluginConfig pluginConfig = (PluginConfig)JacksonUtil.objectFromJson((byte[])this.getContentFromEntry(zipFile, configEntry), PluginConfig.class);
                    return pluginConfig;
                }
                catch (Exception ex) {
                    throw RaptureExceptionFactory.create((String)("Plugin.txt manifest corrupt in zip file " + filename));
                }
            }
            log.info((Object)("No plugin.txt present in root level of zipfile: " + filename));
        }
        catch (ZipException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeprecatedFeatureName(String filename) {
        File zip = new File(filename);
        if (!zip.exists() || !zip.canRead()) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            ZipEntry configEntry = zipFile.getEntry("feature.txt");
            if (configEntry != null && "feature.txt".equals(configEntry.getName())) {
                try {
                    Map mapFromJson = JacksonUtil.getMapFromJson((String)new String(this.getContentFromEntry(zipFile, configEntry)));
                    String string = (String)mapFromJson.get("feature");
                    return string;
                }
                catch (Exception ex) {
                    throw RaptureExceptionFactory.create((String)("feature.txt manifest corrupt in zip file " + filename));
                }
            }
            log.info((Object)("No feature.txt present in root level of zipfile: " + filename));
        }
        catch (ZipException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private byte[] getContentFromEntry(ZipFile zip, ZipEntry entry) throws IOException {
        return PluginContentReader.readFromStream((InputStream)zip.getInputStream(entry));
    }
}

