/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin.validators;

import java.util.List;
import rapture.common.RaptureURI;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.plugin.validators.Note;
import rapture.plugin.validators.Validator;

public abstract class JsonValidator<T>
implements Validator {
    Class<T> clazz;

    public JsonValidator(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void validate(String content, RaptureURI uri, List<Note> errors) {
        if (uri.hasAttribute() && this.needsRawValidation()) {
            this.validateRaw(content, uri, errors);
        }
        Object thing = null;
        try {
            thing = JacksonUtil.objectFromJson((String)content, this.clazz);
        }
        catch (Exception ex) {
            errors.add(new Note(Note.Level.ERROR, "Failed to parse Json for " + uri.toString()));
            return;
        }
        this.validateObject(thing, uri, errors);
    }

    public boolean needsRawValidation() {
        return false;
    }

    abstract void validateObject(T var1, RaptureURI var2, List<Note> var3);

    abstract void validateRaw(String var1, RaptureURI var2, List<Note> var3);
}

